/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import net.mehvahdjukaar.polytone.PlatStuff;
import net.mehvahdjukaar.polytone.PolytoneRenderTypes;
import net.mehvahdjukaar.polytone.biome.BiomeEffectsManager;
import net.mehvahdjukaar.polytone.biome.BiomeIdMapperManager;
import net.mehvahdjukaar.polytone.block.BlockPropertiesManager;
import net.mehvahdjukaar.polytone.block.BlockSetManager;
import net.mehvahdjukaar.polytone.color.ColorManager;
import net.mehvahdjukaar.polytone.colormap.ColormapsManager;
import net.mehvahdjukaar.polytone.dimension.DimensionEffectsManager;
import net.mehvahdjukaar.polytone.entity.EntityModifiersManager;
import net.mehvahdjukaar.polytone.fluid.FluidPropertiesManager;
import net.mehvahdjukaar.polytone.item.ItemModifiersManager;
import net.mehvahdjukaar.polytone.lightmap.LightmapsManager;
import net.mehvahdjukaar.polytone.noise.NoiseManager;
import net.mehvahdjukaar.polytone.particle.CustomParticlesManager;
import net.mehvahdjukaar.polytone.particle.ParticleModifiersManager;
import net.mehvahdjukaar.polytone.slotify.GuiModifierManager;
import net.mehvahdjukaar.polytone.slotify.GuiOverlayManager;
import net.mehvahdjukaar.polytone.sound.SoundTypesManager;
import net.mehvahdjukaar.polytone.tabs.CreativeTabsModifiersManager;
import net.mehvahdjukaar.polytone.texture.VariantTextureManager;
import net.mehvahdjukaar.polytone.utils.BiomeKeysCache;
import net.mehvahdjukaar.polytone.utils.CompoundReloader;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2874;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import net.minecraft.class_370;
import net.minecraft.class_374;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.FileAppender;
import org.apache.logging.log4j.core.config.Configuration;
import org.spongepowered.asm.mixin.MixinEnvironment;

public class Polytone {
    public static final String MOD_ID = "polytone";
    public static final Logger LOGGER = LogManager.getLogger((String)"Polytone");
    public static final BlockPropertiesManager BLOCK_MODIFIERS = new BlockPropertiesManager();
    public static final FluidPropertiesManager FLUID_MODIFIERS = new FluidPropertiesManager();
    public static final ItemModifiersManager ITEM_MODIFIERS = new ItemModifiersManager();
    public static final BiomeEffectsManager BIOME_MODIFIERS = new BiomeEffectsManager();
    public static final NoiseManager NOISES = new NoiseManager();
    public static final ColormapsManager COLORMAPS = new ColormapsManager();
    public static final LightmapsManager LIGHTMAPS = new LightmapsManager();
    public static final BiomeIdMapperManager BIOME_ID_MAPPERS = new BiomeIdMapperManager();
    public static final DimensionEffectsManager DIMENSION_MODIFIERS = new DimensionEffectsManager();
    public static final CustomParticlesManager CUSTOM_PARTICLES = new CustomParticlesManager();
    public static final ParticleModifiersManager PARTICLE_MODIFIERS = new ParticleModifiersManager();
    public static final EntityModifiersManager ENTITY_MODIFIERS = new EntityModifiersManager();
    public static final SoundTypesManager SOUND_TYPES = new SoundTypesManager();
    public static final VariantTextureManager VARIANT_TEXTURES = new VariantTextureManager();
    public static final ColorManager COLORS = new ColorManager();
    public static final GuiModifierManager SLOTIFY = new GuiModifierManager();
    public static final GuiOverlayManager OVERLAY_MODIFIERS = new GuiOverlayManager();
    public static final BlockSetManager BLOCK_SET = new BlockSetManager();
    public static final CreativeTabsModifiersManager CREATIVE_TABS_MODIFIERS = new CreativeTabsModifiersManager();
    private static final Set<class_2960> EXTRA_MODELS = new HashSet<class_2960>();
    private static CompoundReloader COMPOUND_RELOADER;
    private static final Future<Set<class_2960>> FUTURE_IDS;
    public static boolean iMessedUp;
    public static boolean sodiumOn;
    public static boolean isDevEnv;
    public static boolean isForge;
    public static boolean iris;

    public static void init(boolean isSodiumOn, boolean devEnv, boolean forge, boolean iris) {
        COMPOUND_RELOADER = new CompoundReloader(NOISES, SOUND_TYPES, BIOME_ID_MAPPERS, COLORMAPS, CUSTOM_PARTICLES, COLORS, BLOCK_SET, BLOCK_MODIFIERS, FLUID_MODIFIERS, ITEM_MODIFIERS, BIOME_MODIFIERS, VARIANT_TEXTURES, LIGHTMAPS, DIMENSION_MODIFIERS, PARTICLE_MODIFIERS, SLOTIFY, OVERLAY_MODIFIERS, ENTITY_MODIFIERS, CREATIVE_TABS_MODIFIERS);
        PlatStuff.addClientReloadListener(() -> COMPOUND_RELOADER, Polytone.res("polytone_stuff"));
        sodiumOn = isSodiumOn;
        isDevEnv = devEnv;
        isForge = forge;
        Polytone.iris = iris;
        if (isDevEnv) {
            MixinEnvironment.getCurrentEnvironment().audit();
        }
        PolytoneRenderTypes.init();
        PlatStuff.addSpecialModelRegistration(Polytone::addSpecialModels);
    }

    private static void addSpecialModels(PlatStuff.SpecialModelEvent event) {
        for (class_2960 m : EXTRA_MODELS) {
            event.register(m);
        }
        LOGGER.info("Registered {} extra models", (Object)EXTRA_MODELS.size());
        EXTRA_MODELS.clear();
    }

    public static class_2960 res(String name) {
        return new class_2960(MOD_ID, name);
    }

    public static void onTagsReceived(class_5455 registryAccess) {
        try {
            if (isDevEnv) {
                Polytone.scanAllRegistries(registryAccess);
            }
            COMPOUND_RELOADER.applyWithLevel(registryAccess, false);
            BiomeKeysCache.clear();
        }
        catch (RuntimeException e) {
            LOGGER.error("Failed to apply some Polytone modifiers on world load", (Throwable)e);
            class_374 toastComponent = class_310.method_1551().method_1566();
            class_370.method_1990((class_374)toastComponent, (class_370.class_371)class_370.class_371.field_21809, (class_2561)class_2561.method_43471((String)"toast.polytone.lazy_load_fail"), (class_2561)class_2561.method_43471((String)"toast.polytone.load_fail"));
        }
    }

    public static void onLoggedOut() {
        COMPOUND_RELOADER.resetWithLevel(true);
        BiomeKeysCache.clear();
    }

    public static void onEarlyPackLoad(class_3300 manager) {
        COMPOUND_RELOADER.earlyProcess(manager);
    }

    public static void logException(Exception e, String message) {
        String logDir = Polytone.getLog4jDirectory().orElse(Paths.get("logs", new String[0]).toAbsolutePath().toString());
        String logFilePath = Paths.get(logDir, "polytone.log").toString();
        try (PrintWriter writer = new PrintWriter(new FileWriter(logFilePath, false));){
            writer.println("Polytone version: " + PlatStuff.getVersion());
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
            String timestamp = LocalDateTime.now().format(formatter);
            writer.println("[" + timestamp + "] " + message + ". Check lines below to see where the error was:");
            e.printStackTrace(writer);
        }
        catch (IOException ioException) {
            LOGGER.error("Failed to log onto polytone.log", (Throwable)ioException);
        }
    }

    private static Optional<String> getLog4jDirectory() {
        LoggerContext context = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration config = context.getConfiguration();
        return config.getAppenders().values().stream().filter(appender -> appender instanceof FileAppender).map(appender -> ((FileAppender)appender).getFileName()).map(x$0 -> Paths.get(x$0, new String[0])).map(Path::getParent).map(Path::toString).findFirst();
    }

    public static void addCustomModel(class_2960 model) {
        EXTRA_MODELS.add(model);
    }

    public static boolean isEntryDynamic(class_2378<?> reg, class_2960 entryId) {
        if (reg == class_7923.field_44687) {
            return CREATIVE_TABS_MODIFIERS.isDynamicTab(entryId);
        }
        if (reg == class_7923.field_41180) {
            return CUSTOM_PARTICLES.isDynamicParticle(entryId);
        }
        if (reg == class_7923.field_41172) {
            return SOUND_TYPES.isDynamicSound(entryId);
        }
        return false;
    }

    public static boolean isFutureId(class_2960 id) {
        try {
            boolean isFuture = FUTURE_IDS.get().contains(id);
            if (isFuture) {
                LOGGER.error("Found an ID from a future Minecraft version ({}). Polytone will skip it but this is remains a bug of the Resource Pack. Optional entries or resource conditions should be used to maintain backward compatibility instead", (Object)id);
            }
            return isFuture;
        }
        catch (Exception e) {
            LOGGER.error("Failed to check if ID is from a future version", (Throwable)e);
            return false;
        }
    }

    private static void scanAllRegistries(class_5455 provider) {
        List<class_5321> regs = List.of(class_7924.field_41225, class_7924.field_41236, class_7924.field_41254, class_7924.field_41197, class_7924.field_41210, class_7924.field_41270, class_7924.field_41215, class_7924.field_41208);
        try (BufferedWriter writer = new BufferedWriter(new FileWriter("registry_dump.txt"));){
            for (class_5321 v : regs) {
                class_7225.class_7226 reg = provider.method_46762(v);
                for (class_6880.class_6883 e : reg.method_42017().toList()) {
                    writer.write(e.method_40237().method_29177().toString());
                    writer.newLine();
                }
            }
            System.out.println("File written successfully!");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static Set<class_2960> loadFutureIds() {
        InputStream res = Polytone.class.getClassLoader().getResourceAsStream("future_ids.txt");
        HashSet<class_2960> futureIds = new HashSet<class_2960>();
        if (res != null) {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(res));){
                String line;
                while ((line = reader.readLine()) != null) {
                    class_2960 id = class_2960.method_12829((String)line);
                    if (id != null) {
                        futureIds.add(id);
                        continue;
                    }
                    LOGGER.warn("Invalid ResourceLocation in future_ids.txt: {}", (Object)line);
                }
            }
            catch (IOException e) {
                LOGGER.error("Failed to read future_ids.txt", (Throwable)e);
            }
        }
        return futureIds;
    }

    public static void onDimChanged(class_1937 to) {
        DIMENSION_MODIFIERS.onDimensionChanged((class_6880<class_2874>)to.method_40134(), to.method_30349());
    }

    static {
        FUTURE_IDS = CompletableFuture.supplyAsync(Polytone::loadFutureIds);
        iMessedUp = false;
        sodiumOn = false;
        isDevEnv = false;
        isForge = false;
    }
}

