/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.colormap;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.mehvahdjukaar.polytone.biome.BiomeIdMapper;
import net.mehvahdjukaar.polytone.colormap.ColormapExpressionProvider;
import net.mehvahdjukaar.polytone.utils.ClientFrameTicker;
import net.mehvahdjukaar.polytone.utils.ColorUtils;
import net.mehvahdjukaar.polytone.utils.ExpressionUtils;
import net.mehvahdjukaar.polytone.utils.exp.IExpression;
import net.mehvahdjukaar.polytone.utils.exp.PolytoneExpression;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_1944;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import org.jetbrains.annotations.Nullable;

public class ColormapColorModulatorExpression {
    public static Codec<ColormapColorModulatorExpression> CODEC = RecordCodecBuilder.create(i -> i.group((App)Exp.CODEC.optionalFieldOf("red").forGetter(c -> c.red), (App)Exp.CODEC.optionalFieldOf("green").forGetter(c -> c.green), (App)Exp.CODEC.optionalFieldOf("blue").forGetter(c -> c.blue)).apply((Applicative)i, ColormapColorModulatorExpression::new));
    private final Optional<Exp> red;
    private final Optional<Exp> green;
    private final Optional<Exp> blue;

    protected ColormapColorModulatorExpression(Optional<Exp> red, Optional<Exp> green, Optional<Exp> blue) {
        this.red = red;
        this.green = green;
        this.blue = blue;
    }

    public ColormapColorModulatorExpression createConcurrent() {
        return new ColormapColorModulatorExpression(this.red.map(Exp::createConcurrent), this.green.map(Exp::createConcurrent), this.blue.map(Exp::createConcurrent));
    }

    public int getValue(int original, @Nullable class_2680 state, @Nullable class_2338 pos, @Nullable class_1959 biome, @Nullable BiomeIdMapper mapper, @Nullable class_1799 stack) {
        float[] values = ColorUtils.unpack(original);
        float red = values[0];
        float green = values[1];
        float blue = values[2];
        float newRed = this.red.map(exp -> Float.valueOf(exp.getValue(red, green, blue, state, pos, biome, mapper, stack))).orElse(Float.valueOf(red)).floatValue();
        float newGreen = this.green.map(exp -> Float.valueOf(exp.getValue(red, green, blue, state, pos, biome, mapper, stack))).orElse(Float.valueOf(green)).floatValue();
        float newBlue = this.blue.map(exp -> Float.valueOf(exp.getValue(red, green, blue, state, pos, biome, mapper, stack))).orElse(Float.valueOf(blue)).floatValue();
        return ColorUtils.pack(newRed, newGreen, newBlue);
    }

    protected static class Exp
    extends ColormapExpressionProvider {
        private static final String RED = "RED";
        private static final String GREEN = "GREEN";
        private static final String BLUE = "BLUE";
        private static final String ALPHA = "ALPHA";
        protected static final Codec<Exp> CODEC = Codec.STRING.flatXmap(s -> {
            try {
                return DataResult.success((Object)new Exp((String)s));
            }
            catch (Exception e) {
                return DataResult.error(() -> "Failed to parse expression:" + e.getMessage());
            }
        }, javaxExpression -> DataResult.success((Object)javaxExpression.getUnparsed()));

        protected Exp(String unparsed) {
            super(unparsed);
        }

        protected Exp(String unparsed, boolean concurrent) {
            super(unparsed, concurrent);
        }

        public float getValue(float r, float g, float b, @Nullable class_2680 state, @Nullable class_2338 pos, @Nullable class_1959 biome, @Nullable BiomeIdMapper mapper, @Nullable class_1799 stack) {
            class_1297 e;
            if (pos == null) {
                pos = class_2338.field_10980;
                ExpressionUtils.randomizeRandom();
            } else {
                ExpressionUtils.seedRandom((long)pos.hashCode() * pos.method_10063());
            }
            IExpression.IVars vb = this.expression.varBuilder();
            vb.setVariable(RED, r);
            vb.setVariable(GREEN, g);
            vb.setVariable(BLUE, b);
            if (this.hasPos) {
                vb.setVariable("POS_X", pos.method_10263());
                vb.setVariable("POS_Y", pos.method_10264());
                vb.setVariable("POS_Z", pos.method_10260());
            }
            if (this.hasTime) {
                vb.setVariable("TIME", ClientFrameTicker.getGameTime());
            }
            if (this.hasDayTime) {
                vb.setVariable("DAY_TIME", ClientFrameTicker.getDayTime());
            }
            if (this.hasSunTime) {
                vb.setVariable("SUN_TIME", ClientFrameTicker.getSunTime());
            }
            if (this.hasRain) {
                vb.setVariable("RAIN", ClientFrameTicker.getRainAndThunder());
            }
            if (this.hasSkyLight) {
                vb.setVariable("SKY_LIGHT", class_310.method_1551().field_1687.method_8314(class_1944.field_9284, pos));
            }
            if (this.hasBlockLight) {
                vb.setVariable("BLOCK_LIGHT", class_310.method_1551().field_1687.method_8314(class_1944.field_9282, pos));
            }
            if (this.hasTemperature) {
                vb.setVariable("TEMPERATURE", biome != null ? (double)ColorUtils.getClimateSettings((class_1959)biome).comp_844 : 0.0);
            }
            if (this.hasDownfall) {
                vb.setVariable("DOWNFALL", biome != null ? (double)ColorUtils.getClimateSettings((class_1959)biome).comp_846 : 0.0);
            }
            if (this.hasPlayer) {
                e = class_310.method_1551().method_1560();
                vb.setVariable("PLAYER_X", e.method_23317());
                vb.setVariable("PLAYER_Y", e.method_23318());
                vb.setVariable("PLAYER_Z", e.method_23321());
            }
            if (this.hasDistance) {
                e = class_310.method_1551().method_1560();
                double x = (double)pos.method_10263() - e.method_23317();
                double y = (double)pos.method_10264() - e.method_23318();
                double z = (double)pos.method_10260() - e.method_23321();
                vb.setVariable("DISTANCE_SQUARED", x * x + y * y + z * z);
            }
            if (this.hasPlayerSpeed) {
                vb.setVariable("PLAYER_SPEED_SQUARED", ClientFrameTicker.getPlayerSpeed());
            }
            if (this.hasRenderDistance) {
                vb.setVariable("RENDER_DISTANCE", ClientFrameTicker.getRenderDistance());
            }
            if (stack != null) {
                float damage = 1.0f - (float)stack.method_7919() / (float)stack.method_7936();
                vb.setVariable("DAMAGE", damage);
            } else {
                vb.setVariable("DAMAGE", 0.0);
            }
            if (this.hasState) {
                STATE_HACK.set(state);
            }
            float result = (float)this.expression.evaluate(vb);
            STATE_HACK.remove();
            return result;
        }

        @Override
        public Exp createConcurrent() {
            return new Exp(this.getUnparsed(), true);
        }

        @Override
        protected void buildVars(PolytoneExpression.VarBuilder builder) {
            super.buildVars(builder);
            builder.add(RED);
            builder.add(GREEN);
            builder.add(BLUE);
            builder.add(ALPHA);
        }
    }
}

