/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.dimension;

import com.google.gson.JsonElement;
import com.llamalad7.mixinextras.sugar.ref.LocalFloatRef;
import it.unimi.dsi.fastutil.objects.Object2BooleanArrayMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.mehvahdjukaar.polytone.Polytone;
import net.mehvahdjukaar.polytone.block.BlockContextExpression;
import net.mehvahdjukaar.polytone.colormap.Colormap;
import net.mehvahdjukaar.polytone.colormap.ColormapsManager;
import net.mehvahdjukaar.polytone.colormap.IColorGetter;
import net.mehvahdjukaar.polytone.dimension.DimensionEffectsModifier;
import net.mehvahdjukaar.polytone.utils.ArrayImage;
import net.mehvahdjukaar.polytone.utils.ClientFrameTicker;
import net.mehvahdjukaar.polytone.utils.ColorUtils;
import net.mehvahdjukaar.polytone.utils.JsonImgPartialReloader;
import net.mehvahdjukaar.polytone.utils.MapRegistry;
import net.mehvahdjukaar.polytone.utils.Parsed;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2874;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_322;
import net.minecraft.class_3532;
import net.minecraft.class_4543;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_638;
import net.minecraft.class_6491;
import net.minecraft.class_6880;
import net.minecraft.class_6903;
import org.jetbrains.annotations.Nullable;

public class DimensionEffectsManager
extends JsonImgPartialReloader {
    private final MapRegistry<DimensionEffectsModifier> dimensionEffects = new MapRegistry("Dimension Effects Modifiers");
    private final Map<class_2960, DimensionEffectsModifier> alteredVanillaEffects = new HashMap<class_2960, DimensionEffectsModifier>();
    private final Object2ObjectMap<class_2874, IColorGetter> fogColormaps = new Object2ObjectArrayMap();
    private final Object2ObjectMap<class_2874, IColorGetter> terrainFogColormaps = new Object2ObjectArrayMap();
    private final Object2ObjectMap<class_2874, IColorGetter> skyColormaps = new Object2ObjectArrayMap();
    private final Object2ObjectMap<class_2874, IColorGetter> sunsetColormaps = new Object2ObjectArrayMap();
    private final Object2ObjectMap<class_2874, BlockContextExpression> cloudFunctions = new Object2ObjectArrayMap();
    private final Object2BooleanArrayMap<class_2874> cancelFogWeatherDarken = new Object2BooleanArrayMap();
    private final Object2BooleanArrayMap<class_2874> cancelSkyWeatherDarken = new Object2BooleanArrayMap();
    private boolean needsDynamicApplication = true;
    private final Map<class_2960, Parsed<DimensionEffectsModifier>> extraMods = new HashMap<class_2960, Parsed<DimensionEffectsModifier>>();
    private static float[] lastSunset = null;

    public DimensionEffectsManager() {
        super("dimension_modifiers", "dimension_effects");
    }

    @Override
    protected void resetWithLevel(boolean logOff) {
        this.needsDynamicApplication = true;
        this.dimensionEffects.clear();
        this.fogColormaps.clear();
        this.skyColormaps.clear();
        this.sunsetColormaps.clear();
        this.cancelFogWeatherDarken.clear();
        this.cancelSkyWeatherDarken.clear();
        this.extraMods.clear();
    }

    @Override
    protected void parseWithLevel(JsonImgPartialReloader.Resources resources, class_6903<JsonElement> ops, class_5455 access) {
        class_2960 id;
        Map<class_2960, JsonElement> jsons = resources.jsons();
        HashMap<class_2960, ArrayImage> textures = new HashMap<class_2960, ArrayImage>(resources.textures());
        HashSet<class_2960> usedTextures = new HashSet<class_2960>();
        Parsed.SortedMap<DimensionEffectsModifier> parsedModifiers = Parsed.batchParseAlways(jsons, DimensionEffectsModifier.CODEC, ops, "dimension modifier");
        parsedModifiers.putAll(this.extraMods);
        for (Map.Entry<class_2960, Parsed<DimensionEffectsModifier>> entry : parsedModifiers) {
            class_2960 sunsetId;
            class_2960 fogId;
            class_2960 skyId;
            id = entry.getKey();
            Parsed<DimensionEffectsModifier> parsed = entry.getValue();
            DimensionEffectsModifier modifier = parsed.getResultOrPartial();
            class_322 fog = modifier.getFogColormap();
            class_322 sky = modifier.getSkyColormap();
            class_322 sunset = modifier.getSunsetColormap();
            if (textures.containsKey(id) && fog == null && sky == null) {
                modifier = modifier.merge(DimensionEffectsModifier.ofFogColor(Colormap.createDefTriangle()));
                fog = modifier.getFogColormap();
            }
            if (textures.containsKey(skyId = id.method_48331("_sky")) && sky == null) {
                modifier = modifier.merge(DimensionEffectsModifier.ofSkyColor(Colormap.createDefTriangle()));
                sky = modifier.getSkyColormap();
            }
            if (textures.containsKey(fogId = id.method_48331("_fog")) && sky == null) {
                modifier = modifier.merge(DimensionEffectsModifier.ofFogColor(Colormap.createDefTriangle()));
                fog = modifier.getFogColormap();
            }
            if (textures.containsKey(sunsetId = id.method_48331("_sunset")) && sunset == null) {
                modifier = modifier.merge(DimensionEffectsModifier.ofSunsetColor(Colormap.createTimeStrip()));
                sunset = modifier.getSunsetColormap();
            }
            if (fog != null ^ sky != null ^ sunset != null) {
                ColormapsManager.tryAcceptingTexture(textures, id, fog, usedTextures, false);
                ColormapsManager.tryAcceptingTexture(textures, id, sky, usedTextures, false);
                ColormapsManager.tryAcceptingTexture(textures, id, sunset, usedTextures, false);
            }
            ColormapsManager.tryAcceptingTexture(textures, fogId, fog, usedTextures, true);
            ColormapsManager.tryAcceptingTexture(textures, skyId, sky, usedTextures, true);
            ColormapsManager.tryAcceptingTexture(textures, sunsetId, sunset, usedTextures, true);
            if (!parsed.isEnabled()) continue;
            this.addModifier(id, modifier, access);
        }
        textures.keySet().removeAll(usedTextures);
        for (Map.Entry<class_2960, Object> entry : textures.entrySet()) {
            id = entry.getKey();
            Colormap defaultColormap = Colormap.createDefTriangle();
            ColormapsManager.tryAcceptingTexture(textures, id, (Object)defaultColormap, usedTextures, true);
            this.addModifier(id, DimensionEffectsModifier.ofFogColor(defaultColormap), access);
        }
    }

    private void addModifier(class_2960 fileId, DimensionEffectsModifier mod, class_5455 registryAccess) {
        this.dimensionEffects.register(fileId, mod);
    }

    @Override
    protected void applyWithLevel(class_5455 access, boolean isLogIn) {
        if (!isLogIn && !this.needsDynamicApplication) {
            return;
        }
        this.needsDynamicApplication = false;
        for (Map.Entry<class_2960, DimensionEffectsModifier> v : this.alteredVanillaEffects.entrySet()) {
            v.getValue().applyInplace(v.getKey());
        }
        class_638 level = class_310.method_1551().field_1687;
        if (level != null) {
            this.onDimensionChanged((class_6880<class_2874>)level.method_40134(), access);
        }
    }

    public void onDimensionChanged(class_6880<class_2874> currentDimHolder, class_5455 access) {
        class_2874 currentDim = (class_2874)currentDimHolder.comp_349();
        class_2960 currentDimId = ((class_5321)currentDimHolder.method_40230().get()).method_29177();
        for (Map.Entry<class_2960, DimensionEffectsModifier> v : this.dimensionEffects.getEntries()) {
            IColorGetter c;
            class_2960 modId = v.getKey();
            DimensionEffectsModifier modifier = v.getValue();
            Collection<class_6880<class_2874>> targets = modifier.targets().compute(modId, access);
            if (!targets.contains(currentDimHolder)) continue;
            DimensionEffectsModifier old = modifier.applyInplace(currentDimId);
            this.alteredVanillaEffects.put(currentDimId, old);
            class_322 class_3222 = modifier.getFogColormap();
            if (class_3222 instanceof IColorGetter) {
                c = (IColorGetter)class_3222;
                this.fogColormaps.put((Object)currentDim, (Object)c);
            }
            if ((class_3222 = modifier.getSkyColormap()) instanceof Colormap) {
                c = (Colormap)class_3222;
                this.skyColormaps.put((Object)currentDim, (Object)c);
            }
            if ((class_3222 = modifier.getSunsetColormap()) instanceof IColorGetter) {
                c = (IColorGetter)class_3222;
                this.sunsetColormaps.put((Object)currentDim, (Object)c);
            }
            if (modifier.noWeatherFogDarken()) {
                this.cancelFogWeatherDarken.put((Object)currentDim, true);
            }
            if (modifier.noWeatherSkyDarken()) {
                this.cancelSkyWeatherDarken.put((Object)currentDim, true);
            }
            if (modifier.cloudLevel().isPresent() && modifier.cloudLevel().get().right().isPresent()) {
                this.cloudFunctions.put((Object)currentDim, (Object)((BlockContextExpression)modifier.cloudLevel().get().right().get()));
            }
            Polytone.LOGGER.info("Applied Custom Dimension Effects Modifier '{}' to dimension '{}'", (Object)modId, currentDimHolder);
        }
    }

    @Nullable
    public class_243 modifyFogColor(class_243 center, class_638 level, float brightness) {
        IColorGetter colormap = (IColorGetter)this.fogColormaps.get((Object)level.method_8597());
        if (colormap == null) {
            return null;
        }
        class_4543 biomeManager = level.method_22385();
        return level.method_28103().method_28112(class_6491.method_24895((class_243)center, (qx, qy, qz) -> {
            class_1959 biome = (class_1959)biomeManager.method_24854(qx, qy, qz).comp_349();
            int fogColor1 = colormap.sampleColor(null, class_2338.method_49637((double)(qx * 4), (double)(qy * 4), (double)(qz * 4)), biome, null);
            return class_243.method_24457((int)fogColor1);
        }), brightness);
    }

    public void modifyFogMagicNumber(float renderDistanceChunks, LocalFloatRef distance) {
        float c = 0.25f;
        float b = c + (1.0f - c) * renderDistanceChunks / 32.0f;
        b = 1.0f - (float)Math.pow(b, 0.25);
        float a = 1.0f * renderDistanceChunks / 32.0f;
        a = 1.0f - (float)Math.pow(a, 0.25);
        distance.set(b);
    }

    @Nullable
    public class_243 modifySkyColor(class_243 center, class_638 level) {
        IColorGetter colormap = (IColorGetter)this.skyColormaps.get((Object)level.method_8597());
        if (colormap == null) {
            return null;
        }
        class_4543 biomeManager = level.method_22385();
        return class_6491.method_24895((class_243)center, (qx, qy, qz) -> {
            class_1959 biome = (class_1959)biomeManager.method_24854(qx, qy, qz).comp_349();
            int skyColor1 = colormap.sampleColor(null, class_2338.method_49637((double)(qx * 4), (double)(qy * 4), (double)(qz * 4)), biome, null);
            return class_243.method_24457((int)skyColor1);
        });
    }

    @Nullable
    public Float modifyCloudHeight(class_638 level) {
        BlockContextExpression height = (BlockContextExpression)this.cloudFunctions.get((Object)level.method_8597());
        if (height == null) {
            return null;
        }
        class_2338 pos = ClientFrameTicker.getCameraPos();
        double v = height.getValue((class_1937)level, pos, class_2246.field_10124.method_9564());
        if (v >= 10000.0) {
            return Float.valueOf(Float.NaN);
        }
        return Float.valueOf((float)v);
    }

    public boolean shouldCancelFogWeatherDarken(class_1937 level) {
        return this.cancelFogWeatherDarken.getOrDefault((Object)level.method_8597(), false);
    }

    public boolean shouldCancelSkyWeatherDarken(class_1937 level) {
        return this.cancelSkyWeatherDarken.getOrDefault((Object)level.method_8597(), false);
    }

    public void addConvertedBlockProperties(Map<class_2960, Parsed<DimensionEffectsModifier>> converted) {
        this.extraMods.clear();
        this.extraMods.putAll(converted);
    }

    public float @Nullable [] modifySunsetColor(float[] old) {
        IColorGetter colormap = (IColorGetter)this.sunsetColormaps.get((Object)class_310.method_1551().field_1687.method_8597());
        if (colormap == null) {
            return null;
        }
        int color = colormap.sampleColor(null, ClientFrameTicker.getCameraPos(), (class_1959)ClientFrameTicker.getCameraBiome().comp_349(), null);
        float deltaTime = ClientFrameTicker.getDeltaTime();
        float interpolationFactor = deltaTime * 0.1f;
        float[] c = ColorUtils.unpack(color);
        if (lastSunset == null) {
            lastSunset = new float[]{c[0], c[1], c[2], old[3]};
            return lastSunset;
        }
        DimensionEffectsManager.lastSunset[0] = class_3532.method_16439((float)interpolationFactor, (float)lastSunset[0], (float)c[0]);
        DimensionEffectsManager.lastSunset[1] = class_3532.method_16439((float)interpolationFactor, (float)lastSunset[1], (float)c[1]);
        DimensionEffectsManager.lastSunset[2] = class_3532.method_16439((float)interpolationFactor, (float)lastSunset[2], (float)c[2]);
        DimensionEffectsManager.lastSunset[3] = old[3];
        return lastSunset;
    }
}

