/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.tabs;

import java.util.Set;
import net.minecraft.class_1799;
import net.minecraft.class_2479;
import net.minecraft.class_2481;
import net.minecraft.class_2487;
import net.minecraft.class_2489;
import net.minecraft.class_2494;
import net.minecraft.class_2495;
import net.minecraft.class_2497;
import net.minecraft.class_2499;
import net.minecraft.class_2501;
import net.minecraft.class_2503;
import net.minecraft.class_2516;
import net.minecraft.class_2519;
import net.minecraft.class_2520;

public class ItemStackHelper {
    public static boolean matchItemsLenientBytes(class_1799 stack, class_1799 other) {
        if (stack == other) {
            return true;
        }
        return stack.method_7947() == other.method_7947() && ItemStackHelper.sameItemSameTagLenient(stack, other);
    }

    private static boolean sameItemSameTagLenient(class_1799 stack, class_1799 other) {
        if (!stack.method_31574(other.method_7909())) {
            return false;
        }
        return stack.method_7960() && other.method_7960() || ItemStackHelper.sameTagLenientBytes(stack.method_7969(), other.method_7969());
    }

    public static boolean sameTagLenientBytes(class_2487 tag1, class_2487 tag2) {
        Set keys2;
        if (tag1 == tag2) {
            return true;
        }
        if (tag1 == null || tag2 == null) {
            return false;
        }
        Set keys1 = tag1.method_10541();
        if (!keys1.equals(keys2 = tag2.method_10541())) {
            return false;
        }
        for (String key : keys1) {
            class_2520 t2;
            class_2520 t1 = tag1.method_10580(key);
            if (ItemStackHelper.sameTagLenientBytesTag(t1, t2 = tag2.method_10580(key))) continue;
            return false;
        }
        return true;
    }

    private static boolean sameTagLenientBytesTag(class_2520 t1, class_2520 t2) {
        if (t1 == t2) {
            return true;
        }
        if (t1 == null || t2 == null) {
            return false;
        }
        if (ItemStackHelper.isNumericTag(t1) && ItemStackHelper.isNumericTag(t2)) {
            return ItemStackHelper.numericEqual(ItemStackHelper.getNumericValue(t1), ItemStackHelper.getNumericValue(t2));
        }
        if (t1 instanceof class_2487 && t2 instanceof class_2487) {
            return ItemStackHelper.sameTagLenientBytes((class_2487)t1, (class_2487)t2);
        }
        if (t1 instanceof class_2499 && t2 instanceof class_2499) {
            class_2499 l1 = (class_2499)t1;
            class_2499 l2 = (class_2499)t2;
            if (l1.size() != l2.size()) {
                return false;
            }
            for (int i = 0; i < l1.size(); ++i) {
                if (ItemStackHelper.sameTagLenientBytesTag(l1.method_10534(i), l2.method_10534(i))) continue;
                return false;
            }
            return true;
        }
        if (t1 instanceof class_2479 && t2 instanceof class_2479) {
            byte[] a2;
            byte[] a1 = ((class_2479)t1).method_10521();
            if (a1.length != (a2 = ((class_2479)t2).method_10521()).length) {
                return false;
            }
            for (int i = 0; i < a1.length; ++i) {
                if (a1[i] == a2[i]) continue;
                return false;
            }
            return true;
        }
        if (t1 instanceof class_2495 && t2 instanceof class_2495) {
            int[] a2;
            int[] a1 = ((class_2495)t1).method_10588();
            if (a1.length != (a2 = ((class_2495)t2).method_10588()).length) {
                return false;
            }
            for (int i = 0; i < a1.length; ++i) {
                if (a1[i] == a2[i]) continue;
                return false;
            }
            return true;
        }
        if (t1 instanceof class_2501 && t2 instanceof class_2501) {
            long[] a2;
            long[] a1 = ((class_2501)t1).method_10615();
            if (a1.length != (a2 = ((class_2501)t2).method_10615()).length) {
                return false;
            }
            for (int i = 0; i < a1.length; ++i) {
                if (a1[i] == a2[i]) continue;
                return false;
            }
            return true;
        }
        if (t1 instanceof class_2519 && t2 instanceof class_2519) {
            return ((class_2519)t1).method_10714().equals(((class_2519)t2).method_10714());
        }
        return t1.equals((Object)t2);
    }

    private static boolean isNumericTag(class_2520 t) {
        return t instanceof class_2481 || t instanceof class_2516 || t instanceof class_2497 || t instanceof class_2503 || t instanceof class_2494 || t instanceof class_2489;
    }

    private static Number getNumericValue(class_2520 t) {
        if (t instanceof class_2481) {
            return ((class_2481)t).method_10698();
        }
        if (t instanceof class_2516) {
            return ((class_2516)t).method_10696();
        }
        if (t instanceof class_2497) {
            return ((class_2497)t).method_10701();
        }
        if (t instanceof class_2503) {
            return ((class_2503)t).method_10699();
        }
        if (t instanceof class_2494) {
            return Float.valueOf(((class_2494)t).method_10700());
        }
        if (t instanceof class_2489) {
            return ((class_2489)t).method_10697();
        }
        throw new IllegalArgumentException("Not a numeric tag: " + String.valueOf(t));
    }

    private static boolean numericEqual(Number n1, Number n2) {
        boolean n1Integral = ItemStackHelper.isIntegralNumber(n1);
        boolean n2Integral = ItemStackHelper.isIntegralNumber(n2);
        if (n1Integral && n2Integral) {
            return n1.longValue() == n2.longValue();
        }
        return Double.compare(n1.doubleValue(), n2.doubleValue()) == 0;
    }

    private static boolean isIntegralNumber(Number n) {
        return n instanceof Byte || n instanceof Short || n instanceof Integer || n instanceof Long;
    }
}

