/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import net.mehvahdjukaar.polytone.PlatStuff;
import net.mehvahdjukaar.polytone.PolytoneRenderTypes;
import net.mehvahdjukaar.polytone.biome.BiomeEffectsManager;
import net.mehvahdjukaar.polytone.biome.BiomeIdMapperManager;
import net.mehvahdjukaar.polytone.block.BlockPropertiesManager;
import net.mehvahdjukaar.polytone.block.BlockSetManager;
import net.mehvahdjukaar.polytone.color.ColorManager;
import net.mehvahdjukaar.polytone.colormap.ColormapsManager;
import net.mehvahdjukaar.polytone.dimension.DimensionEffectsManager;
import net.mehvahdjukaar.polytone.entity.EntityModifiersManager;
import net.mehvahdjukaar.polytone.fluid.FluidPropertiesManager;
import net.mehvahdjukaar.polytone.item.CustomItemModelsManager;
import net.mehvahdjukaar.polytone.item.ItemModifiersManager;
import net.mehvahdjukaar.polytone.lightmap.LightmapsManager;
import net.mehvahdjukaar.polytone.noise.NoiseManager;
import net.mehvahdjukaar.polytone.particle.CustomParticlesManager;
import net.mehvahdjukaar.polytone.particle.ParticleModifiersManager;
import net.mehvahdjukaar.polytone.slotify.GuiModifierManager;
import net.mehvahdjukaar.polytone.slotify.GuiOverlayManager;
import net.mehvahdjukaar.polytone.sound.SoundTypesManager;
import net.mehvahdjukaar.polytone.tabs.CreativeTabsModifiersManager;
import net.mehvahdjukaar.polytone.texture.VariantTextureManager;
import net.mehvahdjukaar.polytone.utils.BiomeKeysCache;
import net.mehvahdjukaar.polytone.utils.CompoundReloader;
import net.mehvahdjukaar.polytone.utils.GenericDirectorySpriteSource;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.toasts.SystemToast;
import net.minecraft.client.gui.components.toasts.ToastComponent;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.FileAppender;
import org.apache.logging.log4j.core.config.Configuration;

public class Polytone {
    public static final String MOD_ID = "polytone";
    public static final Logger LOGGER = LogManager.getLogger((String)"Polytone");
    private static CompoundReloader COMPOUND_RELOADER;
    public static final BlockPropertiesManager BLOCK_MODIFIERS;
    public static final FluidPropertiesManager FLUID_MODIFIERS;
    public static final ItemModifiersManager ITEM_MODIFIERS;
    public static final CustomItemModelsManager ITEM_MODELS;
    public static final BiomeEffectsManager BIOME_MODIFIERS;
    public static final NoiseManager NOISES;
    public static final ColormapsManager COLORMAPS;
    public static final LightmapsManager LIGHTMAPS;
    public static final BiomeIdMapperManager BIOME_ID_MAPPERS;
    public static final DimensionEffectsManager DIMENSION_MODIFIERS;
    public static final CustomParticlesManager CUSTOM_PARTICLES;
    public static final ParticleModifiersManager PARTICLE_MODIFIERS;
    public static final EntityModifiersManager ENTITY_MODIFIERS;
    public static final SoundTypesManager SOUND_TYPES;
    public static final VariantTextureManager VARIANT_TEXTURES;
    public static final ColorManager COLORS;
    public static final GuiModifierManager SLOTIFY;
    public static final GuiOverlayManager OVERLAY_MODIFIERS;
    public static final BlockSetManager BLOCK_SET;
    public static final CreativeTabsModifiersManager CREATIVE_TABS_MODIFIERS;
    private static final Set<ModelResourceLocation> EXTRA_MODELS;
    private static final Future<Set<ResourceLocation>> FUTURE_IDS;
    public static boolean iMessedUp;
    public static boolean isDevEnv;
    public static boolean isForge;
    public static boolean iris;

    public static void init(boolean devEnv, boolean forge, boolean iris) {
        COMPOUND_RELOADER = new CompoundReloader(NOISES, SOUND_TYPES, BIOME_ID_MAPPERS, COLORMAPS, CUSTOM_PARTICLES, COLORS, BLOCK_SET, BLOCK_MODIFIERS, FLUID_MODIFIERS, ITEM_MODIFIERS, ITEM_MODELS, BIOME_MODIFIERS, VARIANT_TEXTURES, LIGHTMAPS, DIMENSION_MODIFIERS, PARTICLE_MODIFIERS, SLOTIFY, OVERLAY_MODIFIERS, ENTITY_MODIFIERS, CREATIVE_TABS_MODIFIERS);
        PlatStuff.addClientReloadListener(() -> COMPOUND_RELOADER, Polytone.res("polytone_stuff"));
        isDevEnv = devEnv;
        isForge = forge;
        Polytone.iris = iris;
        GenericDirectorySpriteSource.init();
        PolytoneRenderTypes.init();
        PlatStuff.addSpecialModelRegistration(Polytone::addSpecialModels);
    }

    private static void addSpecialModels(PlatStuff.SpecialModelEvent event) {
        for (ModelResourceLocation m : EXTRA_MODELS) {
            event.register(m);
        }
        LOGGER.info("Registered {} extra models", (Object)EXTRA_MODELS.size());
        EXTRA_MODELS.clear();
    }

    public static ResourceLocation res(String name) {
        return ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)name);
    }

    public static void onTagsReceived(RegistryAccess registryAccess) {
        try {
            if (isDevEnv) {
                Polytone.scanAllRegistries((HolderLookup.Provider)registryAccess);
            }
            COMPOUND_RELOADER.applyWithLevel(registryAccess, false);
            BiomeKeysCache.clear();
        }
        catch (RuntimeException e) {
            LOGGER.error("Failed to apply some Polytone modifiers on world load", (Throwable)e);
            ToastComponent toastComponent = Minecraft.getInstance().getToasts();
            SystemToast.addOrUpdate((ToastComponent)toastComponent, (SystemToast.SystemToastId)SystemToast.SystemToastId.PACK_LOAD_FAILURE, (Component)Component.translatable((String)"toast.polytone.lazy_load_fail"), (Component)Component.translatable((String)"toast.polytone.load_fail"));
        }
    }

    public static void onLoggedOut() {
        COMPOUND_RELOADER.resetWithLevel(true);
        BiomeKeysCache.clear();
    }

    public static void onEarlyPackLoad(ResourceManager manager) {
        COMPOUND_RELOADER.earlyProcess(manager);
    }

    public static void logException(Exception e, String message) {
        String logDir = Polytone.getLog4jDirectory().orElse(Paths.get("logs", new String[0]).toAbsolutePath().toString());
        String logFilePath = Paths.get(logDir, "polytone.log").toString();
        try (PrintWriter writer = new PrintWriter(new FileWriter(logFilePath, false));){
            writer.println("Polytone version: " + PlatStuff.getVersion());
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
            String timestamp = LocalDateTime.now().format(formatter);
            writer.println("[" + timestamp + "] " + message + ". Check lines below to see where the error was:");
            e.printStackTrace(writer);
        }
        catch (IOException ioException) {
            LOGGER.error("Failed to log onto polytone.log", (Throwable)ioException);
        }
    }

    private static Optional<String> getLog4jDirectory() {
        LoggerContext context = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration config = context.getConfiguration();
        return config.getAppenders().values().stream().filter(appender -> appender instanceof FileAppender).map(appender -> ((FileAppender)appender).getFileName()).map(x$0 -> Paths.get(x$0, new String[0])).map(Path::getParent).map(Path::toString).findFirst();
    }

    public static void addCustomModel(ModelResourceLocation model) {
        EXTRA_MODELS.add(model);
    }

    public static boolean isEntryDynamic(Registry<?> reg, ResourceLocation entryId) {
        if (reg == BuiltInRegistries.CREATIVE_MODE_TAB) {
            return CREATIVE_TABS_MODIFIERS.isDynamicTab(entryId);
        }
        if (reg == BuiltInRegistries.PARTICLE_TYPE) {
            return CUSTOM_PARTICLES.isDynamicParticle(entryId);
        }
        if (reg == BuiltInRegistries.SOUND_EVENT) {
            return SOUND_TYPES.isDynamicSound(entryId);
        }
        return false;
    }

    public static boolean isFutureId(ResourceLocation id) {
        try {
            boolean isFuture = FUTURE_IDS.get().contains(id);
            if (isFuture) {
                LOGGER.error("Found an ID from a future Minecraft version ({}). Polytone will skip it but this is remains a bug of the Resource Pack. Optional entries or resource conditions should be used to maintain backward compatibility instead", (Object)id);
            }
            return isFuture;
        }
        catch (Exception e) {
            LOGGER.error("Failed to check if ID is from a future version", (Throwable)e);
            return false;
        }
    }

    private static void scanAllRegistries(HolderLookup.Provider provider) {
        List<ResourceKey> regs = List.of(Registries.SOUND_EVENT, Registries.BIOME, Registries.BLOCK, Registries.ITEM, Registries.BLOCK_TYPE, Registries.PARTICLE_TYPE, Registries.FLUID, Registries.POTION, Registries.MOB_EFFECT);
        try (BufferedWriter writer = new BufferedWriter(new FileWriter("registry_dump.txt"));){
            for (ResourceKey v : regs) {
                HolderLookup.RegistryLookup reg = provider.lookupOrThrow(v);
                for (Holder.Reference e : reg.listElements().toList()) {
                    writer.write(e.getRegisteredName());
                    writer.newLine();
                }
            }
            System.out.println("File written successfully!");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static Set<ResourceLocation> loadFutureIds() {
        InputStream res = Polytone.class.getClassLoader().getResourceAsStream("future_ids.txt");
        HashSet<ResourceLocation> futureIds = new HashSet<ResourceLocation>();
        if (res != null) {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(res));){
                String line;
                while ((line = reader.readLine()) != null) {
                    ResourceLocation id = ResourceLocation.tryParse((String)line);
                    if (id != null) {
                        futureIds.add(id);
                        continue;
                    }
                    LOGGER.warn("Invalid ResourceLocation in future_ids.txt: {}", (Object)line);
                }
            }
            catch (IOException e) {
                LOGGER.error("Failed to read future_ids.txt", (Throwable)e);
            }
        }
        return futureIds;
    }

    static {
        BLOCK_MODIFIERS = new BlockPropertiesManager();
        FLUID_MODIFIERS = new FluidPropertiesManager();
        ITEM_MODIFIERS = new ItemModifiersManager();
        ITEM_MODELS = new CustomItemModelsManager();
        BIOME_MODIFIERS = new BiomeEffectsManager();
        NOISES = new NoiseManager();
        COLORMAPS = new ColormapsManager();
        LIGHTMAPS = new LightmapsManager();
        BIOME_ID_MAPPERS = new BiomeIdMapperManager();
        DIMENSION_MODIFIERS = new DimensionEffectsManager();
        CUSTOM_PARTICLES = new CustomParticlesManager();
        PARTICLE_MODIFIERS = new ParticleModifiersManager();
        ENTITY_MODIFIERS = new EntityModifiersManager();
        SOUND_TYPES = new SoundTypesManager();
        VARIANT_TEXTURES = new VariantTextureManager();
        COLORS = new ColorManager();
        SLOTIFY = new GuiModifierManager();
        OVERLAY_MODIFIERS = new GuiOverlayManager();
        BLOCK_SET = new BlockSetManager();
        CREATIVE_TABS_MODIFIERS = new CreativeTabsModifiersManager();
        EXTRA_MODELS = new HashSet<ModelResourceLocation>();
        FUTURE_IDS = CompletableFuture.supplyAsync(Polytone::loadFutureIds);
        iMessedUp = false;
        isDevEnv = false;
        isForge = false;
        iris = false;
    }
}

