/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.colormap;

import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ColorResolver;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public interface IColorGetter
extends BlockColor,
ItemColor {
    default public boolean needsToFillTexture() {
        return false;
    }

    default public IColorGetter makeConcurrent() {
        return this;
    }

    public int sampleColor(@Nullable BlockState var1, @Nullable BlockPos var2, @Nullable Biome var3, @Nullable ItemStack var4);

    public record OfItem(ItemColor ic) implements IColorGetter
    {
        public int getColor(BlockState state, BlockAndTintGetter reader, BlockPos pos, int tintIndex) {
            return this.ic.getColor(ItemStack.EMPTY, tintIndex);
        }

        public int getColor(ItemStack itemStack, int i) {
            return this.ic.getColor(itemStack, i);
        }

        @Override
        public int sampleColor(@Nullable BlockState state, @Nullable BlockPos pos, @Nullable Biome biome, @Nullable ItemStack item) {
            return this.ic.getColor(item == null ? ItemStack.EMPTY : item, 0);
        }
    }

    public record ofColorResolver(BlockColor bc, ColorResolver cr) implements IColorGetter,
    ColorResolver
    {
        public int getColor(BlockState state, @Nullable BlockAndTintGetter reader, @Nullable BlockPos pos, int tintIndex) {
            return this.bc.getColor(state, reader, pos, tintIndex);
        }

        public int getColor(ItemStack stack, int tintIndex) {
            Minecraft mc = Minecraft.getInstance();
            ClientLevel world = mc.level;
            if (world == null) {
                return -1;
            }
            BlockPos pos = mc.player.blockPosition();
            BlockState state = world.getBlockState(pos);
            return this.bc.getColor(state, (BlockAndTintGetter)world, pos, tintIndex) | 0xFF000000;
        }

        public int getColor(Biome biome, double x, double z) {
            return this.cr.getColor(biome, x, z);
        }

        @Override
        public int sampleColor(@Nullable BlockState state, @Nullable BlockPos pos, @Nullable Biome biome, @Nullable ItemStack item) {
            if (biome != null) {
                int x = pos == null ? 0 : pos.getX();
                int z = pos == null ? 0 : pos.getZ();
                return this.cr.getColor(biome, (double)x, (double)z);
            }
            return -1;
        }
    }

    public record OfBlock(BlockColor bc) implements IColorGetter
    {
        public int getColor(BlockState state, BlockAndTintGetter reader, BlockPos pos, int tintIndex) {
            return this.bc.getColor(state, reader, pos, tintIndex);
        }

        public int getColor(ItemStack itemStack, int i) {
            Minecraft mc = Minecraft.getInstance();
            ClientLevel world = mc.level;
            if (world == null) {
                return -1;
            }
            BlockPos pos = mc.player.blockPosition();
            BlockState state = world.getBlockState(pos);
            return this.bc.getColor(state, (BlockAndTintGetter)world, pos, i) | 0xFF000000;
        }

        @Override
        public int sampleColor(@Nullable BlockState state, @Nullable BlockPos pos, @Nullable Biome biome, @Nullable ItemStack item) {
            if (state != null && pos != null) {
                return this.bc.getColor(state, null, pos, 0) | 0xFF000000;
            }
            return -1;
        }
    }
}

