/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.item;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.mehvahdjukaar.polytone.PlatStuff;
import net.mehvahdjukaar.polytone.item.ItemModelOverride;
import net.mehvahdjukaar.polytone.utils.DepthSearchTrie;
import net.mehvahdjukaar.polytone.utils.FrequencyOrderedCollection;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.component.TypedDataComponent;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class ItemModelOverrideList {
    private final PropertiesSearchTrie overrides = new PropertiesSearchTrie();
    private final List<ItemModelOverride> entries = new ArrayList<ItemModelOverride>();
    private boolean populated = false;

    public void populateModels(RegistryAccess registryAccess) {
        this.overrides.clear();
        this.overrides.acceptEntries(this.entries);
        this.populated = true;
        this.entries.clear();
    }

    public void addAll(Collection<ItemModelOverride> itemModelOverrides) {
        this.entries.addAll(itemModelOverrides);
    }

    public void add(ItemModelOverride itemModelOverride) {
        this.entries.add(itemModelOverride);
    }

    @Nullable
    public BakedModel getModel(ItemStack stack, @Nullable Level level, @Nullable LivingEntity entity, int seed) {
        if (!this.populated) {
            return null;
        }
        return this.overrides.searchModel(stack, level, (Entity)entity);
    }

    public int size() {
        return this.entries.size();
    }

    public static class PropertiesSearchTrie
    extends DepthSearchTrie<Object, Object, ItemModelOverride, ItemStack> {
        private final List<DataComponentType<?>> orderedKeys = new ArrayList();

        @Override
        public void clear() {
            super.clear();
            this.orderedKeys.clear();
        }

        public BakedModel searchModel(ItemStack stack, @Nullable Level level, @Nullable Entity entity) {
            List list = this.search(stack);
            if (list == null || list.isEmpty()) {
                return null;
            }
            Component customName = (Component)stack.get(DataComponents.CUSTOM_NAME);
            for (ItemModelOverride modelOverride : list) {
                Supplier entityTagSupplier;
                if (!modelOverride.matchesPredicate(stack, level, (java.util.function.Supplier<CompoundTag>)(entityTagSupplier = entity == null ? null : Suppliers.memoize(() -> entity.saveWithoutId(new CompoundTag()))), customName)) continue;
                return PlatStuff.getBakedModel(modelOverride.model());
            }
            return null;
        }

        @Override
        protected Object getKeyOfType(Object folder) {
            if (folder instanceof TypedDataComponent) {
                TypedDataComponent t = (TypedDataComponent)folder;
                return t.type();
            }
            if (folder instanceof Integer) {
                return Integer.class;
            }
            return folder;
        }

        @Override
        protected Object getKeyFromType(Object type, ItemStack stack) {
            if (type instanceof DataComponentType) {
                DataComponentType t = (DataComponentType)type;
                return stack.getComponents().getTyped(t);
            }
            if (type == Integer.class) {
                return stack.getCount();
            }
            return null;
        }

        public void acceptEntries(List<ItemModelOverride> entries) {
            boolean hasCount = false;
            FrequencyOrderedCollection<DataComponentType> keyFrequencies = new FrequencyOrderedCollection<DataComponentType>();
            for (ItemModelOverride entry : entries) {
                if (entry.stackCount() != null) {
                    hasCount = true;
                }
                for (TypedDataComponent component : entry.components()) {
                    keyFrequencies.add(component.type());
                }
            }
            this.orderedKeys.addAll(keyFrequencies.stream().toList());
            for (ItemModelOverride entry : entries) {
                ArrayList<Integer> key = new ArrayList<Integer>();
                if (hasCount) {
                    key.add(entry.stackCount());
                }
                for (DataComponentType<?> type : this.orderedKeys) {
                    key.add((Integer)entry.components().getTyped(type));
                }
                this.insert(key, entry);
            }
        }
    }
}

