/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.particle;

import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.Optional;
import net.mehvahdjukaar.polytone.Polytone;
import net.mehvahdjukaar.polytone.particle.ExtraDataParticleOptions;
import net.mehvahdjukaar.polytone.particle.ParticleContextExpression;
import net.mehvahdjukaar.polytone.particle.ParticleTickable;
import net.mehvahdjukaar.polytone.utils.codec.BiggerCodecs;
import net.mehvahdjukaar.polytone.utils.codec.CodecUtils;
import net.minecraft.client.particle.Particle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.AlwaysTrueTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import org.jetbrains.annotations.Nullable;

public record ParticleParticleEmitter(Optional<Holder<ParticleType<?>>> particleType, ParticleContextExpression chance, ParticleContextExpression count, ParticleContextExpression x, ParticleContextExpression y, ParticleContextExpression z, ParticleContextExpression dx, ParticleContextExpression dy, ParticleContextExpression dz, Optional<ParticleContextExpression> r, Optional<ParticleContextExpression> g, Optional<ParticleContextExpression> b, Optional<ParticleContextExpression> a, Optional<ParticleContextExpression> roll, Optional<ParticleContextExpression> size, Optional<ParticleContextExpression> custom, RuleTest predicate, Optional<HolderSet<Biome>> biomes) implements ParticleTickable
{
    public static final Codec<ParticleParticleEmitter> CODEC = RecordCodecBuilder.create(i -> BiggerCodecs.group(i, CodecUtils.forwardAwareHolderByNameCodec(BuiltInRegistries.PARTICLE_TYPE).fieldOf("particle").forGetter(ParticleParticleEmitter::particleType), ParticleContextExpression.CODEC.optionalFieldOf("chance", (Object)ParticleContextExpression.ONE).forGetter(ParticleParticleEmitter::chance), ParticleContextExpression.CODEC.optionalFieldOf("count", (Object)ParticleContextExpression.ONE).forGetter(ParticleParticleEmitter::count), ParticleContextExpression.CODEC.optionalFieldOf("x", (Object)ParticleContextExpression.PARTICLE_RAND).forGetter(ParticleParticleEmitter::x), ParticleContextExpression.CODEC.optionalFieldOf("y", (Object)ParticleContextExpression.PARTICLE_RAND).forGetter(ParticleParticleEmitter::y), ParticleContextExpression.CODEC.optionalFieldOf("z", (Object)ParticleContextExpression.PARTICLE_RAND).forGetter(ParticleParticleEmitter::z), ParticleContextExpression.CODEC.optionalFieldOf("dx", (Object)ParticleContextExpression.ZERO).forGetter(ParticleParticleEmitter::dx), ParticleContextExpression.CODEC.optionalFieldOf("dy", (Object)ParticleContextExpression.ZERO).forGetter(ParticleParticleEmitter::dy), ParticleContextExpression.CODEC.optionalFieldOf("dz", (Object)ParticleContextExpression.ZERO).forGetter(ParticleParticleEmitter::dz), ParticleContextExpression.CODEC.optionalFieldOf("red").forGetter(ParticleParticleEmitter::r), ParticleContextExpression.CODEC.optionalFieldOf("green").forGetter(ParticleParticleEmitter::g), ParticleContextExpression.CODEC.optionalFieldOf("blue").forGetter(ParticleParticleEmitter::b), ParticleContextExpression.CODEC.optionalFieldOf("alpha").forGetter(ParticleParticleEmitter::a), ParticleContextExpression.CODEC.optionalFieldOf("roll").forGetter(ParticleParticleEmitter::roll), ParticleContextExpression.CODEC.optionalFieldOf("size").forGetter(ParticleParticleEmitter::size), ParticleContextExpression.CODEC.optionalFieldOf("custom").forGetter(ParticleParticleEmitter::custom), CodecUtils.lenientWithLog(RuleTest.CODEC, "state_predicate", AlwaysTrueTest.INSTANCE).forGetter(ParticleParticleEmitter::predicate), CodecUtils.forwardAwareHomogeneousList(Registries.BIOME).optionalFieldOf("biomes").forGetter(ParticleParticleEmitter::biomes)).apply(i, ParticleParticleEmitter::new));

    @Override
    public void tick(Particle particle, Level level) {
        if (this.particleType.isEmpty()) {
            return;
        }
        double spawnChance = this.chance.getValue(particle, level);
        if ((double)level.random.nextFloat() < spawnChance) {
            BlockState blockAt;
            if (this.biomes.isPresent()) {
                Holder biome = level.getBiome(BlockPos.containing((double)particle.x, (double)particle.y, (double)particle.z));
                if (!this.biomes.get().contains(biome)) {
                    return;
                }
            }
            if (this.predicate != AlwaysTrueTest.INSTANCE && !this.predicate.test(blockAt = level.getBlockState(BlockPos.containing((double)particle.x, (double)particle.y, (double)particle.z)), level.random)) {
                return;
            }
            int i = 0;
            while ((double)i < this.count.getValue(particle, level)) {
                ParticleOptions po = this.getParticleOptions(particle, level);
                if (po == null) {
                    return;
                }
                level.addParticle(po, particle.x + this.x.getValue(particle, level), particle.y + this.y.getValue(particle, level), particle.z + this.z.getValue(particle, level), this.dx.getValue(particle, level), this.dy.getValue(particle, level), this.dz.getValue(particle, level));
                ++i;
            }
        }
    }

    @Nullable
    private ParticleOptions getParticleOptions(Particle particle, Level level) {
        SimpleParticleType st;
        ParticleType particleTypeValue = (ParticleType)this.particleType.get().value();
        if (Polytone.CUSTOM_PARTICLES.isDynamicParticle(((ResourceKey)this.particleType.get().unwrapKey().get()).location())) {
            HashMap<String, Float> map = new HashMap<String, Float>();
            this.r.ifPresent(exp -> map.put("red", Float.valueOf((float)exp.getValue(particle, level))));
            this.g.ifPresent(exp -> map.put("green", Float.valueOf((float)exp.getValue(particle, level))));
            this.b.ifPresent(exp -> map.put("blue", Float.valueOf((float)exp.getValue(particle, level))));
            this.a.ifPresent(exp -> map.put("alpha", Float.valueOf((float)exp.getValue(particle, level))));
            this.roll.ifPresent(exp -> map.put("roll", Float.valueOf((float)exp.getValue(particle, level))));
            this.size.ifPresent(exp -> map.put("size", Float.valueOf((float)exp.getValue(particle, level))));
            this.custom.ifPresent(exp -> map.put("custom", Float.valueOf((float)exp.getValue(particle, level))));
            return new ExtraDataParticleOptions(map, particleTypeValue);
        }
        if (!(particleTypeValue instanceof SimpleParticleType)) {
            Polytone.LOGGER.error("Unsupported particle type: {}", (Object)particleTypeValue);
            return null;
        }
        SimpleParticleType po = st = (SimpleParticleType)particleTypeValue;
        return po;
    }
}

