/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.slotify;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import net.mehvahdjukaar.polytone.slotify.RelativeSprite;
import net.mehvahdjukaar.polytone.slotify.SimpleSprite;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;

public record BlitModifier(ResourceLocation target, int index, int xInc, int yInc, int zInc, int widthInc, int heightInc, float u0, float v0, float u1, float v1, Optional<ResourceLocation> newTexture, List<RelativeSprite> extraSprites) {
    public static final Codec<BlitModifier> CODEC = RecordCodecBuilder.create(i -> i.group((App)ResourceLocation.CODEC.fieldOf("texture").forGetter(BlitModifier::target), (App)Codec.INT.optionalFieldOf("index", (Object)-1).forGetter(BlitModifier::index), (App)Codec.INT.optionalFieldOf("x_inc", (Object)0).forGetter(BlitModifier::xInc), (App)Codec.INT.optionalFieldOf("y_inc", (Object)0).forGetter(BlitModifier::yInc), (App)Codec.INT.optionalFieldOf("z_inc", (Object)0).forGetter(BlitModifier::zInc), (App)Codec.INT.optionalFieldOf("width_inc", (Object)0).forGetter(BlitModifier::widthInc), (App)Codec.INT.optionalFieldOf("height_inc", (Object)0).forGetter(BlitModifier::heightInc), (App)Codec.FLOAT.optionalFieldOf("u0", (Object)Float.valueOf(-1.0f)).forGetter(BlitModifier::u0), (App)Codec.FLOAT.optionalFieldOf("v0", (Object)Float.valueOf(-1.0f)).forGetter(BlitModifier::v0), (App)Codec.FLOAT.optionalFieldOf("u1", (Object)Float.valueOf(-1.0f)).forGetter(BlitModifier::u1), (App)Codec.FLOAT.optionalFieldOf("v1", (Object)Float.valueOf(-1.0f)).forGetter(BlitModifier::v1), (App)ResourceLocation.CODEC.optionalFieldOf("new_texture").forGetter(BlitModifier::newTexture), (App)RelativeSprite.CODEC.listOf().optionalFieldOf("overlays", List.of()).forGetter(BlitModifier::extraSprites)).apply((Applicative)i, BlitModifier::new));

    public void blitModified(GuiGraphics gui, TextureAtlasSprite sprite, int oldX1, int oldX2, int oldY1, int oldY2, int blitOffset, float oldU0, float oldU1, float oldV0, float oldV1) {
        for (RelativeSprite s : this.extraSprites) {
            s.render(gui.pose(), oldX1, oldX2, oldY1, oldY2, blitOffset);
        }
        if (this.newTexture.isPresent()) {
            sprite = Minecraft.getInstance().getGuiSprites().getSprite(this.newTexture.get());
        }
        float minU = this.u0 == -1.0f ? oldU0 : this.u0;
        float maxU = this.u1 == -1.0f ? oldU1 : this.u1;
        float minV = this.v0 == -1.0f ? oldV0 : this.v0;
        float maxV = this.v1 == -1.0f ? oldV1 : this.v1;
        int oldw = oldX2 - oldX1;
        oldX2 = (oldX1 += this.xInc) + (oldw += this.widthInc);
        int oldh = oldY2 - oldY1;
        oldY2 = (oldY1 += this.yInc) + (oldh += this.heightInc);
        SimpleSprite.blit(gui.pose().last().pose(), sprite.atlasLocation(), oldX1, oldX2, oldY1, oldY2, blitOffset += this.zInc, minU, maxU, minV, maxV);
    }
}

