/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.tabs;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import net.mehvahdjukaar.polytone.utils.MapRegistry;
import net.mehvahdjukaar.polytone.utils.codec.CodecUtils;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;

public interface ItemPredicate
extends Predicate<ItemStack> {
    public static final MapRegistry.CodecMap<ItemPredicate> TYPES = MapRegistry.ofCodec("Polytone Item Predicates");
    public static final Codec<ItemPredicate> CODEC = TYPES.dispatch("type", ItemPredicate::getCodec, c -> c);
    public static final True TRUE_PRED = new True();
    public static final MapCodec<True> TRUE = TYPES.register("true", MapCodec.unit((Object)TRUE_PRED));
    public static final MapCodec<And> AND = TYPES.register("and", CODEC.listOf().fieldOf("predicates").xmap(And::new, And::predicates));
    public static final MapCodec<Or> OR = TYPES.register("or", CODEC.listOf().fieldOf("predicates").xmap(Or::new, Or::predicates));
    public static final MapCodec<Not> NOT = TYPES.register("not", CODEC.fieldOf("predicate").xmap(Not::new, Not::predicate));
    public static final MapCodec<TagMatch> TAG_MATCH = TYPES.register("tag_match", TagKey.codec((ResourceKey)Registries.ITEM).fieldOf("tag").xmap(TagMatch::new, TagMatch::tag));
    public static final MapCodec<ItemMatch> ITEM_MATCH = TYPES.register("items_match", CodecUtils.forwardAwareByNameCodec(BuiltInRegistries.ITEM, Items.AIR).listOf().fieldOf("items").xmap(ItemMatch::new, ItemMatch::items));
    public static final MapCodec<ItemStackMatch> ITEMSTACK_MATCH = TYPES.register("itemstack_match", ItemStack.SINGLE_ITEM_CODEC.fieldOf("itemstack").xmap(ItemStackMatch::new, ItemStackMatch::items));
    public static final Pattern TRUE_PATTERN = Pattern.compile(".*");
    public static final MapCodec<IDMatch> ID_MATCH = TYPES.register("id_match", RecordCodecBuilder.mapCodec(i -> i.group((App)ExtraCodecs.PATTERN.optionalFieldOf("namespace", (Object)TRUE_PATTERN).forGetter(IDMatch::namespace), (App)ExtraCodecs.PATTERN.optionalFieldOf("path", (Object)TRUE_PATTERN).forGetter(IDMatch::path)).apply((Applicative)i, IDMatch::new)));

    public MapCodec<? extends ItemPredicate> getCodec();

    public static class True
    implements ItemPredicate {
        @Override
        public boolean test(ItemStack stack) {
            return true;
        }

        public MapCodec<True> getCodec() {
            return TRUE;
        }
    }

    public record IDMatch(Pattern namespace, Pattern path) implements ItemPredicate
    {
        @Override
        public boolean test(ItemStack stack) {
            Item item = stack.getItem();
            ResourceLocation id = item.builtInRegistryHolder().key().location();
            return this.namespace.matcher(id.getNamespace()).find() && this.path.matcher(id.getPath()).find();
        }

        public MapCodec<IDMatch> getCodec() {
            return ID_MATCH;
        }
    }

    public record ItemStackMatch(ItemStack items) implements ItemPredicate
    {
        @Override
        public boolean test(ItemStack stack) {
            return ItemStack.matches((ItemStack)this.items, (ItemStack)stack);
        }

        public MapCodec<ItemStackMatch> getCodec() {
            return ITEMSTACK_MATCH;
        }
    }

    public record ItemMatch(List<Item> items) implements ItemPredicate
    {
        @Override
        public boolean test(ItemStack stack) {
            return this.items.contains(stack.getItem());
        }

        public MapCodec<ItemMatch> getCodec() {
            return ITEM_MATCH;
        }
    }

    public record TagMatch(TagKey<Item> tag) implements ItemPredicate
    {
        @Override
        public boolean test(ItemStack stack) {
            return stack.is(this.tag);
        }

        public MapCodec<TagMatch> getCodec() {
            return TAG_MATCH;
        }
    }

    public record Not(ItemPredicate predicate) implements ItemPredicate
    {
        @Override
        public boolean test(ItemStack stack) {
            return !this.predicate.test(stack);
        }

        public MapCodec<Not> getCodec() {
            return NOT;
        }
    }

    public record Or(List<ItemPredicate> predicates) implements ItemPredicate
    {
        @Override
        public boolean test(ItemStack stack) {
            return this.predicates.stream().anyMatch(p -> p.test(stack));
        }

        public MapCodec<Or> getCodec() {
            return OR;
        }
    }

    public record And(List<ItemPredicate> predicates) implements ItemPredicate
    {
        @Override
        public boolean test(ItemStack stack) {
            return this.predicates.stream().allMatch(p -> p.test(stack));
        }

        @Override
        public MapCodec<? extends ItemPredicate> getCodec() {
            return AND;
        }
    }
}

