/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.texture;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.mehvahdjukaar.polytone.IrisCompat;
import net.mehvahdjukaar.polytone.Polytone;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

public class LeashTexture
extends RenderType {
    private static final ResourceLocation LEASH_TEXTURE = ResourceLocation.withDefaultNamespace((String)"textures/entity/lead.png");
    private static final RenderType RENDER_TYPE = RenderType.create((String)"polytone_leash", (VertexFormat)DefaultVertexFormat.POSITION_COLOR_TEX_LIGHTMAP, (VertexFormat.Mode)VertexFormat.Mode.TRIANGLE_STRIP, (int)1536, (RenderType.CompositeState)RenderType.CompositeState.builder().setShaderState(RENDERTYPE_TEXT_SHADER).setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(LEASH_TEXTURE, false, false)).setCullState(NO_CULL).setLightmapState(LIGHTMAP).createCompositeState(false));

    public LeashTexture(String name, VertexFormat format, VertexFormat.Mode mode, int bufferSize, boolean affectsCrumbling, boolean sortOnUpload, Runnable setupState, Runnable clearState) {
        super(name, format, mode, bufferSize, affectsCrumbling, sortOnUpload, setupState, clearState);
    }

    @Nullable
    public static RenderType getRenderType() {
        if (Polytone.iris && IrisCompat.isIrisShaderFuckerActive()) {
            return null;
        }
        return RENDER_TYPE;
    }

    public static boolean addVertexPair(VertexConsumer vertexConsumer, Matrix4f matrix4f, float startX, float startY, float startZ, int blockLight0, int blockLight1, int skyLight0, int skylight1, float y0, float y1, float dx, float dz, int index, boolean flippedColors) {
        if (Polytone.iris && IrisCompat.isIrisShaderFuckerActive()) {
            return false;
        }
        float segment = (float)index / 24.0f;
        int blockLight = (int)Mth.lerp((float)segment, (float)blockLight0, (float)blockLight1);
        int skyLight = (int)Mth.lerp((float)segment, (float)skyLight0, (float)skylight1);
        int light = LightTexture.pack((int)blockLight, (int)skyLight);
        float z = startX * segment;
        float aa = startY > 0.0f ? startY * segment * segment : startY - startY * (1.0f - segment) * (1.0f - segment);
        float ab = startZ * segment;
        float u1 = 0.0f;
        float u2 = 1.0f;
        vertexConsumer.addVertex(matrix4f, z - dx, aa + y1, ab + dz).setColor(1.0f, 1.0f, 1.0f, 1.0f).setUv(u1, segment).setLight(light);
        vertexConsumer.addVertex(matrix4f, z + dx, aa + y0 - y1, ab - dz).setColor(1.0f, 1.0f, 1.0f, 1.0f).setUv(u2, segment).setLight(light);
        return true;
    }
}

