/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.utils;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import org.jetbrains.annotations.NotNull;

public class BiomeKeysCache {
    private static final ThreadLocal<Object2ObjectOpenHashMap<Biome, ResourceKey<Biome>>> CACHE = ThreadLocal.withInitial(Object2ObjectOpenHashMap::new);

    public static ResourceKey<Biome> get(@NotNull Biome biome) {
        ResourceKey k = (ResourceKey)CACHE.get().get((Object)biome);
        if (k == null) {
            ClientLevel level = Minecraft.getInstance().level;
            if (level == null) {
                return Biomes.PLAINS;
            }
            return (ResourceKey)CACHE.get().computeIfAbsent((Object)biome, arg_0 -> BiomeKeysCache.lambda$get$0((Level)level, biome, arg_0));
        }
        return k;
    }

    public static void clear() {
        CACHE.get().clear();
    }

    private static /* synthetic */ ResourceKey lambda$get$0(Level level, Biome biome, Object b) {
        Optional biomeKey = level.registryAccess().registryOrThrow(Registries.BIOME).getResourceKey((Object)biome);
        if (biomeKey.isEmpty()) {
            return Biomes.THE_VOID;
        }
        return (ResourceKey)biomeKey.get();
    }
}

