/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.utils;

import com.google.gson.JsonParseException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.mehvahdjukaar.polytone.PlatStuff;
import net.mehvahdjukaar.polytone.Polytone;
import net.mehvahdjukaar.polytone.utils.VersionRange;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Parsed<T> {
    private final boolean isEnabled;
    private final T value;
    private final ResourceLocation id;
    private final int priority;
    private static final Codec<Integer> PRIORITY_CODEC = Codec.INT.optionalFieldOf("priority", (Object)0).codec();
    private static final Codec<Boolean> CONDITION_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.optionalFieldOf("polytone_ignore", (Object)false).forGetter(b -> b), (App)VersionRange.CODEC.optionalFieldOf("version").forGetter(b -> Optional.empty()), (App)Codec.withAlternative((Codec)Codec.STRING.listOf(), (Codec)Codec.STRING, List::of).optionalFieldOf("require_mods", List.of()).forGetter(b -> List.of())).apply((Applicative)instance, (ignore, version, modList) -> {
        if (ignore.booleanValue()) {
            return false;
        }
        if (version.isPresent() && !((VersionRange)version.get()).matches("1.21.1")) {
            return false;
        }
        for (String s : modList) {
            if (PlatStuff.isModLoaded(s)) continue;
            return false;
        }
        return true;
    }));

    private Parsed(boolean isEnabled, @Nullable T value, ResourceLocation id, int priority) {
        this.isEnabled = isEnabled;
        this.value = value;
        this.id = id;
        this.priority = priority;
        if (isEnabled && value == null) {
            throw new IllegalStateException();
        }
    }

    public static <A> Parsed<A> success(A value, ResourceLocation id) {
        return new Parsed<A>(true, value, id, 0);
    }

    public static <A> Parsed<A> of(A value, ResourceLocation id, boolean enabled) {
        return new Parsed<A>(enabled, value, id, 0);
    }

    public static <A> Parsed<A> lowPriority(A value, ResourceLocation id, boolean enabled) {
        return new Parsed<A>(enabled, value, id, -1);
    }

    @NotNull
    public T getResultOrPartial() {
        return this.value;
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public Optional<T> asOptional() {
        if (this.isEnabled) {
            return Optional.ofNullable(this.value);
        }
        return Optional.empty();
    }

    @Nullable
    public T orNull() {
        return this.isEnabled ? (T)this.value : null;
    }

    public int priority() {
        return this.priority;
    }

    public static <T, J> Parsed<T> parseAlways(Decoder<T> codec, J input, DynamicOps<J> ops, ResourceLocation id, String jsonTypeName) {
        return Parsed.parseOptionalOrPartial(codec, codec, input, ops, id, jsonTypeName);
    }

    public static <T, J> Parsed<T> parseOptional(Decoder<T> codec, J input, DynamicOps<J> ops, ResourceLocation id, String jsonTypeName) {
        return Parsed.parseOptionalOrPartial(codec, null, input, ops, id, jsonTypeName);
    }

    public static <T, J> Parsed<T> parseOptionalOrPartial(Decoder<T> fullCodec, @Nullable Decoder<T> partialCodec, J input, DynamicOps<J> ops, ResourceLocation id, String jsonTypeName) {
        Object value;
        Boolean enabled = (Boolean)((Pair)CONDITION_CODEC.decode(ops, input).getOrThrow()).getFirst();
        int priority = (Integer)((Pair)PRIORITY_CODEC.decode(ops, input).getOrThrow()).getFirst();
        try {
            value = enabled.booleanValue() ? ((Pair)fullCodec.decode(ops, input).getOrThrow()).getFirst() : (partialCodec == null ? null : ((Pair)partialCodec.decode(ops, input).getOrThrow()).getFirst());
        }
        catch (Exception e) {
            throw new JsonParseException("Failed to decode " + jsonTypeName + " from file \"" + String.valueOf(id) + ".json\": ", (Throwable)e);
        }
        return new Parsed<Object>(enabled, value, id, priority);
    }

    public static <A, J> SortedMap<A> batchParseOrPartial(Map<ResourceLocation, J> jsons, Decoder<A> fullCodec, @Nullable Decoder<A> codecWhenConditionIsNotMet, DynamicOps<J> ops, String jsonTypeName) {
        SortedMap<A> treeMap = new SortedMap<A>(jsonTypeName);
        for (Map.Entry<ResourceLocation, J> e : jsons.entrySet()) {
            J json = e.getValue();
            ResourceLocation id = e.getKey();
            Parsed<A> parsed = Parsed.parseOptionalOrPartial(fullCodec, codecWhenConditionIsNotMet, json, ops, id, jsonTypeName);
            treeMap.put(id, parsed);
        }
        return treeMap;
    }

    public static <A, J> SortedMap<A> batchParseAlways(Map<ResourceLocation, J> jsons, Decoder<A> codec, DynamicOps<J> ops, String jsonTypeName) {
        return Parsed.batchParseOrPartial(jsons, codec, codec, ops, jsonTypeName);
    }

    public static <A, J> Iterable<Map.Entry<ResourceLocation, A>> batchParseOnlyEnabled(Map<ResourceLocation, J> jsons, Decoder<A> codec, DynamicOps<J> ops, String jsonTypeName) {
        return Parsed.batchParseOrPartial(jsons, codec, null, ops, jsonTypeName).entrySet().stream().filter(p -> ((Parsed)p.getValue()).isEnabled).map(e -> Map.entry((ResourceLocation)e.getKey(), ((Parsed)e.getValue()).getResultOrPartial())).toList();
    }

    public static class SortedMap<V>
    implements Iterable<Map.Entry<ResourceLocation, Parsed<V>>> {
        private final LinkedHashMap<ResourceLocation, Parsed<V>> map = new LinkedHashMap();
        private final String name;

        public SortedMap(String name) {
            this.name = name;
        }

        public void put(ResourceLocation key, Parsed<V> value) {
            Parsed<V> existing = this.map.get(key);
            if (!value.isEnabled() && existing != null) {
                return;
            }
            if (existing == null) {
                this.map.put(key, value);
            } else if (value.priority > existing.priority) {
                Polytone.LOGGER.warn("Found duplicate {}  file with id {}. Overriding previous one", (Object)this.name, (Object)key);
                this.map.put(key, value);
            }
        }

        public void putAll(Map<ResourceLocation, Parsed<V>> other) {
            for (Map.Entry<ResourceLocation, Parsed<V>> entry : other.entrySet()) {
                this.put(entry.getKey(), entry.getValue());
            }
        }

        public Parsed<V> get(ResourceLocation key) {
            return this.map.get(key);
        }

        public int size() {
            return this.map.size();
        }

        @Override
        public Iterator<Map.Entry<ResourceLocation, Parsed<V>>> iterator() {
            return this.map.entrySet().stream().sorted(Comparator.comparingInt(a -> ((Parsed)a.getValue()).priority)).iterator();
        }

        public Set<ResourceLocation> keySet() {
            return this.map.keySet();
        }

        public Collection<Parsed<V>> values() {
            return this.map.values();
        }

        public Set<Map.Entry<ResourceLocation, Parsed<V>>> entrySet() {
            return new LinkedHashSet<Map.Entry<ResourceLocation, Parsed<V>>>(this.map.entrySet().stream().sorted(Comparator.comparingInt(a -> ((Parsed)a.getValue()).priority)).toList());
        }
    }
}

