/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.neoforge;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.serialization.MapCodec;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.mehvahdjukaar.polytone.PlatStuff;
import net.mehvahdjukaar.polytone.mixins.neoforge.BlockColorsAccessor;
import net.mehvahdjukaar.polytone.mixins.neoforge.CreativeTabAccessor;
import net.mehvahdjukaar.polytone.mixins.neoforge.ItemColorsAccessor;
import net.mehvahdjukaar.polytone.mixins.neoforge.ModifiableBiomeAccessor;
import net.mehvahdjukaar.polytone.mixins.neoforge.ModifiableBiomeInfoBiomeInfoAccessor;
import net.mehvahdjukaar.polytone.mixins.neoforge.ParticleEngineAccessor;
import net.mehvahdjukaar.polytone.neoforge.AlexsCavesCompat;
import net.mehvahdjukaar.polytone.neoforge.PolytoneForge;
import net.mehvahdjukaar.polytone.particle.ExtraDataParticleOptions;
import net.mehvahdjukaar.polytone.tabs.CreativeTabModifier;
import net.mehvahdjukaar.polytone.utils.Targets;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.client.color.item.ItemColors;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.SessionSearchTrees;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.renderer.DimensionSpecialEffects;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ColorResolver;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSpecialEffects;
import net.minecraft.world.level.block.Block;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.fml.ModList;
import net.neoforged.fml.ModLoader;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.fml.util.ObfuscationReflectionHelper;
import net.neoforged.neoforge.client.ColorResolverManager;
import net.neoforged.neoforge.client.CreativeModeTabSearchRegistry;
import net.neoforged.neoforge.client.DimensionSpecialEffectsManager;
import net.neoforged.neoforge.client.event.ModelEvent;
import net.neoforged.neoforge.client.event.RegisterClientReloadListenersEvent;
import net.neoforged.neoforge.client.event.RegisterShadersEvent;
import net.neoforged.neoforge.common.CreativeModeTabRegistry;
import net.neoforged.neoforge.common.world.ModifiableBiomeInfo;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import org.jetbrains.annotations.Contract;
import org.joml.Vector3f;

public class PlatStuffImpl {
    private static Field VANILLA_TABS;
    private static final boolean AC;
    private static final Set<ColorResolver> MY_CUSTOM_RESOLVERS;
    private static final Field COLOR_RESOLVERS;

    public static boolean isModStateValid() {
        return !ModLoader.hasErrors();
    }

    public static void addClientReloadListener(Supplier<PreparableReloadListener> listener, ResourceLocation location) {
        Consumer<RegisterClientReloadListenersEvent> eventConsumer = event -> event.registerReloadListener((PreparableReloadListener)listener.get());
        PolytoneForge.bus.addListener(eventConsumer);
    }

    public static ParticleProvider<?> getParticleProvider(ParticleType<?> type) {
        return ((ParticleEngineAccessor)Minecraft.getInstance().particleEngine).getProviders().get(BuiltInRegistries.PARTICLE_TYPE.getKey(type));
    }

    public static void setParticleProvider(ParticleType<?> type, ParticleProvider<?> provider) {
        ParticleEngineAccessor engine = (ParticleEngineAccessor)Minecraft.getInstance().particleEngine;
        engine.getProviders().put(BuiltInRegistries.PARTICLE_TYPE.getKey(type), provider);
    }

    public static void unregisterParticleProvider(ResourceLocation id) {
        ParticleEngine particleEngine = Minecraft.getInstance().particleEngine;
        ((ParticleEngineAccessor)particleEngine).getProviders().remove(id);
    }

    public static ParticleType<ExtraDataParticleOptions> makeParticleType(boolean forceSpawn) {
        final AtomicReference<1> ref = new AtomicReference<1>();
        ParticleType<ExtraDataParticleOptions> instance = new ParticleType<ExtraDataParticleOptions>(forceSpawn){

            public MapCodec<ExtraDataParticleOptions> codec() {
                return ExtraDataParticleOptions.codec(ref::get);
            }

            public StreamCodec<? super RegistryFriendlyByteBuf, ExtraDataParticleOptions> streamCodec() {
                return ExtraDataParticleOptions.streamCodec(ref::get);
            }
        };
        ref.set(instance);
        return instance;
    }

    public static BlockColor getBlockColor(BlockColors colors, Block block) {
        return ((BlockColorsAccessor)colors).getBlockColors().get(block);
    }

    public static ItemColor getItemColor(ItemColors colors, Item item) {
        return ((ItemColorsAccessor)colors).getItemColors().get(item);
    }

    public static String maybeRemapName(String s) {
        return s;
    }

    @Contract
    public static boolean isModLoaded(String namespace) {
        return ModList.get().isLoaded(namespace);
    }

    public static DimensionSpecialEffects getDimensionEffects(ResourceLocation id) {
        return DimensionSpecialEffectsManager.getForType((ResourceLocation)id);
    }

    public static void applyBiomeSurgery(Biome biome, BiomeSpecialEffects newEffects) {
        ModifiableBiomeInfo modifiable = biome.modifiableBiomeInfo();
        ModifiableBiomeInfo.BiomeInfo modifiedInfo = modifiable.getModifiedBiomeInfo();
        if (modifiedInfo == null) {
            modifiedInfo = ModifiableBiomeInfo.BiomeInfo.Builder.copyOf((ModifiableBiomeInfo.BiomeInfo)modifiable.getOriginalBiomeInfo()).build();
            ((ModifiableBiomeAccessor)modifiable).setModifiedBiomeInfo(modifiedInfo);
        }
        ((ModifiableBiomeInfoBiomeInfoAccessor)modifiedInfo).setEffects(newEffects);
    }

    public static void addTabEventForTab(ResourceKey<CreativeModeTab> key) {
    }

    public static void sortTabs() {
        if (VANILLA_TABS == null) {
            VANILLA_TABS = ObfuscationReflectionHelper.findField(CreativeModeTabRegistry.class, (String)"DEFAULT_TABS");
        }
        try {
            ((List)VANILLA_TABS.get(null)).clear();
            CreativeModeTabRegistry.sortTabs();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    private static void updateSearchTrees(SessionSearchTrees searchTrees, List<CreativeModeTab> needsTreeUpdated) {
        needsTreeUpdated.forEach(tab -> {
            List list = List.copyOf(tab.getDisplayItems());
            searchTrees.updateCreativeTags(list, CreativeModeTabSearchRegistry.getTagSearchKey((CreativeModeTab)tab));
        });
    }

    public static RegistryAccess hackyGetRegistryAccess() {
        ClientLevel level;
        if (FMLEnvironment.dist == Dist.CLIENT && RenderSystem.isOnRenderThread() && (level = Minecraft.getInstance().level) != null) {
            return level.registryAccess();
        }
        return null;
    }

    public static CreativeModeTab createCreativeTab(ResourceLocation id) {
        return CreativeModeTab.builder().title((Component)Component.translatable((String)id.toString())).build();
    }

    public static CreativeTabModifier modifyTab(CreativeTabModifier mod, CreativeModeTab tab) {
        CreativeTabAccessor acc = (CreativeTabAccessor)tab;
        Component oldName = null;
        if (mod.name().isPresent()) {
            oldName = tab.getDisplayName();
            acc.setDisplayName(mod.name().get());
        }
        ItemStack oldIcon = null;
        if (mod.icon().isPresent()) {
            oldIcon = tab.getIconItem();
            acc.setIcon(mod.icon().get());
        }
        Boolean oldSearch = null;
        Integer oldSearchWidth = null;
        if (mod.search().isPresent()) {
            oldSearch = tab.hasSearchBar();
            acc.setHasSearchBar(mod.search().get());
        }
        if (mod.searchWidth().isPresent()) {
            oldSearchWidth = tab.getSearchBarWidth();
            acc.setSearchBarWidth(mod.searchWidth().get());
        }
        Boolean oldCanScroll = null;
        if (mod.canScroll().isPresent()) {
            oldCanScroll = tab.canScroll();
            acc.setCanScroll(mod.canScroll().get());
        }
        Boolean oldShowTitle = null;
        if (mod.showTitle().isPresent()) {
            oldShowTitle = tab.showTitle();
            acc.setShowTitle(mod.showTitle().get());
        }
        ResourceLocation oldTabsImage = null;
        if (mod.tabsImage().isPresent()) {
            oldTabsImage = tab.getTabsImage();
            acc.setTabsImage(mod.tabsImage().get());
        }
        ResourceLocation oldBackgroundLocation = null;
        if (mod.backGroundLocation().isPresent()) {
            oldBackgroundLocation = tab.getBackgroundTexture();
            acc.setBackgroundTexture(mod.backGroundLocation().get());
        }
        List oldBeforeTabs = null;
        if (mod.beforeTabs().isPresent()) {
            oldBeforeTabs = tab.tabsBefore;
            acc.setBeforeTabs(mod.beforeTabs().get());
        }
        List oldAfterTabs = null;
        if (mod.afterTabs().isPresent()) {
            oldAfterTabs = tab.tabsAfter;
            acc.setAfterTabs(mod.afterTabs().get());
        }
        return new CreativeTabModifier(Optional.ofNullable(oldIcon), Optional.ofNullable(oldSearch), Optional.ofNullable(oldSearchWidth), Optional.ofNullable(oldCanScroll), Optional.ofNullable(oldShowTitle), Optional.ofNullable(oldName), Optional.ofNullable(oldBackgroundLocation), Optional.ofNullable(oldTabsImage), Optional.ofNullable(oldBeforeTabs), Optional.ofNullable(oldAfterTabs), List.of(), List.of(), Targets.EMPTY);
    }

    public static RenderType getRenderType(Block block) {
        return null;
    }

    public static void setRenderType(Block block, RenderType renderType) {
        ItemBlockRenderTypes.setRenderLayer((Block)block, (RenderType)renderType);
    }

    public static void adjustLightmapColors(ClientLevel level, float partialTicks, float skyDarken, float skyLight, float flicker, int torchX, int skyY, Vector3f combined) {
        if (AC) {
            AlexsCavesCompat.applyACLightingColors(level, combined, partialTicks);
        }
        level.effects().adjustLightmapColors(level, partialTicks, skyDarken, skyLight, flicker, torchX, skyY, combined);
    }

    public static float compatACModifyGamma(float partialTicks, float gamma) {
        return AC ? AlexsCavesCompat.modifyGamma(partialTicks, gamma) : gamma;
    }

    public static RegistryAccess getServerRegistryAccess() {
        return ServerLifecycleHooks.getCurrentServer().registryAccess();
    }

    public static BakedModel getBakedModel(ModelResourceLocation id) {
        ModelManager mm = Minecraft.getInstance().getModelManager();
        return mm.getModel(id);
    }

    public static void addSpecialModelRegistration(Consumer<PlatStuff.SpecialModelEvent> eventListener) {
        Consumer<ModelEvent.RegisterAdditional> eventConsumer = event -> eventListener.accept(arg_0 -> ((ModelEvent.RegisterAdditional)event).register(arg_0));
        PolytoneForge.bus.addListener(eventConsumer);
    }

    public static String getVersion() {
        return ModList.get().getModContainerById("polytone").map(c -> c.getModInfo().getVersion().toString()).orElse("unknown");
    }

    public static void unregisterAllCustomColorResolves() {
        for (ColorResolver resolver : MY_CUSTOM_RESOLVERS) {
            try {
                ImmutableList resolvers = (ImmutableList)COLOR_RESOLVERS.get(null);
                ArrayList temp = new ArrayList(resolvers);
                temp.remove(resolver);
                ImmutableList newList = ImmutableList.copyOf(temp);
                COLOR_RESOLVERS.set(null, newList);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        MY_CUSTOM_RESOLVERS.clear();
    }

    public static void registerColorResolver(ColorResolver colorResolver) {
        MY_CUSTOM_RESOLVERS.add(colorResolver);
        try {
            ImmutableList resolvers = (ImmutableList)COLOR_RESOLVERS.get(null);
            ImmutableList newList = ImmutableList.builder().addAll((Iterable)resolvers).add((Object)colorResolver).build();
            COLOR_RESOLVERS.set(null, newList);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static void registerShaders(ResourceLocation id, VertexFormat format, Consumer<ShaderInstance> shaderConsumer) {
        Consumer<RegisterShadersEvent> eventConsumer = event -> {
            try {
                ShaderInstance shader = new ShaderInstance(event.getResourceProvider(), id, format);
                event.registerShader(shader, shaderConsumer);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to parse shader: " + String.valueOf(id), e);
            }
        };
        PolytoneForge.bus.addListener(eventConsumer);
    }

    public static void doAddModels() {
    }

    static {
        Field[] fields;
        VANILLA_TABS = null;
        AC = ModList.get().isLoaded("alexscaves");
        MY_CUSTOM_RESOLVERS = new HashSet<ColorResolver>();
        Field found = null;
        for (Field f : fields = ColorResolverManager.class.getDeclaredFields()) {
            if (f.getType() != ImmutableList.class) continue;
            f.setAccessible(true);
            found = f;
            break;
        }
        COLOR_RESOLVERS = found;
    }
}

