/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.particle;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Queue;
import net.mehvahdjukaar.polytone.PlatStuff;
import net.mehvahdjukaar.polytone.PolytoneRenderTypes;
import net.mehvahdjukaar.polytone.colormap.Colormap;
import net.mehvahdjukaar.polytone.colormap.IColorGetter;
import net.mehvahdjukaar.polytone.particle.CustomParticleFactory;
import net.mehvahdjukaar.polytone.particle.ExtraDataParticleOptions;
import net.mehvahdjukaar.polytone.particle.ParticleContextExpression;
import net.mehvahdjukaar.polytone.particle.ParticleInitializer;
import net.mehvahdjukaar.polytone.particle.ParticleParticleEmitter;
import net.mehvahdjukaar.polytone.particle.ParticleTickable;
import net.mehvahdjukaar.polytone.particle.RotationMode;
import net.mehvahdjukaar.polytone.particle.RotationProvider;
import net.mehvahdjukaar.polytone.sound.ParticleSoundEmitter;
import net.mehvahdjukaar.polytone.utils.ColorUtils;
import net.mehvahdjukaar.polytone.utils.ModelResHelper;
import net.mehvahdjukaar.polytone.utils.codec.BiggerCodecs;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SingleQuadParticle;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleGroup;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;

public class CustomParticleType
implements CustomParticleFactory {
    private static BlockState STATE_HACK = Blocks.AIR.defaultBlockState();
    private final RenderMode renderType;
    @Nullable
    private final ModelResourceLocation model;
    @Nullable
    private final ParticleInitializer initializer;
    @Nullable
    private final Ticker ticker;
    private final List<ParticleSoundEmitter> sounds;
    private final int tickRate;
    private final int exclusionRadius;
    protected final List<ParticleParticleEmitter> particles = new ArrayList<ParticleParticleEmitter>();
    @Nullable
    protected List<Dynamic<?>> lazyParticles;
    private final int lightLevel;
    private final LiquidAffinity liquidAffinity;
    private final boolean hasPhysics;
    private final boolean killOnContact;
    private final boolean killWhenStill;
    @Nullable
    private final IColorGetter colormap;
    private final RotationProvider rotationProvider;
    private final Vec3 offset;
    private final Optional<ParticleGroup> group;
    private final boolean forceSpawn;
    private final boolean randomSprite;
    private transient SpriteSet spriteSet;
    private boolean isValid = true;
    public static final Codec<CustomParticleType> CODEC = RecordCodecBuilder.create(i -> BiggerCodecs.group(i, RenderMode.CODEC.optionalFieldOf("render_type", (Object)RenderMode.OPAQUE).forGetter(CustomParticleType::getRenderType), RotationProvider.CODEC.optionalFieldOf("rotation_mode", (Object)RotationMode.LOOK_AT_XYZ).forGetter(c -> c.rotationProvider), ResourceLocation.CODEC.optionalFieldOf("model").forGetter(c -> Optional.ofNullable(c.model.id())), Vec3.CODEC.optionalFieldOf("offset", (Object)Vec3.ZERO).forGetter(c -> c.offset), Codec.intRange((int)0, (int)15).optionalFieldOf("light_level", (Object)0).forGetter(c -> c.lightLevel), Codec.BOOL.optionalFieldOf("has_physics", (Object)true).forGetter(c -> c.hasPhysics), Codec.BOOL.optionalFieldOf("kill_on_contact", (Object)false).forGetter(c -> c.killOnContact), Codec.BOOL.optionalFieldOf("kill_when_still", (Object)false).forGetter(c -> c.killWhenStill), LiquidAffinity.CODEC.optionalFieldOf("liquid_affinity", (Object)LiquidAffinity.ANY).forGetter(c -> c.liquidAffinity), Colormap.CODEC.optionalFieldOf("colormap").forGetter(c -> Optional.ofNullable(c.colormap)), Codec.BOOL.optionalFieldOf("random_sprite", (Object)false).forGetter(c -> c.randomSprite), ExtraCodecs.NON_NEGATIVE_INT.optionalFieldOf("limit", (Object)0).forGetter(c -> c.group.map(ParticleGroup::getLimit).orElse(0)), Codec.BOOL.optionalFieldOf("force_spawn", (Object)false).forGetter(c -> c.forceSpawn), ParticleInitializer.CODEC.optionalFieldOf("initializer").forGetter(c -> Optional.ofNullable(c.initializer)), Ticker.CODEC.optionalFieldOf("ticker").forGetter(c -> Optional.ofNullable(c.ticker)), ParticleSoundEmitter.CODEC.listOf().optionalFieldOf("sound_emitters", List.of()).forGetter(c -> c.sounds), ExtraCodecs.POSITIVE_INT.optionalFieldOf("tick_interval", (Object)1).forGetter(c -> c.tickRate), Codec.PASSTHROUGH.listOf().optionalFieldOf("particle_emitters", List.of()).forGetter(c -> c.lazyParticles), ExtraCodecs.NON_NEGATIVE_INT.optionalFieldOf("exclusion_radius", (Object)0).forGetter(c -> c.exclusionRadius)).apply(i, CustomParticleType::new));
    public static final Codec<Optional<ModelResourceLocation>> CUSTOM_MODEL_ONLY_CODEC = RecordCodecBuilder.create(i -> i.group((App)ModelResHelper.MODEL_RES_CODEC.optionalFieldOf("model").forGetter(e -> e)).apply((Applicative)i, r -> r));

    private CustomParticleType(RenderMode renderType, RotationProvider rotationProvider, @Nullable ResourceLocation model, Vec3 offset, int light, boolean hasPhysics, boolean killOnContact, boolean killWhenStill, LiquidAffinity liquidAffinity, @Nullable IColorGetter colormap, boolean randomSprite, int particleGroupLimit, boolean forceSpawn, @Nullable ParticleInitializer initializer, @Nullable Ticker ticker, @Nullable List<ParticleSoundEmitter> sounds, int tickRate, @Nullable List<Dynamic<?>> particles, int killSimilarInRadius) {
        this.renderType = renderType;
        this.randomSprite = randomSprite;
        this.model = model == null ? null : new ModelResourceLocation(model, "standalone");
        this.initializer = initializer;
        this.ticker = ticker;
        this.sounds = sounds;
        this.lazyParticles = particles;
        this.lightLevel = light;
        this.hasPhysics = hasPhysics;
        this.killOnContact = killOnContact;
        this.killWhenStill = killWhenStill;
        this.liquidAffinity = liquidAffinity;
        this.forceSpawn = forceSpawn;
        this.colormap = colormap;
        this.offset = offset;
        this.rotationProvider = rotationProvider;
        this.tickRate = tickRate;
        this.exclusionRadius = killSimilarInRadius;
        this.group = particleGroupLimit > 0 ? Optional.of(new ParticleGroup(particleGroupLimit)) : Optional.empty();
    }

    private CustomParticleType(RenderMode renderType, RotationProvider rotationProvider, Optional<ResourceLocation> model, Vec3 offset, int light, boolean hasPhysics, boolean killOnContact, boolean killWhenStill, LiquidAffinity liquidAffinity, Optional<IColorGetter> colormap, boolean randomSprite, int limit, boolean forceSpawn, Optional<ParticleInitializer> initializer, Optional<Ticker> ticker, List<ParticleSoundEmitter> sounds, int tickRate, List<Dynamic<?>> particles, int killSimilarInRadius) {
        this(renderType, rotationProvider, (ResourceLocation)model.orElse(null), offset, light, hasPhysics, killOnContact, killWhenStill, liquidAffinity, (IColorGetter)colormap.orElse(null), randomSprite, limit, forceSpawn, (ParticleInitializer)initializer.orElse(null), (Ticker)ticker.orElse(null), sounds, tickRate, particles, killSimilarInRadius);
    }

    @Override
    public boolean forceSpawns() {
        return this.forceSpawn;
    }

    @Override
    @Nullable
    public ModelResourceLocation getCustomModel() {
        return this.model;
    }

    public static void setStateHack(BlockState state) {
        STATE_HACK = state;
    }

    private RenderMode getRenderType() {
        return this.renderType;
    }

    @Override
    public Particle createParticle(ExtraDataParticleOptions opt, ClientLevel world, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, @Nullable BlockState state) {
        if (this.spriteSet != null) {
            Instance newParticle = new Instance(world, x, y, z, xSpeed, ySpeed, zSpeed, state, this);
            opt.apply((Particle)newParticle);
            if (this.hasPhysics) {
                for (VoxelShape voxelShape : world.getBlockCollisions(null, newParticle.getBoundingBox())) {
                    if (voxelShape.isEmpty()) continue;
                    return null;
                }
            }
            if (this.ticker != null && this.ticker.removeIf != null && this.ticker.removeIf.getValue((Particle)newParticle, (Level)world) > 0.0) {
                return null;
            }
            if (this.exclusionRadius > 0) {
                ParticleRenderType particleRenderType = this.renderType.getParticle();
                double radiusSquared = this.exclusionRadius * this.exclusionRadius;
                Queue particleQueue = (Queue)Minecraft.getInstance().particleEngine.particles.get(particleRenderType);
                if (particleQueue != null) {
                    for (Particle p : particleQueue) {
                        double distSqrt;
                        if (!(p instanceof Instance)) continue;
                        Instance inst = (Instance)p;
                        if (inst.type != this || !((distSqrt = Mth.lengthSquared((double)(inst.x - newParticle.x), (double)(inst.y - newParticle.y), (double)(inst.z - newParticle.z))) < radiusSquared)) continue;
                        if (inst.hasAgeLeft()) {
                            return null;
                        }
                        inst.remove();
                    }
                }
            }
            return newParticle;
        }
        throw new IllegalStateException("Sprite set not set for custom particle type");
    }

    @Override
    public void setSpriteSet(ParticleEngine.MutableSpriteSet mutableSpriteSet) {
        this.spriteSet = mutableSpriteSet;
    }

    public void setUnregistered() {
        this.isValid = false;
    }

    public static enum RenderMode implements StringRepresentable
    {
        TERRAIN,
        OPAQUE,
        TRANSLUCENT,
        LIT,
        ADDITIVE_TRANSLUCENT,
        INVISIBLE;

        public static final Codec<RenderMode> CODEC;

        public RenderType getBlock() {
            return switch (this.ordinal()) {
                case 0 -> RenderType.solid();
                case 4 -> PolytoneRenderTypes.ADDITIVE_TRANSLUCENT_BLOCK;
                case 3 -> RenderType.cutout();
                case 2 -> RenderType.translucent();
                case 5 -> RenderType.cutout();
                default -> RenderType.cutoutMipped();
            };
        }

        public ParticleRenderType getParticle() {
            return switch (this.ordinal()) {
                case 0 -> ParticleRenderType.TERRAIN_SHEET;
                case 2 -> ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
                case 3 -> ParticleRenderType.PARTICLE_SHEET_LIT;
                case 4 -> PolytoneRenderTypes.PARTICLE_ADDITIVE_TRANSLUCENCY_RENDER_TYPE;
                case 5 -> ParticleRenderType.NO_RENDER;
                default -> ParticleRenderType.PARTICLE_SHEET_OPAQUE;
            };
        }

        public String getSerializedName() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        public VertexConsumer modifyParticleConsumer(VertexConsumer original) {
            if (this == ADDITIVE_TRANSLUCENT) {
                return PolytoneRenderTypes.DEFERRED_BUFFER_SOURCE.getBuffer(PolytoneRenderTypes.ADDITIVE_TRANSLUCENT_PARTICLE);
            }
            return original;
        }

        public VertexConsumer modifyBlockConsumer(VertexConsumer original) {
            return PolytoneRenderTypes.DEFERRED_BUFFER_SOURCE.getBuffer(this.getBlock());
        }

        static {
            CODEC = StringRepresentable.fromEnum(RenderMode::values);
        }
    }

    protected record Ticker(@Nullable ParticleContextExpression x, @Nullable ParticleContextExpression y, @Nullable ParticleContextExpression z, @Nullable ParticleContextExpression dx, @Nullable ParticleContextExpression dy, @Nullable ParticleContextExpression dz, @Nullable ParticleContextExpression size, @Nullable ParticleContextExpression red, @Nullable ParticleContextExpression green, @Nullable ParticleContextExpression blue, @Nullable ParticleContextExpression alpha, @Nullable ParticleContextExpression roll, @Nullable ParticleContextExpression custom, @Nullable ParticleContextExpression removeIf) {
        private static final Codec<Ticker> CODEC = RecordCodecBuilder.create(i -> i.group((App)ParticleContextExpression.CODEC.optionalFieldOf("x").forGetter(p -> Optional.ofNullable(p.x)), (App)ParticleContextExpression.CODEC.optionalFieldOf("y").forGetter(p -> Optional.ofNullable(p.y)), (App)ParticleContextExpression.CODEC.optionalFieldOf("z").forGetter(p -> Optional.ofNullable(p.z)), (App)ParticleContextExpression.CODEC.optionalFieldOf("dx").forGetter(p -> Optional.ofNullable(p.dx)), (App)ParticleContextExpression.CODEC.optionalFieldOf("dy").forGetter(p -> Optional.ofNullable(p.dy)), (App)ParticleContextExpression.CODEC.optionalFieldOf("dz").forGetter(p -> Optional.ofNullable(p.dz)), (App)ParticleContextExpression.CODEC.optionalFieldOf("size").forGetter(p -> Optional.ofNullable(p.size)), (App)ParticleContextExpression.CODEC.optionalFieldOf("red").forGetter(p -> Optional.ofNullable(p.red)), (App)ParticleContextExpression.CODEC.optionalFieldOf("green").forGetter(p -> Optional.ofNullable(p.green)), (App)ParticleContextExpression.CODEC.optionalFieldOf("blue").forGetter(p -> Optional.ofNullable(p.blue)), (App)ParticleContextExpression.CODEC.optionalFieldOf("alpha").forGetter(p -> Optional.ofNullable(p.alpha)), (App)ParticleContextExpression.CODEC.optionalFieldOf("roll").forGetter(p -> Optional.ofNullable(p.roll)), (App)ParticleContextExpression.CODEC.optionalFieldOf("custom").forGetter(p -> Optional.ofNullable(p.custom)), (App)ParticleContextExpression.CODEC.optionalFieldOf("remove_condition").forGetter(p -> Optional.ofNullable(p.removeIf))).apply((Applicative)i, Ticker::new));

        private Ticker(Optional<ParticleContextExpression> x, Optional<ParticleContextExpression> y, Optional<ParticleContextExpression> z, Optional<ParticleContextExpression> dx, Optional<ParticleContextExpression> dy, Optional<ParticleContextExpression> dz, Optional<ParticleContextExpression> size, Optional<ParticleContextExpression> red, Optional<ParticleContextExpression> green, Optional<ParticleContextExpression> blue, Optional<ParticleContextExpression> alpha, Optional<ParticleContextExpression> roll, Optional<ParticleContextExpression> custom, Optional<ParticleContextExpression> removeIf) {
            this((ParticleContextExpression)x.orElse(null), (ParticleContextExpression)y.orElse(null), (ParticleContextExpression)z.orElse(null), (ParticleContextExpression)dx.orElse(null), (ParticleContextExpression)dy.orElse(null), (ParticleContextExpression)dz.orElse(null), (ParticleContextExpression)size.orElse(null), (ParticleContextExpression)red.orElse(null), (ParticleContextExpression)green.orElse(null), (ParticleContextExpression)blue.orElse(null), (ParticleContextExpression)alpha.orElse(null), (ParticleContextExpression)roll.orElse(null), (ParticleContextExpression)custom.orElse(null), (ParticleContextExpression)removeIf.orElse(null));
        }

        private void tick(Instance particle, ClientLevel level) {
            if (this.roll != null) {
                particle.oRoll = particle.roll;
                particle.roll = (float)this.roll.getValue((Particle)particle, (Level)level);
            }
            if (this.size != null) {
                particle.oQuadSize = particle.quadSize;
                particle.quadSize = (float)this.size.getValue((Particle)particle, (Level)level);
            }
            if (this.red != null) {
                particle.rCol = (float)this.red.getValue((Particle)particle, (Level)level);
            }
            if (this.green != null) {
                particle.gCol = (float)this.green.getValue((Particle)particle, (Level)level);
            }
            if (this.blue != null) {
                particle.bCol = (float)this.blue.getValue((Particle)particle, (Level)level);
            }
            if (this.alpha != null) {
                particle.alpha = (float)this.alpha.getValue((Particle)particle, (Level)level);
            }
            if (this.x != null) {
                particle.x = this.x.getValue((Particle)particle, (Level)level);
            }
            if (this.y != null) {
                particle.y = this.y.getValue((Particle)particle, (Level)level);
            }
            if (this.z != null) {
                particle.z = this.z.getValue((Particle)particle, (Level)level);
            }
            if (this.dx != null) {
                particle.xd = this.dx.getValue((Particle)particle, (Level)level);
            }
            if (this.dy != null) {
                particle.yd = this.dy.getValue((Particle)particle, (Level)level);
            }
            if (this.dz != null) {
                particle.zd = this.dz.getValue((Particle)particle, (Level)level);
            }
            if (this.custom != null) {
                particle.custom = this.custom.getValue((Particle)particle, (Level)level);
            }
            if (this.removeIf != null && this.removeIf.getValue((Particle)particle, (Level)level) > 0.0) {
                particle.remove();
            }
        }
    }

    protected static enum LiquidAffinity implements StringRepresentable
    {
        LIQUIDS,
        NON_LIQUIDS,
        ANY;

        private static final Codec<LiquidAffinity> CODEC;

        public String getSerializedName() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        static {
            CODEC = StringRepresentable.fromEnum(LiquidAffinity::values);
        }
    }

    public static class Instance
    extends TextureSheetParticle {
        protected final CustomParticleType type;
        @Nullable
        protected final BakedModel model;
        protected final SpriteSet spriteSet;
        protected final LiquidAffinity liquidAffinity;
        protected final List<ParticleTickable> tickables;
        protected float oQuadSize;
        protected double custom;

        protected Instance(ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, @Nullable BlockState state, CustomParticleType customType) {
            super(level, x, y, z, xSpeed, ySpeed, zSpeed);
            this.setSize(0.1f, 0.1f);
            this.type = customType;
            this.tickables = new ArrayList<ParticleTickable>();
            this.tickables.addAll(customType.sounds);
            this.tickables.addAll(customType.particles);
            if (state == null) {
                state = STATE_HACK;
            }
            this.x = x;
            this.y = y;
            this.z = z;
            this.xd = xSpeed;
            this.yd = ySpeed;
            this.zd = zSpeed;
            this.model = customType.model == null ? null : PlatStuff.getBakedModel(customType.model);
            ParticleInitializer initializer = customType.initializer;
            BlockPos pos = BlockPos.containing((double)x, (double)y, (double)z);
            if (initializer != null) {
                initializer.initialize((SingleQuadParticle)this, level, state, pos);
            }
            this.oQuadSize = this.quadSize;
            this.liquidAffinity = customType.liquidAffinity;
            this.hasPhysics = customType.hasPhysics;
            if (this.type.colormap != null) {
                float[] unpack = ColorUtils.unpack(this.type.colormap.getColor(state, (BlockAndTintGetter)level, pos, 0));
                this.setColor(unpack[0], unpack[1], unpack[2]);
            }
            if (customType.randomSprite) {
                this.spriteSet = null;
                this.pickSprite(customType.spriteSet);
            } else {
                this.spriteSet = customType.spriteSet;
                this.setSpriteFromAge(this.spriteSet);
            }
        }

        public double getCustom() {
            return this.custom;
        }

        public Optional<ParticleGroup> getParticleGroup() {
            return this.type.group;
        }

        public void render(VertexConsumer buffer, Camera camera, float partialTicks) {
            Quaternionf quaternionf = new Quaternionf();
            this.type.rotationProvider.applyRotation((SingleQuadParticle)this, quaternionf, camera, partialTicks);
            if (this.roll != 0.0f) {
                quaternionf.rotateZ(Mth.lerp((float)partialTicks, (float)this.oRoll, (float)this.roll));
            }
            this.renderRotatedQuad(buffer, camera, quaternionf, partialTicks);
            if (!this.type.rotationProvider.alwaysFacesCamera() && this.model == null) {
                quaternionf.rotateX((float)Math.PI);
                this.renderRotatedQuad(buffer, camera, quaternionf, partialTicks);
            }
        }

        protected void renderRotatedQuad(VertexConsumer consumer, Quaternionf quaternion, float x, float y, float z, float partialTicks) {
            Vec3 offset = this.type.offset;
            if (this.model == null) {
                consumer = this.type.renderType.modifyParticleConsumer(consumer);
                super.renderRotatedQuad(consumer, quaternion, (float)((double)x + offset.x), (float)((double)y + offset.y), (float)((double)z + offset.z), partialTicks);
            } else {
                consumer = this.type.renderType.modifyBlockConsumer(consumer);
                float size = this.getQuadSize(partialTicks);
                PoseStack poseStack = new PoseStack();
                poseStack.translate((double)x + offset.x, (double)y + offset.y, (double)z + offset.z);
                poseStack.scale(size, size, size);
                poseStack.mulPose(quaternion);
                poseStack.translate(-0.5, -0.5, -0.5);
                Instance.putModelBulkData(this.model, this.getLightColor(partialTicks), OverlayTexture.NO_OVERLAY, poseStack, consumer, this.rCol, this.gCol, this.bCol, this.alpha);
            }
        }

        protected int getLightColor(float partialTick) {
            int total = super.getLightColor(partialTick);
            if (this.type.lightLevel > 0) {
                int sky = LightTexture.sky((int)total);
                int block = LightTexture.block((int)total);
                block = Math.max(block, this.type.lightLevel);
                return LightTexture.pack((int)block, (int)sky);
            }
            return total;
        }

        public boolean hasAgeLeft() {
            return this.age < this.lifetime;
        }

        public void remove() {
            super.remove();
            this.age = this.lifetime;
        }

        public void tick() {
            BlockState state;
            boolean isTickTime;
            if (!this.type.isValid) {
                this.remove();
                return;
            }
            if (this.spriteSet != null) {
                this.setSpriteFromAge(this.spriteSet);
            }
            super.tick();
            boolean bl = isTickTime = this.age % this.type.tickRate == 0;
            if (this.type.ticker != null && isTickTime) {
                this.type.ticker.tick(this, this.level);
            }
            if (this.type.colormap != null) {
                BlockPos pos = BlockPos.containing((double)this.x, (double)this.y, (double)this.z);
                float[] unpack = ColorUtils.unpack(this.type.colormap.getColor(null, (BlockAndTintGetter)this.level, pos, 0));
                this.setColor(unpack[0], unpack[1], unpack[2]);
            }
            if (this.age > 1 && this.type.killWhenStill && this.x == this.xo && this.y == this.yo && this.z == this.zo) {
                this.remove();
            }
            if (this.liquidAffinity != LiquidAffinity.ANY && this.liquidAffinity == LiquidAffinity.LIQUIDS ^ !(state = this.level.getBlockState(BlockPos.containing((double)this.x, (double)this.y, (double)this.z))).getFluidState().isEmpty()) {
                this.remove();
            }
            if (!this.removed && isTickTime) {
                for (ParticleTickable tickable : this.tickables) {
                    tickable.tick((Particle)this, (Level)this.level);
                }
            }
        }

        public void move(double x, double y, double z) {
            Vec3 wantedPos;
            Vec3 myPos;
            super.move(x, y, z);
            if (this.type.killOnContact && this.age > 1 && (myPos = new Vec3(this.x, this.y, this.z)).distanceToSqr(wantedPos = new Vec3(this.xo + x, this.yo + y, this.zo + z)) > 1.0E-6) {
                this.remove();
                this.xd = 0.0;
                this.yd = 0.0;
                this.zd = 0.0;
            }
        }

        public static void putModelBulkData(BakedModel model, int combinedLight, int combinedOverlay, PoseStack poseStack, VertexConsumer buffer, float r, float g, float b, float a) {
            RandomSource randomSource = RandomSource.create();
            for (Direction direction : Direction.values()) {
                randomSource.setSeed(42L);
                for (BakedQuad bakedQuad : model.getQuads(null, direction, randomSource)) {
                    buffer.putBulkData(poseStack.last(), bakedQuad, r, g, b, a, combinedLight, combinedOverlay);
                }
            }
            randomSource.setSeed(42L);
            for (BakedQuad bakedQuad : model.getQuads(null, null, randomSource)) {
                buffer.putBulkData(poseStack.last(), bakedQuad, r, g, b, a, combinedLight, combinedOverlay);
            }
        }

        public float getQuadSize(float scaleFactor) {
            return Mth.lerp((float)scaleFactor, (float)this.oQuadSize, (float)this.quadSize);
        }

        public ParticleRenderType getRenderType() {
            return this.model == null ? this.type.renderType.getParticle() : ParticleRenderType.CUSTOM;
        }
    }
}

