/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.particle;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Map;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import net.mehvahdjukaar.polytone.particle.CustomParticleType;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.SingleQuadParticle;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import org.jetbrains.annotations.NotNull;

public record ExtraDataParticleOptions(Map<String, Float> extraData, ParticleType<?> type) implements ParticleOptions
{
    public static MapCodec<ExtraDataParticleOptions> codec(Supplier<ParticleType<ExtraDataParticleOptions>> typeGetter) {
        return Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.FLOAT).optionalFieldOf("extra_data", Map.of()).xmap(stringFloatMap -> new ExtraDataParticleOptions((Map<String, Float>)stringFloatMap, (ParticleType<?>)((ParticleType)typeGetter.get())), ExtraDataParticleOptions::extraData);
    }

    public static StreamCodec<ByteBuf, ExtraDataParticleOptions> streamCodec(Supplier<ParticleType<ExtraDataParticleOptions>> typeGetter) {
        return ByteBufCodecs.map(ExtraDataParticleOptions.makeMap(), (StreamCodec)ByteBufCodecs.STRING_UTF8, (StreamCodec)ByteBufCodecs.FLOAT).map(map -> new ExtraDataParticleOptions((Map<String, Float>)map, (ParticleType<?>)((ParticleType)typeGetter.get())), ExtraDataParticleOptions::extraData);
    }

    @NotNull
    private static IntFunction<Map<String, Float>> makeMap() {
        return i -> new HashMap();
    }

    public ParticleType<?> getType() {
        return this.type;
    }

    public void apply(Particle particle) {
        Float custom;
        Float size;
        Float alpha;
        Float blue;
        Float green;
        Float red;
        if (this.extraData.isEmpty()) {
            return;
        }
        Float rot = this.extraData.get("roll");
        if (rot != null) {
            particle.roll = rot.floatValue();
            particle.oRoll = rot.floatValue();
        }
        if ((red = this.extraData.get("red")) != null) {
            particle.rCol = red.floatValue();
        }
        if ((green = this.extraData.get("green")) != null) {
            particle.gCol = green.floatValue();
        }
        if ((blue = this.extraData.get("blue")) != null) {
            particle.bCol = blue.floatValue();
        }
        if ((alpha = this.extraData.get("alpha")) != null) {
            particle.alpha = alpha.floatValue();
        }
        if ((size = this.extraData.get("size")) != null && particle instanceof SingleQuadParticle) {
            SingleQuadParticle sp = (SingleQuadParticle)particle;
            sp.quadSize = size.floatValue();
        }
        if ((custom = this.extraData.get("custom")) != null && particle instanceof CustomParticleType.Instance) {
            CustomParticleType.Instance inst = (CustomParticleType.Instance)particle;
            inst.custom = custom.floatValue();
        }
    }
}

