/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.slotify;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.mehvahdjukaar.polytone.PlatStuff;
import net.mehvahdjukaar.polytone.slotify.SimpleSprite;
import net.mehvahdjukaar.polytone.slotify.SimpleText;
import net.mehvahdjukaar.polytone.slotify.SlotModifier;
import net.mehvahdjukaar.polytone.slotify.SpecialOffset;
import net.mehvahdjukaar.polytone.slotify.WidgetModifier;
import net.mehvahdjukaar.polytone.utils.ColorUtils;
import net.mehvahdjukaar.polytone.utils.codec.BiggerCodecs;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringRepresentable;
import org.jetbrains.annotations.Nullable;

public record GuiModifier(Type type, String target, List<SlotModifier> slotModifiers, int titleX, int titleY, int labelX, int labelY, int xOff, int yOff, int wOff, int hOff, @Nullable Integer titleColor, @Nullable Integer labelColor, List<SimpleSprite> sprites, List<SimpleText> textList, List<WidgetModifier> widgetModifiers, Map<String, SpecialOffset> specialOffsets) {
    public static final Codec<GuiModifier> CODEC = RecordCodecBuilder.create(i -> BiggerCodecs.group(i, StringRepresentable.fromEnum(Type::values).fieldOf("target_type").forGetter(GuiModifier::type), Codec.STRING.xmap(PlatStuff::maybeRemapName, PlatStuff::maybeRemapName).fieldOf("target").forGetter(GuiModifier::target), SlotModifier.CODEC.listOf().optionalFieldOf("slot_modifiers", List.of()).forGetter(GuiModifier::slotModifiers), Codec.INT.optionalFieldOf("title_x_offset", (Object)0).forGetter(GuiModifier::titleX), Codec.INT.optionalFieldOf("title_y_offset", (Object)0).forGetter(GuiModifier::titleY), Codec.INT.optionalFieldOf("label_x_offset", (Object)0).forGetter(GuiModifier::labelX), Codec.INT.optionalFieldOf("label_y_offset", (Object)0).forGetter(GuiModifier::labelY), Codec.INT.optionalFieldOf("x_offset", (Object)0).forGetter(GuiModifier::xOff), Codec.INT.optionalFieldOf("y_offset", (Object)0).forGetter(GuiModifier::yOff), Codec.INT.optionalFieldOf("width_offset", (Object)0).forGetter(GuiModifier::wOff), Codec.INT.optionalFieldOf("height_offset", (Object)0).forGetter(GuiModifier::hOff), ColorUtils.CODEC.optionalFieldOf("title_color").forGetter(g -> Optional.ofNullable(g.titleColor)), ColorUtils.CODEC.optionalFieldOf("label_color").forGetter(g -> Optional.ofNullable(g.labelColor)), SimpleSprite.CODEC.listOf().optionalFieldOf("sprites", List.of()).forGetter(GuiModifier::sprites), SimpleText.CODEC.listOf().optionalFieldOf("texts", List.of()).forGetter(GuiModifier::textList), WidgetModifier.CODEC.listOf().optionalFieldOf("widget_modifiers", List.of()).forGetter(GuiModifier::widgetModifiers), Codec.unboundedMap((Codec)Codec.STRING, SpecialOffset.CODEC).optionalFieldOf("special_offsets", Map.of()).forGetter(GuiModifier::specialOffsets)).apply(i, GuiModifier::new)).comapFlatMap(instance -> {
        Optional error;
        if (instance.type == Type.MENU_ID && (error = ResourceLocation.read((String)instance.target).error()).isPresent()) {
            return DataResult.error(() -> ((DataResult.Error)error.get()).message());
        }
        if ((instance.type == Type.SCREEN_CLASS || instance.type == Type.SCREEN_TITLE) && instance.slotModifiers.stream().anyMatch(SlotModifier::hasOffset)) {
            return DataResult.error(() -> "Slot modifiers cannot alter position when using a screen_class or screen_title target_type. Use menu_id or menu_class instead");
        }
        return DataResult.success((Object)instance);
    }, Function.identity());

    public GuiModifier(Type type, String target, List<SlotModifier> slotModifiers, int titleX, int titleY, int labelX, int labelY, int xOff, int yOff, int wOff, int hOff, Optional<Integer> titleColor, Optional<Integer> labelColor, List<SimpleSprite> sprites, List<SimpleText> textList, List<WidgetModifier> widgetModifiers, Map<String, SpecialOffset> specialOffsets) {
        this(type, target, slotModifiers, titleX, titleY, labelX, labelY, xOff, yOff, wOff, hOff, (Integer)titleColor.orElse(null), (Integer)labelColor.orElse(null), sprites, textList, widgetModifiers, specialOffsets);
    }

    public boolean targetsClass() {
        return this.type != Type.MENU_ID && this.type != Type.SCREEN_TITLE;
    }

    public boolean targetsMenuId() {
        return this.type == Type.MENU_ID;
    }

    public static enum Type implements StringRepresentable
    {
        MENU_ID,
        MENU_CLASS,
        SCREEN_CLASS,
        SCREEN_TITLE;


        public String getSerializedName() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

