/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.slotify;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.IntStream;
import net.minecraft.util.ExtraCodecs;

public interface IntRange {
    public static final Codec<IntRange> CODEC = new Codec<IntRange>(){
        final Codec<SingleTarget> INT_CODEC = ExtraCodecs.NON_NEGATIVE_INT.xmap(SingleTarget::new, SingleTarget::value);
        final Codec<ListTarget> LIST_CODEC = ExtraCodecs.NON_NEGATIVE_INT.listOf().xmap(ListTarget::new, ListTarget::values);
        final Codec<RangeTarget> RANGE_CODEC = Codec.STRING.comapFlatMap(RangeTarget::read, RangeTarget::toString);

        public <T> DataResult<T> encode(IntRange input, DynamicOps<T> ops, T prefix) {
            if (input instanceof SingleTarget) {
                SingleTarget t = (SingleTarget)input;
                return this.INT_CODEC.encode((Object)t, ops, prefix);
            }
            if (input instanceof ListTarget) {
                ListTarget t = (ListTarget)input;
                return this.LIST_CODEC.encode((Object)t, ops, prefix);
            }
            if (input instanceof RangeTarget) {
                RangeTarget t = (RangeTarget)input;
                return this.RANGE_CODEC.encode((Object)t, ops, prefix);
            }
            throw new IllegalArgumentException("Unsupported implementation type: " + String.valueOf(input.getClass()));
        }

        public <T> DataResult<Pair<IntRange, T>> decode(DynamicOps<T> ops, T input) {
            IntRange target = null;
            Optional r1 = this.INT_CODEC.decode(ops, input).result();
            if (r1.isEmpty()) {
                Optional r2 = this.LIST_CODEC.decode(ops, input).result();
                if (r2.isEmpty()) {
                    Optional r3 = this.RANGE_CODEC.decode(ops, input).result();
                    if (r3.isPresent()) {
                        target = (IntRange)((Pair)r3.get()).getFirst();
                    }
                } else {
                    target = (IntRange)((Pair)r2.get()).getFirst();
                }
            } else {
                target = (IntRange)((Pair)r1.get()).getFirst();
            }
            if (target != null) {
                return DataResult.success((Object)Pair.of((Object)target, input));
            }
            return DataResult.error(() -> "Failed to decode SlotTarget. Must either be an int, an array or a range (i.e. '3->7')");
        }
    };

    public Iterable<Integer> getValues();

    default public boolean has(int value) {
        for (int slot : this.getValues()) {
            if (slot != value) continue;
            return true;
        }
        return false;
    }

    public static IntRange merge(IntRange a, IntRange b) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        a.getValues().forEach(list::add);
        b.getValues().forEach(list::add);
        return new ListTarget(list);
    }

    public record ListTarget(List<Integer> values) implements IntRange
    {
        @Override
        public Iterable<Integer> getValues() {
            return this.values;
        }
    }

    public record SingleTarget(int value) implements IntRange
    {
        @Override
        public Iterable<Integer> getValues() {
            return Collections.singleton(this.value);
        }
    }

    public record RangeTarget(int min, int max) implements IntRange
    {
        @Override
        public Iterable<Integer> getValues() {
            return IntStream.rangeClosed(this.min, this.max)::iterator;
        }

        @Override
        public String toString() {
            return this.min + "->" + this.max;
        }

        public static DataResult<RangeTarget> read(String input) {
            String[] parts = input.split("->");
            if (parts.length != 2) {
                return DataResult.error(() -> "Invalid format. Expected format: 'xOffset->yOffset'");
            }
            try {
                int num1 = Integer.parseInt(parts[0]);
                int num2 = Integer.parseInt(parts[1]);
                if (num1 < 0 || num2 < 0) {
                    return DataResult.error(() -> "Slots must be positive");
                }
                if (num2 <= num1) {
                    return DataResult.error(() -> "Invalid range, min must be smaller than max");
                }
                return DataResult.success((Object)new RangeTarget(num1, num2));
            }
            catch (NumberFormatException e) {
                return DataResult.error(() -> "Invalid number format. Both numbers should be values.");
            }
        }
    }
}

