/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.biome;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.mehvahdjukaar.polytone.PlatStuff;
import net.mehvahdjukaar.polytone.utils.ColorUtils;
import net.mehvahdjukaar.polytone.utils.FogManager;
import net.mehvahdjukaar.polytone.utils.StrOpt;
import net.mehvahdjukaar.polytone.utils.Targets;
import net.mehvahdjukaar.polytone.utils.codec.CodecUtils;
import net.minecraft.core.Holder;
import net.minecraft.sounds.Music;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.level.biome.AmbientAdditionsSettings;
import net.minecraft.world.level.biome.AmbientMoodSettings;
import net.minecraft.world.level.biome.AmbientParticleSettings;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSpecialEffects;

public record BiomeEffectModifier(Optional<Integer> fogColor, Optional<Integer> waterColor, Optional<Integer> waterFogColor, Optional<Integer> skyColor, Optional<Integer> foliageColorOverride, Optional<Integer> grassColorOverride, Optional<BiomeSpecialEffects.GrassColorModifier> grassColorModifier, Optional<AmbientParticleSettings> ambientParticleSettings, Optional<Holder<SoundEvent>> ambientLoopSoundEvent, Optional<AmbientMoodSettings> ambientMoodSettings, Optional<AmbientAdditionsSettings> ambientAdditionsSettings, Optional<Music> backgroundMusic, Optional<FogManager.FogParam> fogFade, Optional<FogManager.FogParam> fogRadius, Targets targets) {
    public static final Codec<BiomeEffectModifier> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)StrOpt.of(ColorUtils.CODEC, "fog_color").forGetter(BiomeEffectModifier::fogColor), (App)StrOpt.of(ColorUtils.CODEC, "water_color").forGetter(BiomeEffectModifier::waterColor), (App)StrOpt.of(ColorUtils.CODEC, "water_fog_color").forGetter(BiomeEffectModifier::waterFogColor), (App)StrOpt.of(ColorUtils.CODEC, "sky_color").forGetter(BiomeEffectModifier::skyColor), (App)StrOpt.of(ColorUtils.CODEC, "foliage_color").forGetter(BiomeEffectModifier::foliageColorOverride), (App)StrOpt.of(ColorUtils.CODEC, "grass_color").forGetter(BiomeEffectModifier::grassColorOverride), (App)StrOpt.of(BiomeSpecialEffects.GrassColorModifier.f_48050_, "grass_color_modifier").forGetter(BiomeEffectModifier::grassColorModifier), (App)StrOpt.of(AmbientParticleSettings.f_47412_, "particle").forGetter(BiomeEffectModifier::ambientParticleSettings), (App)StrOpt.of(SoundEvent.f_263130_, "ambient_sound").forGetter(BiomeEffectModifier::ambientLoopSoundEvent), (App)StrOpt.of(AmbientMoodSettings.f_47386_, "mood_sound").forGetter(BiomeEffectModifier::ambientMoodSettings), (App)StrOpt.of(AmbientAdditionsSettings.f_47371_, "additions_sound").forGetter(BiomeEffectModifier::ambientAdditionsSettings), (App)StrOpt.of(Music.f_11620_, "music").forGetter(BiomeEffectModifier::backgroundMusic), (App)CodecUtils.optionalAlias(FogManager.FogParam.CODEC, "fog_fade", "fog_start").forGetter(BiomeEffectModifier::fogFade), (App)CodecUtils.optionalAlias(FogManager.FogParam.CODEC, "fog_radius", "fog_end").forGetter(BiomeEffectModifier::fogRadius), (App)Targets.CODEC.optionalFieldOf("targets", (Object)Targets.EMPTY).forGetter(BiomeEffectModifier::targets)).apply((Applicative)instance, BiomeEffectModifier::new));

    public static BiomeEffectModifier ofWaterColor(int waterColor) {
        return new BiomeEffectModifier(Optional.empty(), Optional.of(waterColor), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Targets.EMPTY);
    }

    public BiomeEffectModifier merge(BiomeEffectModifier newMod) {
        return new BiomeEffectModifier(newMod.fogColor.isPresent() ? newMod.fogColor() : this.fogColor(), newMod.waterColor().isPresent() ? newMod.waterColor() : this.waterColor(), newMod.waterFogColor().isPresent() ? newMod.waterFogColor() : this.waterFogColor(), newMod.skyColor().isPresent() ? newMod.skyColor() : this.skyColor(), newMod.foliageColorOverride().isPresent() ? newMod.waterColor() : this.foliageColorOverride(), newMod.grassColorOverride().isPresent() ? newMod.grassColorOverride() : this.grassColorOverride(), newMod.grassColorModifier().isPresent() ? newMod.grassColorModifier() : this.grassColorModifier(), newMod.ambientParticleSettings().isPresent() ? newMod.ambientParticleSettings() : this.ambientParticleSettings(), newMod.ambientLoopSoundEvent().isPresent() ? newMod.ambientLoopSoundEvent() : this.ambientLoopSoundEvent(), newMod.ambientMoodSettings().isPresent() ? newMod.ambientMoodSettings() : this.ambientMoodSettings(), newMod.ambientAdditionsSettings().isPresent() ? newMod.ambientAdditionsSettings() : this.ambientAdditionsSettings(), newMod.backgroundMusic().isPresent() ? newMod.backgroundMusic() : this.backgroundMusic(), newMod.fogFade().isPresent() ? newMod.fogFade() : this.fogFade(), newMod.fogRadius().isPresent() ? newMod.fogRadius() : this.fogRadius(), this.targets.merge(newMod.targets));
    }

    public BiomeSpecialEffects apply(Biome biome) {
        BiomeSpecialEffects effects = biome.m_47557_();
        BiomeSpecialEffects.Builder builder = this.getBuilder(effects);
        Optional<Integer> newFoliageColorOverride = effects.m_47981_();
        if (this.foliageColorOverride.isPresent()) {
            newFoliageColorOverride = this.foliageColorOverride;
        }
        newFoliageColorOverride.ifPresent(arg_0 -> ((BiomeSpecialEffects.Builder)builder).m_48043_(arg_0));
        Optional<Integer> newGrassColorOverride = effects.m_47984_();
        if (this.grassColorOverride.isPresent()) {
            newGrassColorOverride = this.grassColorOverride;
        }
        newGrassColorOverride.ifPresent(arg_0 -> ((BiomeSpecialEffects.Builder)builder).m_48045_(arg_0));
        BiomeSpecialEffects.GrassColorModifier newGrassColorModifier = effects.m_47987_();
        if (this.grassColorModifier.isPresent()) {
            newGrassColorModifier = this.grassColorModifier.get();
        }
        builder.m_48031_(newGrassColorModifier);
        Optional<AmbientParticleSettings> newParticle = effects.m_47990_();
        if (this.ambientParticleSettings.isPresent()) {
            newParticle = this.ambientParticleSettings;
        }
        newParticle.ifPresent(arg_0 -> ((BiomeSpecialEffects.Builder)builder).m_48029_(arg_0));
        Optional<Holder<SoundEvent>> newAmbientSound = effects.m_47993_();
        if (this.ambientLoopSoundEvent.isPresent()) {
            newAmbientSound = this.ambientLoopSoundEvent;
        }
        newAmbientSound.ifPresent(arg_0 -> ((BiomeSpecialEffects.Builder)builder).m_48023_(arg_0));
        Optional<AmbientMoodSettings> newMood = effects.m_47996_();
        if (this.ambientMoodSettings.isPresent()) {
            newMood = this.ambientMoodSettings;
        }
        newMood.ifPresent(arg_0 -> ((BiomeSpecialEffects.Builder)builder).m_48027_(arg_0));
        Optional<AmbientAdditionsSettings> newAdditions = effects.m_47999_();
        if (this.ambientAdditionsSettings.isPresent()) {
            newAdditions = this.ambientAdditionsSettings;
        }
        newAdditions.ifPresent(arg_0 -> ((BiomeSpecialEffects.Builder)builder).m_48025_(arg_0));
        Optional<Music> newMusic = effects.m_48002_();
        if (this.backgroundMusic.isPresent()) {
            newMusic = this.backgroundMusic;
        }
        newMusic.ifPresent(arg_0 -> ((BiomeSpecialEffects.Builder)builder).m_48021_(arg_0));
        BiomeSpecialEffects copy = this.copy(effects);
        BiomeEffectModifier.applyEffects(biome, builder.m_48018_());
        return copy;
    }

    private BiomeSpecialEffects.Builder getBuilder(BiomeSpecialEffects effects) {
        BiomeSpecialEffects.Builder builder = new BiomeSpecialEffects.Builder();
        int newFog = effects.m_47967_();
        if (this.fogColor.isPresent()) {
            newFog = this.fogColor.get();
        }
        builder.m_48019_(newFog);
        int newWaterColor = effects.m_47972_();
        if (this.waterColor.isPresent()) {
            newWaterColor = this.waterColor.get();
        }
        builder.m_48034_(newWaterColor);
        int newWaterFogColor = effects.m_47975_();
        if (this.waterFogColor.isPresent()) {
            newWaterFogColor = this.waterFogColor.get();
        }
        builder.m_48037_(newWaterFogColor);
        int newSkyColor = effects.m_47978_();
        if (this.skyColor.isPresent()) {
            newSkyColor = this.skyColor.get();
        }
        builder.m_48040_(newSkyColor);
        return builder;
    }

    private BiomeSpecialEffects copy(BiomeSpecialEffects effects) {
        BiomeSpecialEffects.Builder builder = new BiomeSpecialEffects.Builder();
        builder.m_48019_(effects.m_47967_());
        builder.m_48034_(effects.m_47972_());
        builder.m_48037_(effects.m_47975_());
        builder.m_48040_(effects.m_47978_());
        effects.m_47981_().ifPresent(arg_0 -> ((BiomeSpecialEffects.Builder)builder).m_48043_(arg_0));
        effects.m_47984_().ifPresent(arg_0 -> ((BiomeSpecialEffects.Builder)builder).m_48045_(arg_0));
        builder.m_48031_(effects.m_47987_());
        effects.m_47990_().ifPresent(arg_0 -> ((BiomeSpecialEffects.Builder)builder).m_48029_(arg_0));
        effects.m_47993_().ifPresent(arg_0 -> ((BiomeSpecialEffects.Builder)builder).m_48023_(arg_0));
        effects.m_47996_().ifPresent(arg_0 -> ((BiomeSpecialEffects.Builder)builder).m_48027_(arg_0));
        effects.m_47999_().ifPresent(arg_0 -> ((BiomeSpecialEffects.Builder)builder).m_48025_(arg_0));
        effects.m_48002_().ifPresent(arg_0 -> ((BiomeSpecialEffects.Builder)builder).m_48021_(arg_0));
        return builder.m_48018_();
    }

    public static void applyEffects(Biome biome, BiomeSpecialEffects newEffects) {
        PlatStuff.applyBiomeSurgery(biome, newEffects);
    }

    private static void applyInplace(Biome biome, BiomeSpecialEffects newEffects) {
        BiomeSpecialEffects oldEffects = biome.m_47557_();
        oldEffects.f_47927_ = -1;
        oldEffects.f_47928_ = newEffects.m_47972_();
        oldEffects.f_47929_ = newEffects.m_47975_();
        oldEffects.f_47930_ = -1;
        oldEffects.f_47931_ = newEffects.m_47981_();
        oldEffects.f_47932_ = Optional.of(-1);
        oldEffects.f_47933_ = newEffects.m_47987_();
        oldEffects.f_47934_ = newEffects.m_47990_();
        oldEffects.f_47935_ = newEffects.m_47993_();
        oldEffects.f_47936_ = newEffects.m_47996_();
        oldEffects.f_47937_ = newEffects.m_47999_();
        oldEffects.f_47938_ = newEffects.m_48002_();
    }

    public boolean modifyFogParameter() {
        return this.fogFade.isPresent() || this.fogRadius.isPresent();
    }
}

