/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.colormap;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.mehvahdjukaar.polytone.biome.BiomeIdMapper;
import net.mehvahdjukaar.polytone.colormap.ColormapExpressionProvider;
import net.mehvahdjukaar.polytone.utils.ClientFrameTicker;
import net.mehvahdjukaar.polytone.utils.ColorUtils;
import net.mehvahdjukaar.polytone.utils.ExpressionUtils;
import net.mehvahdjukaar.polytone.utils.exp.IExpression;
import net.mehvahdjukaar.polytone.utils.exp.PolytoneExpression;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class ColormapColorModulatorExpression {
    public static Codec<ColormapColorModulatorExpression> CODEC = RecordCodecBuilder.create(i -> i.group((App)Exp.CODEC.optionalFieldOf("red").forGetter(c -> c.red), (App)Exp.CODEC.optionalFieldOf("green").forGetter(c -> c.green), (App)Exp.CODEC.optionalFieldOf("blue").forGetter(c -> c.blue)).apply((Applicative)i, ColormapColorModulatorExpression::new));
    private final Optional<Exp> red;
    private final Optional<Exp> green;
    private final Optional<Exp> blue;

    protected ColormapColorModulatorExpression(Optional<Exp> red, Optional<Exp> green, Optional<Exp> blue) {
        this.red = red;
        this.green = green;
        this.blue = blue;
    }

    public ColormapColorModulatorExpression createConcurrent() {
        return new ColormapColorModulatorExpression(this.red.map(Exp::createConcurrent), this.green.map(Exp::createConcurrent), this.blue.map(Exp::createConcurrent));
    }

    public int getValue(int original, @Nullable BlockState state, @Nullable BlockPos pos, @Nullable Biome biome, @Nullable BiomeIdMapper mapper, @Nullable ItemStack stack) {
        float[] values = ColorUtils.unpack(original);
        float red = values[0];
        float green = values[1];
        float blue = values[2];
        float newRed = this.red.map(exp -> Float.valueOf(exp.getValue(red, green, blue, state, pos, biome, mapper, stack))).orElse(Float.valueOf(red)).floatValue();
        float newGreen = this.green.map(exp -> Float.valueOf(exp.getValue(red, green, blue, state, pos, biome, mapper, stack))).orElse(Float.valueOf(green)).floatValue();
        float newBlue = this.blue.map(exp -> Float.valueOf(exp.getValue(red, green, blue, state, pos, biome, mapper, stack))).orElse(Float.valueOf(blue)).floatValue();
        return ColorUtils.pack(newRed, newGreen, newBlue);
    }

    protected static class Exp
    extends ColormapExpressionProvider {
        private static final String RED = "RED";
        private static final String GREEN = "GREEN";
        private static final String BLUE = "BLUE";
        private static final String ALPHA = "ALPHA";
        protected static final Codec<Exp> CODEC = Codec.STRING.flatXmap(s -> {
            try {
                return DataResult.success((Object)new Exp((String)s));
            }
            catch (Exception e) {
                return DataResult.error(() -> "Failed to parse expression:" + e.getMessage());
            }
        }, javaxExpression -> DataResult.success((Object)javaxExpression.getUnparsed()));

        protected Exp(String unparsed) {
            super(unparsed);
        }

        protected Exp(String unparsed, boolean concurrent) {
            super(unparsed, concurrent);
        }

        public float getValue(float r, float g, float b, @Nullable BlockState state, @Nullable BlockPos pos, @Nullable Biome biome, @Nullable BiomeIdMapper mapper, @Nullable ItemStack stack) {
            Entity e;
            if (pos == null) {
                pos = BlockPos.f_121853_;
                ExpressionUtils.randomizeRandom();
            } else {
                ExpressionUtils.seedRandom((long)pos.hashCode() * pos.m_121878_());
            }
            IExpression.IVars vb = this.expression.varBuilder();
            vb.setVariable(RED, r);
            vb.setVariable(GREEN, g);
            vb.setVariable(BLUE, b);
            if (this.hasPos) {
                vb.setVariable("POS_X", pos.m_123341_());
                vb.setVariable("POS_Y", pos.m_123342_());
                vb.setVariable("POS_Z", pos.m_123343_());
            }
            if (this.hasTime) {
                vb.setVariable("TIME", ClientFrameTicker.getGameTime());
            }
            if (this.hasDayTime) {
                vb.setVariable("DAY_TIME", ClientFrameTicker.getDayTime());
            }
            if (this.hasSunTime) {
                vb.setVariable("SUN_TIME", ClientFrameTicker.getSunTime());
            }
            if (this.hasRain) {
                vb.setVariable("RAIN", ClientFrameTicker.getRainAndThunder());
            }
            if (this.hasSkyLight) {
                vb.setVariable("SKY_LIGHT", Minecraft.m_91087_().f_91073_.m_45517_(LightLayer.SKY, pos));
            }
            if (this.hasBlockLight) {
                vb.setVariable("BLOCK_LIGHT", Minecraft.m_91087_().f_91073_.m_45517_(LightLayer.BLOCK, pos));
            }
            if (this.hasTemperature) {
                vb.setVariable("TEMPERATURE", biome != null ? (double)ColorUtils.getClimateSettings((Biome)biome).f_47681_ : 0.0);
            }
            if (this.hasDownfall) {
                vb.setVariable("DOWNFALL", biome != null ? (double)ColorUtils.getClimateSettings((Biome)biome).f_47683_ : 0.0);
            }
            if (this.hasPlayer) {
                e = Minecraft.m_91087_().m_91288_();
                vb.setVariable("PLAYER_X", e.m_20185_());
                vb.setVariable("PLAYER_Y", e.m_20186_());
                vb.setVariable("PLAYER_Z", e.m_20189_());
            }
            if (this.hasDistance) {
                e = Minecraft.m_91087_().m_91288_();
                double x = (double)pos.m_123341_() - e.m_20185_();
                double y = (double)pos.m_123342_() - e.m_20186_();
                double z = (double)pos.m_123343_() - e.m_20189_();
                vb.setVariable("DISTANCE_SQUARED", x * x + y * y + z * z);
            }
            if (this.hasPlayerSpeed) {
                vb.setVariable("PLAYER_SPEED_SQUARED", ClientFrameTicker.getPlayerSpeed());
            }
            if (this.hasRenderDistance) {
                vb.setVariable("RENDER_DISTANCE", ClientFrameTicker.getRenderDistance());
            }
            if (stack != null) {
                float damage = 1.0f - (float)stack.m_41773_() / (float)stack.m_41776_();
                vb.setVariable("DAMAGE", damage);
            } else {
                vb.setVariable("DAMAGE", 0.0);
            }
            if (this.hasState) {
                STATE_HACK.set(state);
            }
            float result = (float)this.expression.evaluate(vb);
            STATE_HACK.remove();
            return result;
        }

        @Override
        public Exp createConcurrent() {
            return new Exp(this.getUnparsed(), true);
        }

        @Override
        protected void buildVars(PolytoneExpression.VarBuilder builder) {
            super.buildVars(builder);
            builder.add(RED);
            builder.add(GREEN);
            builder.add(BLUE);
            builder.add(ALPHA);
        }
    }
}

