/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.dimension;

import com.google.gson.JsonElement;
import com.llamalad7.mixinextras.sugar.ref.LocalFloatRef;
import it.unimi.dsi.fastutil.objects.Object2BooleanArrayMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.mehvahdjukaar.polytone.Polytone;
import net.mehvahdjukaar.polytone.block.BlockContextExpression;
import net.mehvahdjukaar.polytone.colormap.Colormap;
import net.mehvahdjukaar.polytone.colormap.ColormapsManager;
import net.mehvahdjukaar.polytone.colormap.IColorGetter;
import net.mehvahdjukaar.polytone.dimension.DimensionEffectsModifier;
import net.mehvahdjukaar.polytone.utils.ArrayImage;
import net.mehvahdjukaar.polytone.utils.ClientFrameTicker;
import net.mehvahdjukaar.polytone.utils.ColorUtils;
import net.mehvahdjukaar.polytone.utils.JsonImgPartialReloader;
import net.mehvahdjukaar.polytone.utils.MapRegistry;
import net.mehvahdjukaar.polytone.utils.Parsed;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.CubicSampler;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class DimensionEffectsManager
extends JsonImgPartialReloader {
    private final MapRegistry<DimensionEffectsModifier> dimensionEffects = new MapRegistry("Dimension Effects Modifiers");
    private final Map<ResourceLocation, DimensionEffectsModifier> alteredVanillaEffects = new HashMap<ResourceLocation, DimensionEffectsModifier>();
    private final Object2ObjectMap<DimensionType, IColorGetter> fogColormaps = new Object2ObjectArrayMap();
    private final Object2ObjectMap<DimensionType, IColorGetter> terrainFogColormaps = new Object2ObjectArrayMap();
    private final Object2ObjectMap<DimensionType, IColorGetter> skyColormaps = new Object2ObjectArrayMap();
    private final Object2ObjectMap<DimensionType, IColorGetter> sunsetColormaps = new Object2ObjectArrayMap();
    private final Object2ObjectMap<DimensionType, BlockContextExpression> cloudFunctions = new Object2ObjectArrayMap();
    private final Object2BooleanArrayMap<DimensionType> cancelFogWeatherDarken = new Object2BooleanArrayMap();
    private final Object2BooleanArrayMap<DimensionType> cancelSkyWeatherDarken = new Object2BooleanArrayMap();
    private boolean needsDynamicApplication = true;
    private final Map<ResourceLocation, Parsed<DimensionEffectsModifier>> extraMods = new HashMap<ResourceLocation, Parsed<DimensionEffectsModifier>>();
    private static float[] lastSunset = null;

    public DimensionEffectsManager() {
        super("dimension_modifiers", "dimension_effects");
    }

    @Override
    protected void resetWithLevel(boolean logOff) {
        this.needsDynamicApplication = true;
        this.dimensionEffects.clear();
        this.fogColormaps.clear();
        this.skyColormaps.clear();
        this.sunsetColormaps.clear();
        this.cancelFogWeatherDarken.clear();
        this.cancelSkyWeatherDarken.clear();
        this.extraMods.clear();
    }

    @Override
    protected void parseWithLevel(JsonImgPartialReloader.Resources resources, RegistryOps<JsonElement> ops, RegistryAccess access) {
        ResourceLocation id;
        Map<ResourceLocation, JsonElement> jsons = resources.jsons();
        HashMap<ResourceLocation, ArrayImage> textures = new HashMap<ResourceLocation, ArrayImage>(resources.textures());
        HashSet<ResourceLocation> usedTextures = new HashSet<ResourceLocation>();
        Parsed.SortedMap<DimensionEffectsModifier> parsedModifiers = Parsed.batchParseAlways(jsons, DimensionEffectsModifier.CODEC, ops, "dimension modifier");
        parsedModifiers.putAll(this.extraMods);
        for (Map.Entry<ResourceLocation, Parsed<DimensionEffectsModifier>> entry : parsedModifiers) {
            ResourceLocation sunsetId;
            ResourceLocation fogId;
            ResourceLocation skyId;
            id = entry.getKey();
            Parsed<DimensionEffectsModifier> parsed = entry.getValue();
            DimensionEffectsModifier modifier = parsed.getResultOrPartial();
            BlockColor fog = modifier.getFogColormap();
            BlockColor sky = modifier.getSkyColormap();
            BlockColor sunset = modifier.getSunsetColormap();
            if (textures.containsKey(id) && fog == null && sky == null) {
                modifier = modifier.merge(DimensionEffectsModifier.ofFogColor(Colormap.createDefTriangle()));
                fog = modifier.getFogColormap();
            }
            if (textures.containsKey(skyId = id.m_266382_("_sky")) && sky == null) {
                modifier = modifier.merge(DimensionEffectsModifier.ofSkyColor(Colormap.createDefTriangle()));
                sky = modifier.getSkyColormap();
            }
            if (textures.containsKey(fogId = id.m_266382_("_fog")) && sky == null) {
                modifier = modifier.merge(DimensionEffectsModifier.ofFogColor(Colormap.createDefTriangle()));
                fog = modifier.getFogColormap();
            }
            if (textures.containsKey(sunsetId = id.m_266382_("_sunset")) && sunset == null) {
                modifier = modifier.merge(DimensionEffectsModifier.ofSunsetColor(Colormap.createTimeStrip()));
                sunset = modifier.getSunsetColormap();
            }
            if (fog != null ^ sky != null ^ sunset != null) {
                ColormapsManager.tryAcceptingTexture(textures, id, fog, usedTextures, false);
                ColormapsManager.tryAcceptingTexture(textures, id, sky, usedTextures, false);
                ColormapsManager.tryAcceptingTexture(textures, id, sunset, usedTextures, false);
            }
            ColormapsManager.tryAcceptingTexture(textures, fogId, fog, usedTextures, true);
            ColormapsManager.tryAcceptingTexture(textures, skyId, sky, usedTextures, true);
            ColormapsManager.tryAcceptingTexture(textures, sunsetId, sunset, usedTextures, true);
            if (!parsed.isEnabled()) continue;
            this.addModifier(id, modifier, access);
        }
        textures.keySet().removeAll(usedTextures);
        for (Map.Entry<ResourceLocation, Object> entry : textures.entrySet()) {
            id = entry.getKey();
            Colormap defaultColormap = Colormap.createDefTriangle();
            ColormapsManager.tryAcceptingTexture(textures, id, (Object)defaultColormap, usedTextures, true);
            this.addModifier(id, DimensionEffectsModifier.ofFogColor(defaultColormap), access);
        }
    }

    private void addModifier(ResourceLocation fileId, DimensionEffectsModifier mod, RegistryAccess registryAccess) {
        this.dimensionEffects.register(fileId, mod);
    }

    @Override
    protected void applyWithLevel(RegistryAccess access, boolean isLogIn) {
        if (!isLogIn && !this.needsDynamicApplication) {
            return;
        }
        this.needsDynamicApplication = false;
        for (Map.Entry<ResourceLocation, DimensionEffectsModifier> v : this.alteredVanillaEffects.entrySet()) {
            v.getValue().applyInplace(v.getKey());
        }
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level != null) {
            this.onDimensionChanged((Level)level, access);
        }
    }

    public void onDimensionChanged(Level level, RegistryAccess access) {
        DimensionType currentDim = level.m_6042_();
        Holder currentDimHolder = level.m_204156_();
        ResourceLocation currentDimId = ((ResourceKey)currentDimHolder.m_203543_().get()).m_135782_();
        for (Map.Entry<ResourceLocation, DimensionEffectsModifier> v : this.dimensionEffects.getEntries()) {
            IColorGetter c;
            ResourceLocation modId = v.getKey();
            DimensionEffectsModifier modifier = v.getValue();
            Collection<Holder<DimensionType>> targets = modifier.targets().compute(modId, access);
            if (!targets.contains(currentDimHolder)) continue;
            DimensionEffectsModifier old = modifier.applyInplace(currentDimId);
            this.alteredVanillaEffects.put(currentDimId, old);
            BlockColor blockColor = modifier.getFogColormap();
            if (blockColor instanceof IColorGetter) {
                c = (IColorGetter)blockColor;
                this.fogColormaps.put((Object)currentDim, (Object)c);
            }
            if ((blockColor = modifier.getSkyColormap()) instanceof Colormap) {
                c = (Colormap)blockColor;
                this.skyColormaps.put((Object)currentDim, (Object)c);
            }
            if ((blockColor = modifier.getSunsetColormap()) instanceof IColorGetter) {
                c = (IColorGetter)blockColor;
                this.sunsetColormaps.put((Object)currentDim, (Object)c);
            }
            if (modifier.noWeatherFogDarken()) {
                this.cancelFogWeatherDarken.put((Object)currentDim, true);
            }
            if (modifier.noWeatherSkyDarken()) {
                this.cancelSkyWeatherDarken.put((Object)currentDim, true);
            }
            if (modifier.cloudLevel().isPresent() && modifier.cloudLevel().get().right().isPresent()) {
                this.cloudFunctions.put((Object)currentDim, (Object)((BlockContextExpression)modifier.cloudLevel().get().right().get()));
            }
            Polytone.LOGGER.info("Applied Custom Dimension Effects Modifier '{}' to dimension '{}'", (Object)modId, (Object)currentDimHolder);
        }
    }

    @Nullable
    public Vec3 modifyFogColor(Vec3 center, ClientLevel level, float brightness) {
        IColorGetter colormap = (IColorGetter)this.fogColormaps.get((Object)level.m_6042_());
        if (colormap == null) {
            return null;
        }
        BiomeManager biomeManager = level.m_7062_();
        return level.m_104583_().m_5927_(CubicSampler.m_130038_((Vec3)center, (qx, qy, qz) -> {
            Biome biome = (Biome)biomeManager.m_204210_(qx, qy, qz).m_203334_();
            int fogColor1 = colormap.sampleColor(null, BlockPos.m_274561_((double)(qx * 4), (double)(qy * 4), (double)(qz * 4)), biome, null);
            return Vec3.m_82501_((int)fogColor1);
        }), brightness);
    }

    public void modifyFogMagicNumber(float renderDistanceChunks, LocalFloatRef distance) {
        float c = 0.25f;
        float b = c + (1.0f - c) * renderDistanceChunks / 32.0f;
        b = 1.0f - (float)Math.pow(b, 0.25);
        float a = 1.0f * renderDistanceChunks / 32.0f;
        a = 1.0f - (float)Math.pow(a, 0.25);
        distance.set(b);
    }

    @Nullable
    public Vec3 modifySkyColor(Vec3 center, ClientLevel level) {
        IColorGetter colormap = (IColorGetter)this.skyColormaps.get((Object)level.m_6042_());
        if (colormap == null) {
            return null;
        }
        BiomeManager biomeManager = level.m_7062_();
        return CubicSampler.m_130038_((Vec3)center, (qx, qy, qz) -> {
            Biome biome = (Biome)biomeManager.m_204210_(qx, qy, qz).m_203334_();
            int skyColor1 = colormap.sampleColor(null, BlockPos.m_274561_((double)(qx * 4), (double)(qy * 4), (double)(qz * 4)), biome, null);
            return Vec3.m_82501_((int)skyColor1);
        });
    }

    @Nullable
    public Float modifyCloudHeight(ClientLevel level) {
        BlockContextExpression height = (BlockContextExpression)this.cloudFunctions.get((Object)level.m_6042_());
        if (height == null) {
            return null;
        }
        BlockPos pos = ClientFrameTicker.getCameraPos();
        double v = height.getValue((Level)level, pos, Blocks.f_50016_.m_49966_());
        if (v >= 10000.0) {
            return Float.valueOf(Float.NaN);
        }
        return Float.valueOf((float)v);
    }

    public boolean shouldCancelFogWeatherDarken(Level level) {
        return this.cancelFogWeatherDarken.getOrDefault((Object)level.m_6042_(), false);
    }

    public boolean shouldCancelSkyWeatherDarken(Level level) {
        return this.cancelSkyWeatherDarken.getOrDefault((Object)level.m_6042_(), false);
    }

    public void addConvertedBlockProperties(Map<ResourceLocation, Parsed<DimensionEffectsModifier>> converted) {
        this.extraMods.clear();
        this.extraMods.putAll(converted);
    }

    public float @Nullable [] modifySunsetColor(float[] old) {
        IColorGetter colormap = (IColorGetter)this.sunsetColormaps.get((Object)Minecraft.m_91087_().f_91073_.m_6042_());
        if (colormap == null) {
            return null;
        }
        int color = colormap.sampleColor(null, ClientFrameTicker.getCameraPos(), (Biome)ClientFrameTicker.getCameraBiome().m_203334_(), null);
        float deltaTime = ClientFrameTicker.getDeltaTime();
        float interpolationFactor = deltaTime * 0.1f;
        float[] c = ColorUtils.unpack(color);
        if (lastSunset == null) {
            lastSunset = new float[]{c[0], c[1], c[2], old[3]};
            return lastSunset;
        }
        DimensionEffectsManager.lastSunset[0] = Mth.m_14179_((float)interpolationFactor, (float)lastSunset[0], (float)c[0]);
        DimensionEffectsManager.lastSunset[1] = Mth.m_14179_((float)interpolationFactor, (float)lastSunset[1], (float)c[1]);
        DimensionEffectsManager.lastSunset[2] = Mth.m_14179_((float)interpolationFactor, (float)lastSunset[2], (float)c[2]);
        DimensionEffectsManager.lastSunset[3] = old[3];
        return lastSunset;
    }
}

