/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.fluid.forge;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.HashMap;
import java.util.Map;
import net.mehvahdjukaar.polytone.Polytone;
import net.mehvahdjukaar.polytone.colormap.IColorGetter;
import net.mehvahdjukaar.polytone.fluid.FluidPropertyModifier;
import net.mehvahdjukaar.polytone.utils.ColorUtils;
import net.mehvahdjukaar.polytone.utils.FogManager;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class FluidPropertiesManagerImpl {
    private static final Map<FluidType, IClientFluidTypeExtensions> FLUID_EXTENSIONS = new HashMap<FluidType, IClientFluidTypeExtensions>();

    public static void tryAddSpecial(Fluid fluid, FluidPropertyModifier prop) {
        FluidType fluidType = fluid.getFluidType();
        IClientFluidTypeExtensions ext = IClientFluidTypeExtensions.of((FluidType)fluidType);
        if (!(ext instanceof FluidExtensionWrapper)) {
            BlockColor tintColormap = prop.getColormap();
            BlockColor fogColormap = prop.getFogColormap();
            if (tintColormap instanceof IColorGetter) {
                IColorGetter c = (IColorGetter)tintColormap;
                tintColormap = Polytone.COLORMAPS.getOrCreateConcurrentColormap(c);
            }
            FogManager.FogParam fogRadius = prop.fogRadius().orElse(null);
            FogManager.FogParam fogFade = prop.fogFade().orElse(null);
            FLUID_EXTENSIONS.put(fluidType, new FluidExtensionWrapper(ext, tintColormap, fogColormap, fogRadius, fogFade));
        }
    }

    public static void clearSpecial() {
        FLUID_EXTENSIONS.clear();
    }

    @Nullable
    public static IClientFluidTypeExtensions maybeGetWrappedExtension(FluidType ft) {
        if (!FLUID_EXTENSIONS.isEmpty()) {
            return FLUID_EXTENSIONS.get(ft);
        }
        return null;
    }

    private record FluidExtensionWrapper(IClientFluidTypeExtensions existingProperties, @Nullable BlockColor tintColor, @Nullable BlockColor fogColor, @Nullable FogManager.FogParam fogRadius, @Nullable FogManager.FogParam forFade) implements IClientFluidTypeExtensions
    {
        public int getTintColor() {
            if (this.tintColor != null) {
                return this.tintColor.m_92566_(null, null, null, -1) | 0xFF000000;
            }
            return this.existingProperties.getTintColor();
        }

        public int getTintColor(FluidStack stack) {
            if (this.tintColor != null) {
                return this.tintColor.m_92566_(null, null, null, -1) | 0xFF000000;
            }
            return this.existingProperties.getTintColor();
        }

        public int getTintColor(FluidState state, BlockAndTintGetter getter, BlockPos pos) {
            if (this.tintColor != null) {
                return this.tintColor.m_92566_(state.m_76188_(), getter, pos, -1) | 0xFF000000;
            }
            return this.existingProperties.getTintColor();
        }

        public ResourceLocation getStillTexture() {
            return this.existingProperties.getStillTexture();
        }

        public ResourceLocation getFlowingTexture() {
            return this.existingProperties.getFlowingTexture();
        }

        @Nullable
        public ResourceLocation getOverlayTexture() {
            return this.existingProperties.getOverlayTexture();
        }

        @Nullable
        public ResourceLocation getRenderOverlayTexture(Minecraft mc) {
            return this.existingProperties.getRenderOverlayTexture(mc);
        }

        public void renderOverlay(Minecraft mc, PoseStack poseStack) {
            this.existingProperties.renderOverlay(mc, poseStack);
        }

        @NotNull
        public Vector3f modifyFogColor(Camera camera, float partialTick, ClientLevel level, int renderDistance, float darkenWorldAmount, Vector3f fluidFogColor) {
            if (this.fogColor != null) {
                return new Vector3f(ColorUtils.unpack(this.fogColor.m_92566_(null, (BlockAndTintGetter)level, null, -1) | 0xFF000000));
            }
            return this.existingProperties.modifyFogColor(camera, partialTick, level, renderDistance, darkenWorldAmount, fluidFogColor);
        }

        public ResourceLocation getStillTexture(FluidState state, BlockAndTintGetter getter, BlockPos pos) {
            return this.existingProperties.getStillTexture(state, getter, pos);
        }

        public ResourceLocation getFlowingTexture(FluidState state, BlockAndTintGetter getter, BlockPos pos) {
            return this.existingProperties.getFlowingTexture(state, getter, pos);
        }

        public ResourceLocation getOverlayTexture(FluidState state, BlockAndTintGetter getter, BlockPos pos) {
            return this.existingProperties.getOverlayTexture(state, getter, pos);
        }

        public ResourceLocation getStillTexture(FluidStack stack) {
            return this.existingProperties.getStillTexture(stack);
        }

        public ResourceLocation getOverlayTexture(FluidStack stack) {
            return this.existingProperties.getOverlayTexture(stack);
        }

        public ResourceLocation getFlowingTexture(FluidStack stack) {
            return this.existingProperties.getFlowingTexture(stack);
        }
    }
}

