/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.utils;

import com.google.common.base.Stopwatch;
import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import net.mehvahdjukaar.polytone.PlatStuff;
import net.mehvahdjukaar.polytone.Polytone;
import net.mehvahdjukaar.polytone.utils.PartialReloader;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.RegistryOps;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.InventoryMenu;

public class CompoundReloader
implements PreparableReloadListener {
    private final List<PartialReloader<?>> children;
    private final List<?> childrenResourcesCache = new ArrayList();

    public CompoundReloader(PartialReloader<?> ... reloaders) {
        this.children = List.of(reloaders);
    }

    public final CompletableFuture<Void> m_5540_(PreparableReloadListener.PreparationBarrier preparationBarrier, ResourceManager resourceManager, ProfilerFiller preparationsProfiler, ProfilerFiller reloadProfiler, Executor backgroundExecutor, Executor gameExecutor) {
        List<CompletableFuture> futures = this.children.stream().map(child -> CompletableFuture.supplyAsync(() -> child.prepare(resourceManager), backgroundExecutor)).collect(Collectors.toList());
        return ((CompletableFuture)((CompletableFuture)CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).thenApply(v -> futures.stream().map(CompletableFuture::join).collect(Collectors.toList()))).thenCompose(arg_0 -> ((PreparableReloadListener.PreparationBarrier)preparationBarrier).m_6769_(arg_0))).thenAcceptAsync(preparedList -> {
            this.childrenResourcesCache.clear();
            this.childrenResourcesCache.addAll((Collection<?>)preparedList);
            ClientLevel level = Minecraft.m_91087_().f_91073_;
            if (level != null) {
                try {
                    this.applyWithLevel(level.m_9598_(), false);
                }
                catch (Exception e) {
                    throw new IllegalStateException(e);
                }
            }
        }, gameExecutor);
    }

    public void applyWithLevel(RegistryAccess registryAccess, boolean firstLogin) {
        ClientLevel level;
        Stopwatch stopwatch = Stopwatch.createStarted();
        if (!firstLogin) {
            this.resetWithLevel(false);
        }
        RegistryOps ops = RegistryOps.m_255058_((DynamicOps)JsonOps.INSTANCE, (HolderLookup.Provider)registryAccess);
        for (int i = 0; i < this.childrenResourcesCache.size(); ++i) {
            PartialReloader<?> c = this.children.get(i);
            try {
                this.processTyped(c, this.childrenResourcesCache.get(i), (RegistryOps<JsonElement>)ops, registryAccess);
                continue;
            }
            catch (Exception e) {
                String message = String.valueOf(c) + " failed to parse some resources";
                Polytone.logException(e, message);
                Polytone.iMessedUp = true;
                Polytone.LOGGER.error(message);
                throw e;
            }
        }
        for (PartialReloader<?> c : this.children) {
            try {
                c.applyWithLevel(registryAccess, firstLogin);
            }
            catch (Exception e) {
                String message = String.valueOf(c) + " failed to apply some resources";
                Polytone.logException(e, message);
                Polytone.iMessedUp = true;
                Polytone.LOGGER.error(message);
                throw e;
            }
        }
        Polytone.LOGGER.info("Reloaded Polytone Resources in {} ms", (Object)stopwatch.elapsed().toMillis());
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null) {
            AbstractContainerMenu container = player.f_36096_;
            InventoryMenu inv = player.f_36095_;
            if (inv.getClass() == InventoryMenu.class) {
                player.f_36095_ = new InventoryMenu(player.m_150109_(), inv.f_39698_, (Player)player);
                if (container == inv) {
                    player.f_36096_ = player.f_36095_;
                }
            }
        }
        if ((level = Minecraft.m_91087_().f_91073_) instanceof ClientLevel) {
            ClientLevel cl = level;
            cl.m_104810_();
        }
    }

    private <T> void processTyped(PartialReloader<T> reloader, Object object, RegistryOps<JsonElement> ops, RegistryAccess access) {
        reloader.parseWithLevel(object, ops, access);
    }

    public void resetWithLevel(boolean isLogOff) {
        for (PartialReloader<?> c : this.children) {
            c.resetWithLevel(isLogOff);
        }
    }

    public void earlyProcess(ResourceManager resourceManager) {
        for (PartialReloader<?> c : this.children) {
            c.earlyProcess(resourceManager);
        }
        PlatStuff.doAddModels();
    }
}

