/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.utils;

import com.google.common.collect.LinkedListMultimap;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.mehvahdjukaar.polytone.PlatStuff;
import net.mehvahdjukaar.polytone.Polytone;
import net.mehvahdjukaar.polytone.biome.BiomeIdMapper;
import net.mehvahdjukaar.polytone.block.BlockPropertyModifier;
import net.mehvahdjukaar.polytone.colormap.Colormap;
import net.mehvahdjukaar.polytone.colormap.ColormapsManager;
import net.mehvahdjukaar.polytone.colormap.IColorGetter;
import net.mehvahdjukaar.polytone.colormap.IColormapNumberProvider;
import net.mehvahdjukaar.polytone.dimension.DimensionEffectsModifier;
import net.mehvahdjukaar.polytone.dimension.DimensionTarget;
import net.mehvahdjukaar.polytone.fluid.FluidPropertyModifier;
import net.mehvahdjukaar.polytone.utils.ArrayImage;
import net.mehvahdjukaar.polytone.utils.BiomeKeysCache;
import net.mehvahdjukaar.polytone.utils.ColorUtils;
import net.mehvahdjukaar.polytone.utils.Parsed;
import net.mehvahdjukaar.polytone.utils.StrOpt;
import net.mehvahdjukaar.polytone.utils.Targets;
import net.minecraft.Util;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RedStoneWireBlock;
import net.minecraft.world.level.block.StemBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class LegacyHelper {
    private static final Map<String, String> PATHS = (Map)Util.m_137469_((Object)new Object2ObjectOpenHashMap(), m -> {
        m.put((Object)"world0", (Object)"overworld");
        m.put((Object)"world0_thunder", (Object)"overworld_thunder");
        m.put((Object)"world0_rain", (Object)"overworld_rain");
        m.put((Object)"world1", (Object)"the_end");
        m.put((Object)"world-1", (Object)"the_nether");
        m.put((Object)"pine", (Object)"spruce_leaves");
        m.put((Object)"birch", (Object)"birch_leaves");
        m.put((Object)"redstone", (Object)"redstone_wire");
        m.put((Object)"pumpkinstem", (Object)"pumpkin_stem");
        m.put((Object)"melonstem", (Object)"melon_stem");
        m.put((Object)"underwater", (Object)"water_fog");
    });
    public static final Decoder<BlockPropertyModifier> OF_JSON_CODEC = RecordCodecBuilder.create(i -> i.group((App)StrOpt.of(Codec.STRING, "format", "").forGetter(c -> ""), (App)StrOpt.of(Codec.STRING.listOf(), "blocks", List.of()).forGetter(c -> List.of()), (App)StrOpt.of(ColorUtils.CODEC, "color").forGetter(c -> Optional.empty()), (App)StrOpt.of(Codec.STRING.xmap(Integer::parseInt, String::valueOf), "yVariance").forGetter(c -> Optional.empty()), (App)StrOpt.of(Codec.STRING.xmap(Integer::parseInt, String::valueOf), "yoffset").forGetter(c -> Optional.empty()), (App)StrOpt.of(Codec.STRING, "source").forGetter(c -> Optional.empty()), (App)StrOpt.of(Codec.BOOL, "force_tint", true).forGetter(c -> true)).apply((Applicative)i, LegacyHelper::decodeOFPropertyJson));
    private static final Object2IntMap<ResourceKey<Biome>> BIOME_ID_MAP = (Object2IntMap)Util.m_137537_(() -> {
        Object2IntOpenHashMap map = new Object2IntOpenHashMap();
        map.put(LegacyHelper.biomeResKey("the_void"), 0);
        map.put(LegacyHelper.biomeResKey("plains"), 1);
        map.put(LegacyHelper.biomeResKey("sunflower_plains"), 2);
        map.put(LegacyHelper.biomeResKey("snowy_plains"), 3);
        map.put(LegacyHelper.biomeResKey("ice_spikes"), 4);
        map.put(LegacyHelper.biomeResKey("desert"), 5);
        map.put(LegacyHelper.biomeResKey("swamp"), 6);
        map.put(LegacyHelper.biomeResKey("mangrove_swamp"), 7);
        map.put(LegacyHelper.biomeResKey("forest"), 8);
        map.put(LegacyHelper.biomeResKey("flower_forest"), 9);
        map.put(LegacyHelper.biomeResKey("birch_forest"), 10);
        map.put(LegacyHelper.biomeResKey("dark_forest"), 11);
        map.put(LegacyHelper.biomeResKey("old_growth_birch_forest"), 12);
        map.put(LegacyHelper.biomeResKey("old_growth_pine_taiga"), 13);
        map.put(LegacyHelper.biomeResKey("old_growth_spruce_taiga"), 14);
        map.put(LegacyHelper.biomeResKey("taiga"), 15);
        map.put(LegacyHelper.biomeResKey("snowy_taiga"), 16);
        map.put(LegacyHelper.biomeResKey("savanna"), 17);
        map.put(LegacyHelper.biomeResKey("savanna_plateau"), 18);
        map.put(LegacyHelper.biomeResKey("windswept_hills"), 19);
        map.put(LegacyHelper.biomeResKey("windswept_gravelly_hills"), 20);
        map.put(LegacyHelper.biomeResKey("windswept_forest"), 21);
        map.put(LegacyHelper.biomeResKey("windswept_savanna"), 22);
        map.put(LegacyHelper.biomeResKey("jungle"), 23);
        map.put(LegacyHelper.biomeResKey("sparse_jungle"), 24);
        map.put(LegacyHelper.biomeResKey("bamboo_jungle"), 25);
        map.put(LegacyHelper.biomeResKey("badlands"), 26);
        map.put(LegacyHelper.biomeResKey("eroded_badlands"), 27);
        map.put(LegacyHelper.biomeResKey("wooded_badlands"), 28);
        map.put(LegacyHelper.biomeResKey("meadow"), 29);
        map.put(LegacyHelper.biomeResKey("cherry_grove"), 30);
        map.put(LegacyHelper.biomeResKey("grove"), 31);
        map.put(LegacyHelper.biomeResKey("snowy_slopes"), 32);
        map.put(LegacyHelper.biomeResKey("frozen_peaks"), 33);
        map.put(LegacyHelper.biomeResKey("jagged_peaks"), 34);
        map.put(LegacyHelper.biomeResKey("stony_peaks"), 35);
        map.put(LegacyHelper.biomeResKey("river"), 36);
        map.put(LegacyHelper.biomeResKey("frozen_river"), 37);
        map.put(LegacyHelper.biomeResKey("beach"), 38);
        map.put(LegacyHelper.biomeResKey("snowy_beach"), 39);
        map.put(LegacyHelper.biomeResKey("stony_shore"), 40);
        map.put(LegacyHelper.biomeResKey("warm_ocean"), 41);
        map.put(LegacyHelper.biomeResKey("lukewarm_ocean"), 42);
        map.put(LegacyHelper.biomeResKey("deep_lukewarm_ocean"), 43);
        map.put(LegacyHelper.biomeResKey("ocean"), 44);
        map.put(LegacyHelper.biomeResKey("deep_ocean"), 45);
        map.put(LegacyHelper.biomeResKey("cold_ocean"), 46);
        map.put(LegacyHelper.biomeResKey("deep_cold_ocean"), 47);
        map.put(LegacyHelper.biomeResKey("frozen_ocean"), 48);
        map.put(LegacyHelper.biomeResKey("deep_frozen_ocean"), 49);
        map.put(LegacyHelper.biomeResKey("mushroom_fields"), 50);
        map.put(LegacyHelper.biomeResKey("dripstone_caves"), 51);
        map.put(LegacyHelper.biomeResKey("lush_caves"), 52);
        map.put(LegacyHelper.biomeResKey("deep_dark"), 53);
        map.put(LegacyHelper.biomeResKey("nether_wastes"), 54);
        map.put(LegacyHelper.biomeResKey("warped_forest"), 55);
        map.put(LegacyHelper.biomeResKey("crimson_forest"), 56);
        map.put(LegacyHelper.biomeResKey("soul_sand_valley"), 57);
        map.put(LegacyHelper.biomeResKey("basalt_deltas"), 58);
        map.put(LegacyHelper.biomeResKey("the_end"), 59);
        map.put(LegacyHelper.biomeResKey("end_highlands"), 60);
        map.put(LegacyHelper.biomeResKey("end_midlands"), 61);
        map.put(LegacyHelper.biomeResKey("small_end_islands"), 62);
        map.put(LegacyHelper.biomeResKey("end_barrens"), 63);
        map.put(LegacyHelper.biomeResKey("pale_garden"), 64);
        return map;
    });

    public static <T> Map<ResourceLocation, T> convertPaths(Map<ResourceLocation, T> map) {
        HashMap<ResourceLocation, T> toUpdate = new HashMap<ResourceLocation, T>();
        ArrayList<ResourceLocation> toRemove = new ArrayList<ResourceLocation>();
        for (Map.Entry<ResourceLocation, T> entry : map.entrySet()) {
            ResourceLocation id = entry.getKey();
            ResourceLocation newPath = LegacyHelper.convertPath(id);
            if (newPath.equals((Object)id)) continue;
            toUpdate.put(newPath, entry.getValue());
            toRemove.add(id);
        }
        toRemove.forEach(map.keySet()::remove);
        map.putAll(toUpdate);
        return map;
    }

    public static ResourceLocation convertPath(ResourceLocation id) {
        String path = PATHS.get(id.m_135815_());
        return path == null ? id : id.m_247449_(path);
    }

    public static Map<ResourceLocation, Parsed<BlockPropertyModifier>> convertBlockProperties(Map<ResourceLocation, Properties> ofProperties, Map<ResourceLocation, ArrayImage> textures) {
        ArrayList<ResourceLocation> ids = new ArrayList<ResourceLocation>();
        ids.addAll(ofProperties.keySet());
        ids.addAll(textures.keySet());
        HashMap<ResourceLocation, Parsed<BlockPropertyModifier>> map = new HashMap<ResourceLocation, Parsed<BlockPropertyModifier>>();
        for (ResourceLocation id : ids) {
            Colormap colormap;
            @Nullable Properties prop = ofProperties.get(id);
            String path = id.m_135815_();
            if (path.equals("stem") || path.equals("melon_stem") || path.equals("pumpkin_stem")) {
                colormap = Colormap.simple((state, level, pos, m, i) -> state != null && state.m_61138_((Property)StemBlock.f_57013_) ? (float)((Integer)state.m_61143_((Property)StemBlock.f_57013_)).intValue() / 7.0f : 0.0f, IColormapNumberProvider.ZERO);
                ArrayList<Block> targets = new ArrayList<Block>();
                if (!path.contains("melon")) {
                    targets.add(Blocks.f_50189_);
                    targets.add(Blocks.f_50187_);
                }
                if (!path.contains("pumpkin")) {
                    targets.add(Blocks.f_50190_);
                    targets.add(Blocks.f_50188_);
                }
                map.put(id, LegacyHelper.withCond(id, prop, BlockPropertyModifier.coloringBlocks((BlockColor)colormap, targets)));
                continue;
            }
            if (path.equals("redstone_wire")) {
                colormap = Colormap.simple(new IColormapNumberProvider(){

                    @Override
                    public float getValue(BlockState state, BlockPos pos, Biome biome, BiomeIdMapper mapper, ItemStack stack) {
                        return state != null ? 1.0f - (float)((Integer)state.m_61143_((Property)RedStoneWireBlock.f_55500_)).intValue() / 15.0f : 1.0f;
                    }

                    @Override
                    public boolean usesBiome() {
                        return false;
                    }

                    @Override
                    public boolean usesPos() {
                        return false;
                    }
                }, IColormapNumberProvider.ZERO);
                map.put(id, LegacyHelper.withCond(id, prop, BlockPropertyModifier.coloringBlocks((BlockColor)colormap, Blocks.f_50088_)));
                continue;
            }
            if (prop == null) continue;
            try {
                BlockPropertyModifier modifier = LegacyHelper.convertOFProperty(prop, id);
                map.put(id, LegacyHelper.withCond(id, prop, modifier));
            }
            catch (Exception e) {
                Polytone.LOGGER.error("FAILED TO CONVERT OPTIFINE COLORMAP AT {}. Its likely the file has errors: ", (Object)id, (Object)e);
            }
        }
        return map;
    }

    private static <T> Parsed<T> withCond(ResourceLocation id, @Nullable Properties prop, T t) {
        return Parsed.lowPriority(t, id, prop == null || LegacyHelper.checkConditions(prop));
    }

    private static boolean checkConditions(Properties prop) {
        boolean ignored = prop.getOrDefault((Object)"polytone_ignore", (Object)false).equals("true");
        if (ignored) {
            return false;
        }
        List<String> requireMods = List.of(prop.getProperty("require_mods", "").split(" "));
        for (String s : requireMods) {
            if (s.isEmpty() || PlatStuff.isModLoaded(s)) continue;
            return false;
        }
        return true;
    }

    private static BlockPropertyModifier decodeOFPropertyJson(String format, List<String> targets, Optional<Integer> singleColor, Optional<Integer> yVariance, Optional<Integer> yoffset, Optional<String> sourceTexture, boolean forceTint) {
        Set<Object> set = new HashSet();
        if (!targets.isEmpty()) {
            set = targets.stream().filter(s -> {
                try {
                    int iHateOptishit = Integer.parseInt(s);
                    return false;
                }
                catch (Exception exception) {
                    return true;
                }
            }).map(ResourceLocation::new).collect(Collectors.toSet());
            if (forceTint) {
                set.forEach(LegacyHelper::forceBlockToHaveTintIndex);
            }
        }
        Integer col = singleColor.orElse(null);
        Colormap colormap = "fixed".equals(format) ? Colormap.createFixed() : ("grid".equals(format) ? Colormap.createBiomeId() : Colormap.createDefTriangle());
        if (col != null) {
            int[][] matrix = new int[][]{{col}};
            colormap.acceptTexture(new ArrayImage(matrix));
        } else if (sourceTexture.isPresent()) {
            ResourceLocation id = new ResourceLocation("none");
            String source = sourceTexture.get().replace("~/colormap/", id.m_135827_() + ":");
            if (source.contains("./")) {
                String path = id.m_135815_();
                int index = path.lastIndexOf(47);
                String directoryPath = index == -1 ? "" : path.substring(0, index + 1);
                source = source.replace("./", id.m_135827_() + ":" + directoryPath);
            }
            colormap.setExplicitTargetTexture(new ResourceLocation(source));
        }
        return new BlockPropertyModifier(Optional.of(colormap), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), List.of(), List.of(), Optional.empty(), Optional.empty(), false, Targets.ofIds(set), false);
    }

    public static BlockPropertyModifier convertOFProperty(Properties properties, ResourceLocation id) {
        Set<Object> set;
        boolean forceTint = Boolean.parseBoolean(properties.getProperty("force_tint", "true"));
        String targets = properties.getProperty("blocks");
        if (targets != null) {
            set = Arrays.stream(targets.split(" ")).filter(s -> {
                try {
                    int iHateOptishit = Integer.parseInt(s);
                    return false;
                }
                catch (Exception exception) {
                    return true;
                }
            }).map(ResourceLocation::new).collect(Collectors.toSet());
            if (forceTint) {
                set.forEach(LegacyHelper::forceBlockToHaveTintIndex);
            }
        } else {
            set = Set.of();
        }
        String format = properties.getProperty("format");
        Integer col = null;
        String singleColor = properties.getProperty("color");
        if (singleColor != null) {
            col = Integer.parseInt(singleColor, 16);
        }
        Colormap colormap = "fixed".equals(format) ? Colormap.createFixed() : ("grid".equals(format) ? Colormap.createBiomeId() : Colormap.createDefTriangle());
        if (col != null) {
            int[][] matrix = new int[][]{{col}};
            colormap.acceptTexture(new ArrayImage(matrix));
        } else {
            Object source = properties.getProperty("source");
            if (source != null) {
                if (((String)source).contains("~")) {
                    source = ((String)source).replace("~/colormap/", id.m_135827_() + ":");
                } else {
                    String path = id.m_135815_();
                    int index = path.lastIndexOf(47);
                    String directoryPath = index == -1 ? "" : path.substring(0, index + 1);
                    source = id.m_135827_() + ":" + directoryPath + ((String)source).replace("./", "");
                }
                colormap.setExplicitTargetTexture(new ResourceLocation((String)source));
            }
        }
        return new BlockPropertyModifier(Optional.of(colormap), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), List.of(), List.of(), Optional.empty(), Optional.empty(), false, Targets.ofOptionalIds(set), false);
    }

    public static Map<ResourceLocation, Parsed<BlockPropertyModifier>> convertInlinedPalettes(Map<ResourceLocation, String> inlineColormaps) {
        HashMap<ResourceLocation, Parsed<BlockPropertyModifier>> map = new HashMap<ResourceLocation, Parsed<BlockPropertyModifier>>();
        int k = 0;
        for (Map.Entry<ResourceLocation, String> special : inlineColormaps.entrySet()) {
            ResourceLocation texturePath = special.getKey();
            Colormap colormap = Colormap.createDefTriangle();
            colormap.setExplicitTargetTexture(texturePath);
            HashSet<ResourceLocation> blockTargets = new HashSet<ResourceLocation>();
            for (String name : special.getValue().split(" ")) {
                if (name.isEmpty()) continue;
                ResourceLocation blockId = ResourceLocation.m_135820_((String)name);
                blockTargets.add(blockId);
                LegacyHelper.forceBlockToHaveTintIndex(blockId);
            }
            if (blockTargets.isEmpty()) continue;
            BlockPropertyModifier mod = BlockPropertyModifier.coloringBlocks((BlockColor)colormap, blockTargets);
            ResourceLocation id = texturePath.m_266382_("-color_prop_palette_" + k++);
            map.put(id, Parsed.success(mod, id));
        }
        return map;
    }

    private static void forceBlockToHaveTintIndex(ResourceLocation blockId) {
        Block block;
        Optional b = BuiltInRegistries.f_256975_.m_6612_(blockId);
        if (b.isPresent() && (block = (Block)b.get()) != Blocks.f_50088_ && block != Blocks.f_50189_ && block != Blocks.f_50190_) {
            Polytone.VARIANT_TEXTURES.addTintOverrideHack(block);
        }
    }

    public static int getBiomeId(Biome biome) {
        return BIOME_ID_MAP.getOrDefault(BiomeKeysCache.get(biome), 0);
    }

    private static ResourceKey<Biome> biomeResKey(String endBarrens) {
        return ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)new ResourceLocation(endBarrens));
    }

    public static void convertOfBlockToFluidProp(LinkedListMultimap<ResourceLocation, Parsed<BlockPropertyModifier>> parsedModifiers, Map<ResourceLocation, ArrayImage> textures) {
        Parsed parsed;
        ResourceLocation id;
        HashMap<ResourceLocation, Parsed> fluid = new HashMap<ResourceLocation, Parsed>();
        HashMap<ResourceLocation, Parsed> fog = new HashMap<ResourceLocation, Parsed>();
        HashMap<ResourceLocation, ArrayImage> filteredTextures = new HashMap<ResourceLocation, ArrayImage>();
        for (Map.Entry entry : parsedModifiers.entries()) {
            id = (ResourceLocation)entry.getKey();
            parsed = (Parsed)entry.getValue();
            BlockPropertyModifier modifier = (BlockPropertyModifier)parsed.getResultOrPartial();
            IColorGetter colormap = modifier.getColormap();
            if (!(colormap instanceof Colormap)) continue;
            Colormap c = (Colormap)colormap;
            String path = id.m_135815_();
            if (!path.contains("water") && !path.contains("lava")) continue;
            if (path.endsWith("_fog") || path.contains("under")) {
                fog.put(id, parsed);
            } else {
                fluid.put(id, parsed);
            }
            ResourceLocation targetTexture = c.getTargetTexture(id);
            c.setExplicitTargetTexture(LegacyHelper.convertPath(targetTexture));
            if (!textures.containsKey(targetTexture)) continue;
            filteredTextures.put(targetTexture, textures.get(targetTexture));
        }
        for (Map.Entry entry : textures.entrySet()) {
            id = (ResourceLocation)entry.getKey();
            if (!id.m_135827_().equals("minecraft") || !id.m_135815_().contains("water") && !id.m_135815_().contains("lava")) continue;
            filteredTextures.put(id, (ArrayImage)entry.getValue());
        }
        textures.keySet().removeAll(filteredTextures.keySet());
        parsedModifiers.keySet().removeAll(fluid.keySet());
        HashMap<ResourceLocation, Parsed<FluidPropertyModifier>> converted = new HashMap<ResourceLocation, Parsed<FluidPropertyModifier>>();
        for (Map.Entry f : fluid.entrySet()) {
            parsed = (Parsed)f.getValue();
            BlockPropertyModifier mod = (BlockPropertyModifier)parsed.getResultOrPartial();
            ResourceLocation id2 = (ResourceLocation)f.getKey();
            Targets targets = mod.targets();
            targets.addSimple(id2);
            targets.addSimple(id2.m_246208_("flowing_"));
            Optional<BlockPropertyModifier> fogMod = Optional.ofNullable((Parsed)fog.get(id2.m_266382_("_fog"))).map(Parsed::getResultOrPartial);
            FluidPropertyModifier modifier = new FluidPropertyModifier(mod.tintGetter(), fogMod.map(BlockPropertyModifier::getColormap), Optional.empty(), Optional.empty(), targets);
            Parsed<FluidPropertyModifier> parsedModifier = Parsed.lowPriority(modifier, id2, parsed.isEnabled());
            converted.put(id2, parsedModifier);
        }
        Polytone.FLUID_MODIFIERS.addConvertedBlockProperties(converted, filteredTextures);
    }

    public static void convertOfBlockToDimensionProperties(LinkedListMultimap<ResourceLocation, Parsed<BlockPropertyModifier>> parsedModifiers, Map<ResourceLocation, ArrayImage> textures) {
        Object modifier;
        String stringId;
        ResourceLocation id;
        HashMap<ResourceLocation, Parsed<BlockPropertyModifier>> filtered = new HashMap<ResourceLocation, Parsed<BlockPropertyModifier>>();
        HashMap<ResourceLocation, ArrayImage> filteredTextures = new HashMap<ResourceLocation, ArrayImage>();
        Pattern fogP = Pattern.compile("minecraft:(?:fog|fogcolor)[0-2]\\b");
        Pattern skyP = Pattern.compile("minecraft:(?:sky|skycolor)[0-2]\\b");
        for (Map.Entry entry : parsedModifiers.entries()) {
            id = (ResourceLocation)entry.getKey();
            stringId = id.toString();
            modifier = (Parsed)entry.getValue();
            if (!fogP.matcher(stringId).matches() && !skyP.matcher(stringId).matches()) continue;
            filtered.put(id, (Parsed<BlockPropertyModifier>)modifier);
        }
        for (Map.Entry entry : textures.entrySet()) {
            id = (ResourceLocation)entry.getKey();
            stringId = id.toString();
            modifier = (ArrayImage)entry.getValue();
            if (!fogP.matcher(stringId).matches() && !skyP.matcher(stringId).matches()) continue;
            filteredTextures.put(id, (ArrayImage)modifier);
        }
        textures.keySet().removeAll(filteredTextures.keySet());
        parsedModifiers.keySet().removeAll(filtered.keySet());
        LegacyHelper.addConvertedBlockProperties(filtered, filteredTextures);
    }

    private static void addConvertedBlockProperties(Map<ResourceLocation, Parsed<BlockPropertyModifier>> modifiers, Map<ResourceLocation, ArrayImage> textures) {
        String[] names = new String[]{"overworld", "the_nether", "the_end"};
        HashMap<ResourceLocation, Parsed<DimensionEffectsModifier>> converted = new HashMap<ResourceLocation, Parsed<DimensionEffectsModifier>>();
        for (int i = 0; i <= 2; ++i) {
            boolean fogEnabled;
            IColorGetter fogCol;
            IColorGetter skyCol;
            ResourceLocation skyKey = ResourceLocation.m_135820_((String)("sky" + i));
            ResourceLocation skyKey2 = ResourceLocation.m_135820_((String)("skycolor" + i));
            Parsed<BlockPropertyModifier> skyMod = modifiers.get(skyKey);
            if (skyMod == null) {
                skyMod = modifiers.get(skyKey2);
                skyKey = skyKey2;
            }
            ArrayImage skyImage = textures.get(skyKey);
            IColorGetter iColorGetter = skyMod != null ? skyMod.getResultOrPartial().getColormap() : (skyCol = skyImage == null ? null : Colormap.createDefTriangle());
            if (skyCol != null) {
                ColormapsManager.tryAcceptingTexture(textures, skyKey, skyCol, new HashSet<ResourceLocation>(), true);
            }
            boolean skyEnabled = skyMod == null || skyMod.isEnabled();
            ResourceLocation fogKey = new ResourceLocation("fog" + i);
            ResourceLocation fogKey2 = new ResourceLocation("fogcolor" + i);
            Parsed<BlockPropertyModifier> fogMod = modifiers.get(fogKey);
            if (fogMod == null) {
                fogMod = modifiers.get(fogKey2);
                fogKey = fogKey2;
            }
            ArrayImage fogImage = textures.get(fogKey);
            IColorGetter iColorGetter2 = fogMod != null ? fogMod.getResultOrPartial().getColormap() : (fogCol = fogImage == null ? null : Colormap.createDefTriangle());
            if (fogCol != null) {
                ColormapsManager.tryAcceptingTexture(textures, fogKey, fogCol, new HashSet<ResourceLocation>(), true);
            }
            boolean bl = fogEnabled = fogMod == null || fogMod.isEnabled();
            if (fogCol == null && skyCol == null) continue;
            DimensionEffectsModifier mod = new DimensionEffectsModifier(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.ofNullable(fogCol), Optional.ofNullable(skyCol), Optional.empty(), false, false, Optional.empty(), DimensionTarget.EMPTY);
            ResourceLocation id = new ResourceLocation(names[i]);
            boolean enabled = fogEnabled || skyEnabled;
            Parsed<DimensionEffectsModifier> parsedMod = Parsed.lowPriority(mod, id, enabled);
            converted.put(id, parsedMod);
        }
        Polytone.DIMENSION_MODIFIERS.addConvertedBlockProperties(converted);
    }
}

