/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.utils.codec;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Lifecycle;
import java.util.Optional;
import net.mehvahdjukaar.polytone.Polytone;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderOwner;
import net.minecraft.core.Registry;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;

public final class ForwardAwareRegistryFixedCodec<E>
implements Codec<Optional<Holder<E>>> {
    private final ResourceKey<? extends Registry<E>> registryKey;

    ForwardAwareRegistryFixedCodec(ResourceKey<? extends Registry<E>> registryKey) {
        this.registryKey = registryKey;
    }

    public <T> DataResult<T> encode(Optional<Holder<E>> opt, DynamicOps<T> ops, T value) {
        if (ops instanceof RegistryOps) {
            RegistryOps registryOps = (RegistryOps)ops;
            Optional optional = registryOps.m_255056_(this.registryKey);
            if (opt.isEmpty()) {
                return DataResult.success(value, (Lifecycle)Lifecycle.stable());
            }
            Holder holder = opt.get();
            if (optional.isPresent()) {
                if (!holder.m_203401_((HolderOwner)optional.get())) {
                    return DataResult.error(() -> "Element " + String.valueOf(holder) + " is not valid in current registry set");
                }
                return (DataResult)holder.m_203439_().map(resourceKey -> ResourceLocation.f_135803_.encode((Object)resourceKey.m_135782_(), ops, value), object -> DataResult.error(() -> "Elements from registry " + String.valueOf(this.registryKey) + " can't be serialized to a value"));
            }
        }
        return DataResult.error(() -> "Can't access registry " + String.valueOf(this.registryKey));
    }

    public <T> DataResult<Pair<Optional<Holder<E>>, T>> decode(DynamicOps<T> dynamicOps, T object) {
        RegistryOps registryOps;
        Optional optional;
        if (dynamicOps instanceof RegistryOps && (optional = (registryOps = (RegistryOps)dynamicOps).m_255006_(this.registryKey)).isPresent()) {
            HolderGetter registry = (HolderGetter)optional.get();
            return ResourceLocation.f_135803_.decode(dynamicOps, object).flatMap(pair -> {
                ResourceLocation resourceLocation = (ResourceLocation)pair.getFirst();
                ResourceKey resKey = ResourceKey.m_135785_(this.registryKey, (ResourceLocation)resourceLocation);
                Optional eReference = registry.m_254902_(resKey);
                if (eReference.isPresent()) {
                    return DataResult.success((Object)eReference);
                }
                if (this.isBlacklisted(resourceLocation)) {
                    return DataResult.success(Optional.empty());
                }
                return DataResult.error(() -> "Failed to get element " + String.valueOf(resourceLocation));
            }).map(reference -> Pair.of((Object)reference, (Object)object)).setLifecycle(Lifecycle.stable());
        }
        return DataResult.error(() -> "Can't access registry " + String.valueOf(this.registryKey));
    }

    public String toString() {
        return "RegistryFixedCodec[" + String.valueOf(this.registryKey) + "]";
    }

    private boolean isBlacklisted(ResourceLocation id) {
        return Polytone.isFutureId(id);
    }
}

