/*
 * Decompiled with CFR 0.152.
 */
package travelers.server.animal.obj.animation;

import net.minecraft.class_1297;
import net.minecraft.class_3414;
import travelers.server.animal.ModelType;
import travelers.server.animal.entity.GeckoSmartAnimalBase;
import travelers.server.animal.entity.SmartAnimalBase;
import travelers.server.animal.obj.animation.PlayBehaviourType;
import travelers.server.animal.obj.animation.TravelersAnimationControllers;
import travelers.server.animal.obj.animation.TravelersAnimationWrapper;
import travelers.server.animal.obj.animation.TravelersAzAnimation;
import travelers.server.animal.obj.animation.TravelersGeckoAnimation;
import travelers.server.animal.obj.animation.TravelersSoundAnimationDefinition;
import travelers.util.helper.PlatformHelper;

public class TravelersAnimationDefinition {
    protected final String name;
    protected final TravelersAnimationControllers.AnimationController controller;
    private final PlayBehaviourType playbehaviour;
    protected boolean physicsEnabled = true;
    protected boolean canLook = true;
    protected int defaultTickDuration = 0;
    private TravelersAzAnimation azureAnimation;
    private TravelersGeckoAnimation geckoAnimation;

    public TravelersAnimationDefinition(String name, TravelersAnimationControllers.AnimationController controller, PlayBehaviourType playBehaviour) {
        this.name = name;
        this.controller = controller;
        this.playbehaviour = playBehaviour;
        if (PlatformHelper.properties.isModLoaded("azurelib")) {
            this.azureAnimation = new TravelersAzAnimation(name, controller, playBehaviour);
        }
        if (PlatformHelper.properties.isModLoaded("geckolib")) {
            this.geckoAnimation = new TravelersGeckoAnimation(name, controller, playBehaviour);
        }
    }

    public TravelersAnimationDefinition(String name, PlayBehaviourType playBehaviour, int transitionLength) {
        this.name = name;
        this.playbehaviour = playBehaviour;
        this.controller = TravelersAnimationControllers.rootController;
        if (PlatformHelper.properties.isModLoaded("azurelib")) {
            this.azureAnimation = new TravelersAzAnimation(name, this.controller, playBehaviour, transitionLength);
        }
        if (PlatformHelper.properties.isModLoaded("geckolib")) {
            this.geckoAnimation = new TravelersGeckoAnimation(name, this.controller, playBehaviour, transitionLength);
        }
    }

    public TravelersAnimationDefinition disablePhysics() {
        this.physicsEnabled = false;
        return this;
    }

    public TravelersAnimationDefinition disableLook() {
        this.canLook = false;
        return this;
    }

    public TravelersSoundAnimationDefinition soundAndLength(class_3414 event, int length) {
        return new TravelersSoundAnimationDefinition(event, this, length, 0, 0);
    }

    public TravelersSoundAnimationDefinition soundAndLength(class_3414 event, int length, int offset) {
        return new TravelersSoundAnimationDefinition(event, this, length, offset, 0);
    }

    public TravelersSoundAnimationDefinition soundAndLength(class_3414 event, int length, int offset, int secondaryOffset) {
        return new TravelersSoundAnimationDefinition(event, this, length, offset, secondaryOffset);
    }

    public TravelersAnimationWrapper wrap(int animationDuration) {
        return new TravelersAnimationWrapper(this, animationDuration);
    }

    public TravelersAnimationWrapper wrap() {
        return new TravelersAnimationWrapper(this);
    }

    public void sendForEntity(ModelType type, class_1297 e) {
        if (type == ModelType.AZURE) {
            if (this.azureAnimation != null) {
                this.azureAnimation.sendForEntity(e);
            }
        } else if (type == ModelType.GECKO && e instanceof GeckoSmartAnimalBase) {
            GeckoSmartAnimalBase smartAnimalBase = (GeckoSmartAnimalBase)e;
            if (this.geckoAnimation != null) {
                this.geckoAnimation.sendForEntity(smartAnimalBase);
            }
        }
    }

    public void sendForEntity(SmartAnimalBase e) {
        if (e.getAnimal().getModelType() == ModelType.AZURE) {
            if (this.azureAnimation != null) {
                this.azureAnimation.sendForEntity((class_1297)e);
            }
        } else if (e.getAnimal().getModelType() == ModelType.GECKO && e instanceof GeckoSmartAnimalBase) {
            GeckoSmartAnimalBase smartAnimalBase = (GeckoSmartAnimalBase)e;
            if (this.geckoAnimation != null) {
                this.geckoAnimation.sendForEntity(smartAnimalBase);
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public TravelersAnimationControllers.AnimationController getController() {
        return this.controller;
    }

    public PlayBehaviourType getPlaybehaviour() {
        return this.playbehaviour;
    }

    public boolean isPhysicsEnabled() {
        return this.physicsEnabled;
    }

    public boolean isCanLook() {
        return this.canLook;
    }

    public int getDefaultTickDuration() {
        return this.defaultTickDuration;
    }

    public TravelersAzAnimation getAzureAnimation() {
        return this.azureAnimation;
    }

    public TravelersGeckoAnimation getGeckoAnimation() {
        return this.geckoAnimation;
    }
}

