/*
 * Decompiled with CFR 0.152.
 */
package travelers;

import java.util.HashSet;
import java.util.Iterator;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.Entity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.ViewportEvent;
import net.neoforged.neoforge.event.entity.EntityLeaveLevelEvent;
import travelers.client.TravelersClient;
import travelers.client.misc.CameraShakeHandler;
import travelers.client.render.animation.entity.TravelersAnimationMap;
import travelers.client.render.animation.entity.obj.TravelersClientAnimator;
import travelers.server.animal.entity.SmartAnimalBase;

@EventBusSubscriber(modid="travelerslib", bus=EventBusSubscriber.Bus.GAME, value={Dist.CLIENT})
public class ClientGameEvents {
    @SubscribeEvent
    public static void clientTickEvent(ClientTickEvent.Post event) {
        Iterator<CameraShakeHandler.ShakeInstance> it = CameraShakeHandler.shakes.iterator();
        while (it.hasNext()) {
            CameraShakeHandler.ShakeInstance s = it.next();
            --s.ticks;
            if (s.ticks > 0) continue;
            it.remove();
        }
        ++TravelersClient.clientTicks;
        Minecraft mc = Minecraft.getInstance();
        if (mc.level == null) {
            TravelersClient.getUuidEntityMap().clear();
            return;
        }
        HashSet<Entity> loadedThisTick = new HashSet<Entity>();
        for (Entity e : mc.level.entitiesForRendering()) {
            loadedThisTick.add(e);
        }
        for (Entity entity : loadedThisTick) {
            if (TravelersClient.getUuidEntityMap().containsKey(entity.getUUID())) continue;
            TravelersClient.getUuidEntityMap().put(entity.getUUID(), entity);
        }
        TravelersClient.getUuidEntityMap().entrySet().removeIf(uuidEntityEntry -> !loadedThisTick.contains(uuidEntityEntry.getValue()));
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST, receiveCanceled=true)
    public static void entityLeaveEvent(EntityLeaveLevelEvent event) {
        SmartAnimalBase a;
        TravelersClientAnimator animator;
        if (!event.getLevel().isClientSide) {
            return;
        }
        Entity entity = event.getEntity();
        if (entity instanceof SmartAnimalBase && (animator = TravelersAnimationMap.get(a = (SmartAnimalBase)entity)) != null) {
            animator.remove(a);
        }
    }

    @SubscribeEvent
    public static void onCameraAngles(ViewportEvent.ComputeCameraAngles event) {
        if (!CameraShakeHandler.shakes.isEmpty()) {
            float maxStrength = 0.0f;
            for (CameraShakeHandler.ShakeInstance s : CameraShakeHandler.shakes) {
                if (s.checkForGround && !event.getCamera().getEntity().onGround() || !(s.strength > maxStrength)) continue;
                maxStrength = s.strength;
            }
            float totalYaw = (float)((Math.random() - 0.5) * (double)maxStrength);
            float totalPitch = (float)((Math.random() - 0.5) * (double)maxStrength);
            event.setYaw(event.getYaw() + totalYaw);
            event.setPitch(event.getPitch() + totalPitch);
        }
    }

    @SubscribeEvent
    public static void onCameraFov(ViewportEvent.ComputeFov event) {
        if (!CameraShakeHandler.shakes.isEmpty()) {
            float maxStrength = 0.0f;
            for (CameraShakeHandler.ShakeInstance s : CameraShakeHandler.shakes) {
                if (s.checkForGround && !event.getCamera().getEntity().onGround() || !(s.strength > maxStrength)) continue;
                maxStrength = s.strength;
            }
            float totalFov = (float)((Math.random() - 0.5) * (double)(maxStrength + maxStrength));
            event.setFOV(event.getFOV() + (double)totalFov);
        }
    }
}

