/*
 * Decompiled with CFR 0.152.
 */
package travelers;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import travelers.TravelersMain;

public class TravelersDebug {
    public static final HashSet<String> ENABLED_DEBUGS = new HashSet();
    public static final LiteralArgumentBuilder<CommandSourceStack> debugCommand = (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"travelers").requires(p_136318_ -> p_136318_.hasPermission(2))).then(Commands.literal((String)"rendering").then(Commands.argument((String)"debugType", (ArgumentType)StringArgumentType.greedyString()).suggests((context, builder) -> {
        builder.suggest("path").suggest("goal").suggest("chunkrender").suggest("collisionbox").suggest("water").suggest("chunkborder").suggest("heightmap").suggest("neighbours").suggest("structures").suggest("light").suggest("worldgen").suggest("solidface").suggest("skylight");
        for (String registeredLocation : TravelersMain.registeredLocations) {
            builder.suggest(registeredLocation.toLowerCase(Locale.ROOT) + "_only");
        }
        return builder.buildFuture();
    }).executes(context -> {
        String value = (String)context.getArgument("debugType", String.class);
        Iterator<String> iterator = TravelersMain.registeredLocations.iterator();
        if (iterator.hasNext()) {
            String registeredLocation = iterator.next();
            if (value.equalsIgnoreCase(registeredLocation.toLowerCase(Locale.ROOT) + "_only")) {
                if (ENABLED_DEBUGS.contains(registeredLocation.toLowerCase(Locale.ROOT))) {
                    ENABLED_DEBUGS.remove(registeredLocation.toLowerCase(Locale.ROOT));
                } else {
                    ENABLED_DEBUGS.add(registeredLocation.toLowerCase(Locale.ROOT));
                }
            }
            ((CommandSourceStack)context.getSource()).getPlayer().sendSystemMessage((Component)Component.literal((String)"TL > ").withStyle(ChatFormatting.RED).append((Component)Component.translatable((String)"command.travelers.debug.update")).withStyle(ChatFormatting.GRAY));
            return 0;
        }
        switch (value) {
            case "debugVanilla": {
                debugVanillaAnimals = !debugVanillaAnimals;
                break;
            }
            case "skylight": {
                debugSkyLight = !debugSkyLight;
                break;
            }
            case "solidface": {
                debugSolidFace = !debugSolidFace;
                break;
            }
            case "worldgen": {
                debugWorldGenAttempt = !debugWorldGenAttempt;
                break;
            }
            case "light": {
                debugLight = !debugLight;
                break;
            }
            case "structures": {
                debugStructures = !debugStructures;
                break;
            }
            case "neighbours": {
                debugNeighbors = !debugNeighbors;
                break;
            }
            case "heightmap": {
                debugHeightMap = !debugHeightMap;
                break;
            }
            case "chunkborder": {
                debugChunkBorder = !debugChunkBorder;
                break;
            }
            case "water": {
                debugWater = !debugWater;
                break;
            }
            case "path": {
                debugPath = !debugPath;
                break;
            }
            case "goal": {
                debugGoal = !debugGoal;
                break;
            }
            case "chunkrender": {
                debugChunkRender = !debugChunkRender;
                break;
            }
            case "collisionbox": {
                debugCollisionBox = !debugCollisionBox;
                break;
            }
            default: {
                ((CommandSourceStack)context.getSource()).getPlayer().sendSystemMessage((Component)Component.literal((String)"TL > ").withStyle(ChatFormatting.RED).append((Component)Component.translatable((String)"command.travelers.debug.update")).withStyle(ChatFormatting.GRAY));
                return 0;
            }
        }
        ((CommandSourceStack)context.getSource()).getPlayer().sendSystemMessage((Component)Component.literal((String)"TL > ").withStyle(ChatFormatting.RED).append((Component)Component.translatable((String)"command.travelers.debug.update")).withStyle(ChatFormatting.GRAY));
        return 0;
    })));
    public static boolean debugVanillaAnimals = true;
    public static boolean debugPath = true;
    public static boolean debugGoal = false;
    public static boolean debugWater = false;
    public static boolean debugChunkBorder = false;
    public static boolean debugHeightMap = false;
    public static boolean debugCollisionBox = false;
    public static boolean debugNeighbors = false;
    public static boolean debugStructures = false;
    public static boolean debugLight = false;
    public static boolean debugWorldGenAttempt = false;
    public static boolean debugSolidFace = false;
    public static boolean debugChunkRender = false;
    public static boolean debugSkyLight = false;
}

