/*
 * Decompiled with CFR 0.152.
 */
package travelers.client.render.animal.azure;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.UUID;
import mod.azure.azurelib.common.model.AzBone;
import mod.azure.azurelib.common.render.AzLayerRenderer;
import mod.azure.azurelib.common.render.AzRendererPipelineContext;
import mod.azure.azurelib.common.render.entity.AzEntityModelRenderer;
import mod.azure.azurelib.common.render.entity.AzEntityRendererPipeline;
import mod.azure.azurelib.common.util.client.RenderUtils;
import net.minecraft.world.entity.Entity;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import travelers.client.render.animal.azure.TravelersAzureAnimalPipeline;
import travelers.client.render.animation.entity.TravelersAnimationMap;
import travelers.client.render.animation.entity.obj.TravelersBoneState;
import travelers.client.render.animation.entity.obj.TravelersClientAnimator;
import travelers.server.animal.entity.SmartAnimalBase;

public class TravelersAzureModelRenderer
extends AzEntityModelRenderer<SmartAnimalBase> {
    private final TravelersAzureAnimalPipeline entityRendererPipeline;
    private TravelersClientAnimator animalAnimator = null;
    private boolean checkForAnimator = true;
    private boolean hasAnimator = false;
    private final Matrix4f poseState = new Matrix4f();
    private final Matrix4f localMatrix = new Matrix4f();
    private final Matrix4f tempMatrix = new Matrix4f();

    public TravelersAzureModelRenderer(TravelersAzureAnimalPipeline entityRendererPipeline, AzLayerRenderer<UUID, SmartAnimalBase> layerRenderer) {
        super((AzEntityRendererPipeline)entityRendererPipeline, layerRenderer);
        this.entityRendererPipeline = entityRendererPipeline;
    }

    public void render(AzRendererPipelineContext<UUID, SmartAnimalBase> context, boolean isReRender) {
        if (this.checkForAnimator) {
            this.getAnimalAnimator((SmartAnimalBase)context.animatable());
        }
        if (this.hasAnimator && !isReRender) {
            this.animalAnimator.beginFrame();
            this.animalAnimator.update((SmartAnimalBase)context.animatable(), context.partialTick());
        }
        super.render(context, isReRender);
    }

    public TravelersClientAnimator getAnimalAnimator(SmartAnimalBase base) {
        if (this.animalAnimator == null && this.checkForAnimator) {
            this.animalAnimator = TravelersAnimationMap.get(base);
            this.hasAnimator = this.animalAnimator != null;
            this.checkForAnimator = false;
        }
        return this.animalAnimator;
    }

    public void renderRecursively(AzRendererPipelineContext<UUID, SmartAnimalBase> context, AzBone bone, boolean isReRender) {
        SmartAnimalBase entity = (SmartAnimalBase)context.animatable();
        PoseStack poseStack = context.poseStack();
        poseStack.pushPose();
        TravelersBoneState boneState = null;
        if (this.hasAnimator && (boneState = this.animalAnimator.getCachedBoneState(bone.getName())) == null) {
            boneState = this.animalAnimator.updateAnimationOnBone(entity, bone.getName());
            this.animalAnimator.cacheBoneState(bone.getName(), boneState);
        }
        RenderUtils.translateMatrixToBone((PoseStack)poseStack, (AzBone)bone);
        if (boneState != null) {
            poseStack.translate(boneState.offsetX / 16.0f, -boneState.offsetY / 16.0f, boneState.offsetZ / 16.0f);
        }
        RenderUtils.translateToPivotPoint((PoseStack)poseStack, (AzBone)bone);
        this.rotateMatrixAroundBone(poseStack, boneState, bone);
        RenderUtils.scaleMatrixForBone((PoseStack)poseStack, (AzBone)bone);
        if (bone.isTrackingMatrices()) {
            this.poseState.set((Matrix4fc)poseStack.last().pose());
            this.tempMatrix.set((Matrix4fc)RenderUtils.invertAndMultiplyMatrices((Matrix4f)this.poseState, (Matrix4f)this.entityRendererPipeline.getRenderTranslations()));
            bone.setModelSpaceMatrix(RenderUtils.invertAndMultiplyMatrices((Matrix4f)this.poseState, (Matrix4f)this.entityRendererPipeline.getModelRenderTranslations()));
            this.localMatrix.set((Matrix4fc)RenderUtils.translateMatrix((Matrix4f)this.tempMatrix, (Vector3f)this.entityRendererPipeline.getRenderer().getRenderOffset((Entity)entity, 1.0f).toVector3f()));
            bone.setLocalSpaceMatrix(this.localMatrix);
            bone.setWorldSpaceMatrix(RenderUtils.translateMatrix((Matrix4f)this.tempMatrix, (Vector3f)entity.position().toVector3f()));
        }
        RenderUtils.translateAwayFromPivotPoint((PoseStack)poseStack, (AzBone)bone);
        context.setVertexConsumer(this.getOrRefreshRenderBuffer(isReRender, context, bone));
        this.renderCubesOfBone(context, bone);
        if (!isReRender) {
            this.layerRenderer.applyRenderLayersForBone(context, bone);
        }
        this.renderChildBones(context, bone, isReRender);
        poseStack.popPose();
    }

    private void rotateMatrixAroundBone(PoseStack poseStack, TravelersBoneState boneState, AzBone bone) {
        float rx = bone.getRotX();
        float ry = bone.getRotY();
        float rz = bone.getRotZ();
        if (boneState != null) {
            rx += boneState.angleX;
            ry += boneState.angleY;
            rz += boneState.angleZ;
        }
        poseStack.mulPose(Axis.ZP.rotation(rz));
        poseStack.mulPose(Axis.YP.rotation(ry));
        poseStack.mulPose(Axis.XP.rotation(rx));
    }
}

