/*
 * Decompiled with CFR 0.152.
 */
package travelers.server.animal;

import com.google.common.base.Supplier;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.PathfinderMob;
import travelers.server.animal.TravelersAnimal;
import travelers.server.animal.entity.SmartAnimalBase;
import travelers.server.animal.obj.TravelersAnimalAttributes;
import travelers.util.helper.PlatformHelper;

public class TravelersAnimalRegistry {
    private static final HashMap<String, Set<TravelersAnimal<?>>> ANIMALS = new HashMap();

    public static <T extends SmartAnimalBase> TravelersAnimal<T> register(TravelersAnimal<T> animal) {
        String modId = animal.getAnimalAttributes().getModId().toLowerCase(Locale.ROOT);
        if (!ANIMALS.containsKey(modId)) {
            ANIMALS.put(modId, new HashSet());
        }
        HashSet set = (HashSet)ANIMALS.get(modId);
        TravelersAnimalAttributes<T> attributes = animal.getAnimalAttributes();
        Supplier entityTypeSupplier = PlatformHelper.register(BuiltInRegistries.ENTITY_TYPE, ResourceLocation.fromNamespaceAndPath((String)modId, (String)attributes.getAnimalName()), () -> animal.buildType().get());
        animal.setEntityType(entityTypeSupplier);
        set.add(animal);
        if (PlatformHelper.properties.getPlatformName().equalsIgnoreCase("fabric")) {
            PlatformHelper.properties.registerAnimal(animal);
        }
        return animal;
    }

    public static TravelersAnimal<?> getAnimalFromType(String modId, EntityType<? extends PathfinderMob> entityType) {
        Set<TravelersAnimal<?>> set = ANIMALS.get(modId);
        if (set == null) {
            return null;
        }
        for (TravelersAnimal<?> travelersAnimal : set) {
            if (travelersAnimal.getEntityType().get() != entityType) continue;
            return travelersAnimal;
        }
        return null;
    }

    public static HashMap<String, Set<TravelersAnimal<?>>> getANIMALS() {
        return ANIMALS;
    }
}

