/*
 * Decompiled with CFR 0.152.
 */
package travelers.server.animal.entity.pathingsystem.navigation;

import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import travelers.server.animal.entity.SmartAnimalBase;
import travelers.server.animal.entity.pathingsystem.TravelersPathFinder;
import travelers.server.animal.entity.pathingsystem.navigation.TravelersPathNavigation;
import travelers.server.animal.entity.pathingsystem.navigation.obj.TravelersGenericNav;
import travelers.server.animal.entity.pathingsystem.node.TravelersAmphibiousNodeEvaluator;

public class TravelersAmphibiousNavigation
extends TravelersPathNavigation {
    private final boolean shallow;
    private final SmartAnimalBase base;
    private int curNodeIndex = -1;
    private int nodeStuckTime = 0;

    public TravelersAmphibiousNavigation(SmartAnimalBase mob, Level level, boolean shallow) {
        super(mob, level);
        this.shallow = shallow;
        this.base = mob;
    }

    @Override
    protected void followThePath() {
        if (this.path == null) {
            return;
        }
        Vec3 temptPos = this.getTempMobPos();
        if (TravelersGenericNav.shouldTargetNextNodeInDirection(this.path, this.base)) {
            this.path.advance();
        }
        this.doStuckDetection(temptPos);
        if (this.isStuck()) {
            this.stop();
        }
    }

    @Override
    protected boolean canUpdatePath() {
        return true;
    }

    @Override
    protected Vec3 getTempMobPos() {
        return new Vec3(this.mob.getX(), this.mob.getY(0.5), this.mob.getZ());
    }

    @Override
    protected double getGroundY(Vec3 p_217794_) {
        return p_217794_.y;
    }

    @Override
    public boolean isStableDestination(BlockPos p_217799_) {
        return !this.level.getBlockState(p_217799_.below()).isAir();
    }

    @Override
    public void setCanFloat(boolean p_217801_) {
    }

    private void checkStuckOnNode() {
        if (this.path == null) {
            return;
        }
        int nodeIndex = this.path.getNextNodeIndex() - 1;
        if (nodeIndex > 0) {
            if (nodeIndex > this.path.getNodeCount()) {
                return;
            }
            if (this.curNodeIndex == nodeIndex) {
                ++this.nodeStuckTime;
                if (this.nodeStuckTime > 50) {
                    this.recomputePath();
                }
                return;
            }
            this.nodeStuckTime = 0;
            this.curNodeIndex = nodeIndex;
        }
    }

    @Override
    protected TravelersPathFinder createPathFinder() {
        this.nodeEvaluator = new TravelersAmphibiousNodeEvaluator(this.shallow);
        this.nodeEvaluator.setCanPassDoors(true);
        this.nodeEvaluator.setCanFloat(true);
        return new TravelersPathFinder(this.nodeEvaluator);
    }
}

