/*
 * Decompiled with CFR 0.152.
 */
package travelers.server.animal.entity.pathingsystem.navigation;

import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import travelers.TravelersMain;
import travelers.server.animal.entity.SmartAnimalBase;
import travelers.server.animal.entity.pathingsystem.TravelersPath;
import travelers.server.animal.entity.pathingsystem.TravelersPathFinder;
import travelers.server.animal.entity.pathingsystem.navigation.TravelersPathNavigation;
import travelers.server.animal.entity.pathingsystem.node.TravelersFlyNodeEvaluator;

public class TravelersFlyingNavigation
extends TravelersPathNavigation {
    private final SmartAnimalBase base;
    private int curNodeIndex = -1;
    private int nodeStuckTime = 0;

    public TravelersFlyingNavigation(SmartAnimalBase mob, Level level) {
        super(mob, level);
        this.base = mob;
    }

    @Override
    protected boolean canUpdatePath() {
        return this.canFloat() && this.mob.isInLiquid() || !this.mob.isPassenger();
    }

    @Override
    protected Vec3 getTempMobPos() {
        return this.mob.position();
    }

    @Override
    public void tick() {
        ++this.tick;
        if (this.hasDelayedRecomputation) {
            this.recomputePath();
        }
        if (this.isInProgress() && !this.isLookingForPath) {
            if (this.canUpdatePath()) {
                this.followThePath();
            } else if (this.path != null && !this.path.isDone()) {
                Vec3 vec3 = this.getTempMobPos();
                Vec3 vec31 = this.path.getNextEntityPos((Entity)this.mob);
                if (vec31.distanceToSqr(vec3) <= (double)this.maxDistanceToWaypoint) {
                    this.path.advance();
                }
            }
            if (TravelersMain.isDebugging()) {
                this.sendPathFinding(this.level, this.mob, this.path, this.maxDistanceToWaypoint);
            }
            if (this.isInProgress() && !this.isLookingForPath) {
                if (this.path == null) {
                    return;
                }
                Vec3 target = this.path.getNextEntityPos((Entity)this.mob);
                if (this.mob.position().closerThan((Position)target, (double)this.maxDistanceToWaypoint)) {
                    if (this.path.isDone()) {
                        this.stop();
                    }
                } else {
                    this.mob.getMoveController().setWantedPosition(target.x, target.y, target.z, 1.0);
                }
            }
        }
    }

    @Override
    protected void followThePath() {
        if (this.path == null) {
            return;
        }
        Vec3 temptPos = this.getTempMobPos();
        if (this.shouldTargetNextNodeInDirection(this.path, this.base, temptPos)) {
            this.path.advance();
        } else {
            this.checkStuckOnNode();
        }
        this.doStuckDetection(temptPos);
        if (this.isStuck()) {
            this.recomputePath();
        }
        if (this.path != null && this.path.isDone()) {
            this.stop();
        }
    }

    private void checkStuckOnNode() {
        if (this.path == null) {
            return;
        }
        int nodeIndex = this.path.getNextNodeIndex() - 1;
        if (nodeIndex < 0 || nodeIndex >= this.path.getNodeCount()) {
            return;
        }
        if (this.curNodeIndex == nodeIndex) {
            ++this.nodeStuckTime;
            if (this.nodeStuckTime > 50) {
                this.recomputePath();
            }
            return;
        }
        this.nodeStuckTime = 0;
        this.curNodeIndex = nodeIndex;
    }

    public boolean shouldTargetNextNodeInDirection(TravelersPath path, SmartAnimalBase mob, Vec3 vec) {
        if (path == null) {
            return false;
        }
        int nextNodeIndex = path.getNextNodeIndex();
        if (nextNodeIndex >= path.getNodeCount()) {
            return false;
        }
        Vec3 vec31 = Vec3.atCenterOf((Vec3i)path.getNodePos(nextNodeIndex));
        Vec3 pos = mob.position();
        return vec31.closerThan(pos, Math.min(0.5, (double)(mob.getBbWidth() * 2.0f)), (double)(mob.getBbHeight() * 2.0f));
    }

    @Override
    @NotNull
    protected TravelersPathFinder createPathFinder() {
        this.nodeEvaluator = new TravelersFlyNodeEvaluator();
        return new TravelersPathFinder(this.nodeEvaluator);
    }
}

