/*
 * Decompiled with CFR 0.152.
 */
package travelers.server.animal.entity.pathingsystem.vanilla;

import net.minecraft.core.BlockPos;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import travelers.server.animal.entity.SmartAnimalBase;
import travelers.server.animal.entity.pathingsystem.vanilla.TLGoalUtils;
import travelers.server.animal.entity.pathingsystem.vanilla.TLRandomPos;

public class TLDefaultRandomPos {
    @Nullable
    public static Vec3 getPos(SmartAnimalBase mob, int radius, int verticalDistance) {
        boolean restricted = TLGoalUtils.mobRestricted(mob, radius);
        return TLRandomPos.generateBestRandomPos(() -> {
            BlockPos offset = TLRandomPos.generateRandomDirection(radius, verticalDistance);
            return TLDefaultRandomPos.generateValidTarget(mob, radius, restricted, offset);
        }, arg_0 -> ((SmartAnimalBase)mob).getWalkTargetValue(arg_0));
    }

    @Nullable
    public static Vec3 getPosTowards(SmartAnimalBase mob, int radius, int yRange, Vec3 target, double angleVarianceRadians) {
        Vec3 direction = target.subtract(mob.getX(), mob.getY(), mob.getZ());
        boolean restricted = TLGoalUtils.mobRestricted(mob, radius);
        return TLRandomPos.generateBestRandomPos(() -> {
            BlockPos offset = TLRandomPos.generateRandomDirectionWithinRadians(radius, yRange, 0, direction.x, direction.z, angleVarianceRadians);
            return offset != null ? TLDefaultRandomPos.generateValidTarget(mob, radius, restricted, offset) : null;
        }, arg_0 -> ((SmartAnimalBase)mob).getWalkTargetValue(arg_0));
    }

    @Nullable
    public static Vec3 getPosAway(SmartAnimalBase mob, int radius, int yRange, Vec3 dangerSource) {
        Vec3 awayDir = mob.position().subtract(dangerSource).normalize();
        boolean restricted = TLGoalUtils.mobRestricted(mob, radius);
        return TLRandomPos.generateBestRandomPos(() -> {
            BlockPos offset = TLRandomPos.generateRandomDirectionWithinRadians(radius, yRange, 0, awayDir.x, awayDir.z, 1.5707963267948966);
            return offset != null ? TLDefaultRandomPos.generateValidTarget(mob, radius, restricted, offset) : null;
        }, arg_0 -> ((SmartAnimalBase)mob).getWalkTargetValue(arg_0));
    }

    @Nullable
    private static BlockPos generateValidTarget(SmartAnimalBase mob, int radius, boolean restricted, BlockPos offset) {
        BlockPos candidate = TLRandomPos.generateRandomPosTowardDirection(mob, radius, offset);
        return candidate != null && !TLGoalUtils.isOutsideLimits(candidate, mob) && !TLGoalUtils.isRestricted(restricted, mob, candidate) && !TLGoalUtils.isNotStable(mob.getNavigationController(), candidate) && !TLGoalUtils.hasMalus(mob, candidate) ? candidate : null;
    }
}

