/*
 * Decompiled with CFR 0.152.
 */
package travelers;

import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import org.slf4j.Logger;
import travelers.TravelersConstants;
import travelers.client.TravelersClient;
import travelers.util.helper.ClientPlatformHelper;

@EventBusSubscriber(modid="travelerslib", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public final class NeoTravelersEventsClient {
    private static final Logger LOGGER = TravelersConstants.LOGGER;

    @SubscribeEvent(priority=EventPriority.HIGHEST, receiveCanceled=true)
    public static void registerEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        TravelersClient.init();
        ClientPlatformHelper.entityRenderFactory.forEach((entityTypeSupplier, provider) -> {
            try {
                EntityType type = (EntityType)entityTypeSupplier.get();
                if (type == null) {
                    LOGGER.error("EntityType supplier returned null!");
                    return;
                }
                event.registerEntityRenderer(type, provider);
            }
            catch (Throwable t) {
                LOGGER.error("Failed to register entity renderer", t);
            }
        });
        ClientPlatformHelper.blockEntityFactory.forEach((blockEntityTypeSupplier, provider) -> {
            try {
                BlockEntityType type = (BlockEntityType)blockEntityTypeSupplier.get();
                if (type == null) {
                    LOGGER.error("BlockEntityType supplier returned null!");
                    return;
                }
                event.registerBlockEntityRenderer(type, provider);
            }
            catch (Throwable t) {
                LOGGER.error("Failed to register block-entity renderer", t);
            }
        });
    }
}

