/*
 * Decompiled with CFR 0.152.
 */
package travelers.server.animal.entity;

import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.level.Level;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;
import travelers.TravelersConstants;
import travelers.server.animal.ModelType;
import travelers.server.animal.TravelersAnimal;
import travelers.server.animal.entity.SmartAnimalBase;
import travelers.server.animal.obj.animation.TravelersAnimationControllers;
import travelers.server.animal.obj.animation.TravelersGeckoAnimationController;

public abstract class GeckoSmartAnimalBase
extends SmartAnimalBase
implements GeoEntity {
    private final AnimatableInstanceCache geoCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public GeckoSmartAnimalBase(EntityType<? extends PathfinderMob> entityType, Level level) {
        super(entityType, level);
        if (this.getAnimal().getModelType() != ModelType.GECKO) {
            TravelersConstants.LOGGER.error("You need to put the animals modelType to gecko");
        }
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        TravelersAnimal<?> animal = this.getAnimal();
        if (animal != null) {
            for (TravelersAnimationControllers.AnimationController controller : animal.getAnimalAttributes().getEntityBaseProperties().getControllers()) {
                controllers.add(new TravelersGeckoAnimationController<GeckoSmartAnimalBase>(this, controller));
            }
        }
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geoCache;
    }
}

