/*
 * Decompiled with CFR 0.152.
 */
package travelers.server.animal.entity.pathingsystem.navigation;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import travelers.server.animal.entity.SmartAnimalBase;
import travelers.server.animal.entity.pathingsystem.TravelersPath;
import travelers.server.animal.entity.pathingsystem.TravelersPathFinder;
import travelers.server.animal.entity.pathingsystem.navigation.TravelersPathNavigation;
import travelers.server.animal.entity.pathingsystem.node.TravelersSwimNodeEvaluator;

public class TravelersAquaticNavigation
extends TravelersPathNavigation {
    private final boolean allowBreaching;
    private final SmartAnimalBase base;

    public TravelersAquaticNavigation(SmartAnimalBase mob, Level level, boolean allowBreaching) {
        super(mob, level);
        this.base = mob;
        this.allowBreaching = allowBreaching;
    }

    @Override
    protected void followThePath() {
        if (this.path == null) {
            return;
        }
        Vec3 temptPos = this.getTempMobPos();
        if (this.shouldTargetNextNodeInDirection(this.path, this.base, temptPos)) {
            this.path.advance();
        }
        this.doStuckDetection(temptPos);
        if (this.isStuck()) {
            this.recomputePath();
        }
    }

    public boolean shouldTargetNextNodeInDirection(TravelersPath path, SmartAnimalBase mob, Vec3 vec) {
        if (path == null) {
            return false;
        }
        int nextNodeIndex = path.getNextNodeIndex();
        if (nextNodeIndex >= path.getNodeCount()) {
            return false;
        }
        Vec3 nodeCenter = Vec3.atCenterOf((Vec3i)path.getNodePos(nextNodeIndex));
        Vec3 pos = mob.position();
        return nodeCenter.closerThan(pos, Math.max(0.75, (double)(mob.getBbWidth() / 2.0f)), (double)Math.max(0.75f, mob.getBbHeight()));
    }

    @Override
    protected boolean canUpdatePath() {
        return this.allowBreaching || this.mob.isInLiquid();
    }

    @Override
    protected double getGroundY(Vec3 vec) {
        return vec.y;
    }

    @Override
    protected Vec3 getTempMobPos() {
        return new Vec3(this.mob.getX(), this.mob.getY(0.5), this.mob.getZ());
    }

    @Override
    public boolean isStableDestination(BlockPos pos) {
        return !this.level.getBlockState(pos).isSolidRender((BlockGetter)this.level, pos);
    }

    @Override
    public void setCanFloat(boolean canSwim) {
    }

    @Override
    @NotNull
    protected TravelersPathFinder createPathFinder() {
        this.nodeEvaluator = new TravelersSwimNodeEvaluator(this.allowBreaching);
        return new TravelersPathFinder(this.nodeEvaluator);
    }
}

