/*
 * Decompiled with CFR 0.152.
 */
package travelers.server.animal.entity.pathingsystem.node.obj;

import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import travelers.server.animal.entity.pathingsystem.node.obj.TravelersNode;

public class TravelersTarget
extends TravelersNode {
    private float bestHeuristic = Float.MAX_VALUE;
    private TravelersNode bestNode;
    private boolean reached;
    private BlockPos targetPos;

    public TravelersTarget(TravelersNode node) {
        super(node.x, node.y, node.z);
        this.targetPos = new BlockPos(node.x, node.y, node.z);
    }

    public TravelersTarget(int x, int y, int z) {
        super(x, y, z);
        this.targetPos = new BlockPos(x, y, z);
    }

    public static TravelersTarget createFromStream(FriendlyByteBuf buffer) {
        int x = buffer.readInt();
        int y = buffer.readInt();
        int z = buffer.readInt();
        TravelersTarget target = new TravelersTarget(x, y, z);
        TravelersTarget.readContents(buffer, target);
        return target;
    }

    public void updateBest(float heuristic, TravelersNode node) {
        if (heuristic < this.bestHeuristic) {
            this.bestHeuristic = heuristic;
            this.bestNode = node;
        }
    }

    public TravelersNode getBestNode() {
        return this.bestNode;
    }

    public boolean isReached() {
        return this.reached;
    }

    public void setReached(boolean reached) {
        this.reached = reached;
    }

    public BlockPos getTargetPos() {
        return this.targetPos;
    }

    public void setTargetPos(BlockPos targetPos) {
        this.targetPos = targetPos;
    }
}

