/*
 * Decompiled with CFR 0.152.
 */
package travelers.server.animal.obj.animation;

import software.bernie.geckolib.animation.Animation;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.RawAnimation;
import travelers.server.animal.entity.GeckoSmartAnimalBase;
import travelers.server.animal.obj.animation.PlayBehaviourType;
import travelers.server.animal.obj.animation.TravelersAnimationControllers;
import travelers.server.animal.obj.animation.TravelersGeckoAnimationController;

public class TravelersGeckoAnimation {
    private final TravelersAnimationControllers.AnimationController animationController;
    private final RawAnimation rawAnimation;
    private final int transitionLength;

    public TravelersGeckoAnimation(String name, TravelersAnimationControllers.AnimationController controller, PlayBehaviourType playbehaviourType) {
        Animation.LoopType loopType = switch (playbehaviourType) {
            case PlayBehaviourType.LOOP -> Animation.LoopType.LOOP;
            case PlayBehaviourType.HOLD -> Animation.LoopType.HOLD_ON_LAST_FRAME;
            default -> Animation.LoopType.PLAY_ONCE;
        };
        this.animationController = controller;
        this.rawAnimation = RawAnimation.begin().then(name, loopType);
        this.transitionLength = controller.transitionLength();
    }

    public TravelersGeckoAnimation(String name, TravelersAnimationControllers.AnimationController controller, PlayBehaviourType playbehaviourType, int transitionLength) {
        Animation.LoopType loopType = switch (playbehaviourType) {
            case PlayBehaviourType.LOOP -> Animation.LoopType.LOOP;
            case PlayBehaviourType.HOLD -> Animation.LoopType.HOLD_ON_LAST_FRAME;
            default -> Animation.LoopType.PLAY_ONCE;
        };
        this.animationController = controller;
        this.rawAnimation = RawAnimation.begin().then(name, loopType);
        this.transitionLength = transitionLength;
    }

    public void sendForEntity(GeckoSmartAnimalBase e) {
        AnimationController controller;
        if (e.level().isClientSide && (controller = (AnimationController)e.getAnimatableInstanceCache().getManagerForId((long)e.getId()).getAnimationControllers().get(this.animationController.name())) instanceof TravelersGeckoAnimationController) {
            TravelersGeckoAnimationController travelersGeckoAnimationController = (TravelersGeckoAnimationController)controller;
            travelersGeckoAnimationController.setAnimationSpeed(1.0);
            travelersGeckoAnimationController.transitionLength(this.transitionLength);
            travelersGeckoAnimationController.setAnimation(this.rawAnimation);
        }
    }

    public TravelersAnimationControllers.AnimationController getAnimationController() {
        return this.animationController;
    }

    public RawAnimation getRawAnimation() {
        return this.rawAnimation;
    }

    public int getTransitionLength() {
        return this.transitionLength;
    }
}

