/*
 * Decompiled with CFR 0.152.
 */
package travelers;

import com.google.common.base.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.fml.ModList;
import net.neoforged.fml.loading.LoadingModList;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import travelers.TravelersConstants;
import travelers.server.animal.TravelersAnimal;
import travelers.server.animal.entity.SmartAnimalBase;
import travelers.server.world.TravelersBiomeModificator;
import travelers.util.helper.obj.IGenericProperties;
import travelers.world.NeoTravelersBiomeModificator;

public class NeoGenericProperties
implements IGenericProperties {
    private static final NeoTravelersBiomeModificator biomeModificator = new NeoTravelersBiomeModificator();

    @Override
    public String getPlatformName() {
        return "neoforge";
    }

    @Override
    public MinecraftServer getServer() {
        return ServerLifecycleHooks.getCurrentServer();
    }

    @Override
    public void sendToPlayersTrackingEntity(Entity mob, CustomPacketPayload payload) {
        PacketDistributor.sendToPlayersTrackingEntity((Entity)mob, (CustomPacketPayload)payload, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Override
    public void sendToPlayersTrackingBlockEntity(BlockEntity mob, CustomPacketPayload payload) {
        PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)((ServerLevel)mob.getLevel()), (ChunkPos)mob.getLevel().getChunkAt(mob.getBlockPos()).getPos(), (CustomPacketPayload)payload, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Override
    public void sendToServer(CustomPacketPayload payload) {
        PacketDistributor.sendToServer((CustomPacketPayload)payload, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Override
    public void sendToPlayer(ServerPlayer player, CustomPacketPayload payload) {
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)payload, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Override
    public <T> void register(Registry<T> registry, ResourceLocation id, Supplier<T> supplier) {
        TravelersConstants.LOGGER.error("Don't use the register method for NeoForge");
    }

    @Override
    public <T extends SmartAnimalBase> void registerAnimal(TravelersAnimal<T> animal) {
        TravelersConstants.LOGGER.error("Don't use the register method for NeoForge");
    }

    @Override
    public boolean isModLoaded(String modId) {
        if (ModList.get() == null) {
            return LoadingModList.get().getMods().stream().anyMatch(modInfo -> modInfo.getModId().equalsIgnoreCase(modId));
        }
        return ModList.get().isLoaded(modId);
    }

    @Override
    public TravelersBiomeModificator getBiomeModificator() {
        return biomeModificator;
    }
}

