/*
 * Decompiled with CFR 0.152.
 */
package travelers.client;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.world.entity.Entity;
import travelers.client.render.animal.azure.TravelersAzure;
import travelers.client.render.animal.gecko.TravelersGecko;
import travelers.server.animal.ModelType;
import travelers.server.animal.TravelersAnimal;
import travelers.server.animal.TravelersAnimalRegistry;
import travelers.util.helper.ClientPlatformHelper;
import travelers.util.helper.PlatformHelper;

public class TravelersClient {
    private static final Map<UUID, Entity> uuidEntityMap = new HashMap<UUID, Entity>();
    public static int clientTicks;

    public static void init() {
        TravelersAnimalRegistry.getANIMALS().forEach((string, travelersAnimals) -> {
            for (TravelersAnimal travelersAnimal : travelersAnimals) {
                if (travelersAnimal.getModelType() == ModelType.AZURE) {
                    if (!PlatformHelper.properties.isModLoaded("azurelib")) continue;
                    ClientPlatformHelper.registerEntityRenders(travelersAnimal.getEntityType(), context -> TravelersAzure.register(context, travelersAnimal));
                    continue;
                }
                if (travelersAnimal.getModelType() != ModelType.GECKO || !PlatformHelper.properties.isModLoaded("geckolib")) continue;
                ClientPlatformHelper.registerEntityRenders(travelersAnimal.getEntityType(), context -> TravelersGecko.register(context, travelersAnimal));
            }
        });
    }

    public static Map<UUID, Entity> getUuidEntityMap() {
        return uuidEntityMap;
    }
}

