/*
 * Decompiled with CFR 0.152.
 */
package travelers.client.misc;

import java.util.HashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biome;
import travelers.client.misc.BiomeFogData;

public class FogHandler {
    private static final HashMap<ResourceKey<Biome>, BiomeFogData> biomeFogData = new HashMap();
    private static float fogFactor = 1.0f;
    private static float r = 1.0f;
    private static float g = 1.0f;
    private static float b = 1.0f;
    private static float dR = 1.0f;
    private static float dG = 1.0f;
    private static float dB = 1.0f;
    private static final float[] fogVelocity = new float[]{0.0f};
    private static final float[] rVel = new float[]{0.0f};
    private static final float[] gVel = new float[]{0.0f};
    private static final float[] bVel = new float[]{0.0f};

    public static boolean registerBiomeFog(ResourceKey<Biome> biome, BiomeFogData data) {
        if (biomeFogData.containsKey(biome)) {
            return false;
        }
        biomeFogData.put(biome, data);
        return true;
    }

    public static void lerpFog() {
        Minecraft mc = Minecraft.getInstance();
        ClientLevel world = mc.level;
        LocalPlayer player = mc.player;
        if (world == null || player == null) {
            return;
        }
        BlockPos pos = player.getOnPos();
        Holder biome = world.getBiome(pos);
        float targetFogFactor = 1.01f;
        biomeFogData.forEach((biomeResourceKey, biomeFogData1) -> biome.is(biomeResourceKey));
        float defaultRenderRange = 16.0f;
        float rd = ((Integer)Minecraft.getInstance().options.renderDistance().get()).intValue();
        float range = rd / defaultRenderRange;
        float targetR = dR;
        float targetG = dG;
        float targetB = dB;
        try {
            BiomeFogData data;
            ResourceKey biomeKey = biome.unwrapKey().orElse(null);
            if (biomeKey != null && (data = biomeFogData.get(biomeKey)) != null) {
                targetFogFactor = range >= 1.0f ? data.fogPercentage() / range : data.fogPercentage();
                targetR = data.R();
                targetG = data.G();
                targetB = data.B();
            }
        }
        catch (Exception biomeKey) {
            // empty catch block
        }
        float dt = 1.0f / (float)Math.max(1, Minecraft.getInstance().getFps());
        float smooth = 12.0f / (float)Math.max(1, Minecraft.getInstance().getFps());
        float smoothColor = 10.0f / (float)Math.max(1, Minecraft.getInstance().getFps());
        fogFactor = FogHandler.smoothDamp(fogFactor, targetFogFactor, fogVelocity, smooth, 999.0f, dt);
        r = FogHandler.smoothDamp(r, targetR, rVel, smoothColor, 999.0f, dt);
        g = FogHandler.smoothDamp(g, targetG, gVel, smoothColor, 999.0f, dt);
        b = FogHandler.smoothDamp(b, targetB, bVel, smoothColor, 999.0f, dt);
    }

    private static float smoothDamp(float current, float target, float[] velocity, float smoothTime, float maxSpeed, float deltaTime) {
        float output;
        smoothTime = Math.max(1.0E-4f, smoothTime);
        float omega = 2.0f / smoothTime;
        float x = omega * deltaTime;
        float exp = 1.0f / (1.0f + x + 0.48f * x * x + 0.235f * x * x * x);
        float change = current - target;
        float originalTo = target;
        float maxChange = maxSpeed * smoothTime;
        change = Math.max(-maxChange, Math.min(change, maxChange));
        target = current - change;
        float temp = (velocity[0] + omega * change) * deltaTime;
        velocity[0] = (velocity[0] - omega * temp) * exp;
        if (originalTo - current > 0.0f == (output = target + (change + temp) * exp) > originalTo) {
            output = originalTo;
            velocity[0] = 0.0f;
        }
        return output;
    }

    public static float getFogFactor() {
        return fogFactor;
    }

    public static float getR() {
        return r;
    }

    public static float getG() {
        return g;
    }

    public static float getB() {
        return b;
    }

    public static float getDR() {
        return dR;
    }

    public static float getDG() {
        return dG;
    }

    public static float getDB() {
        return dB;
    }

    public static void setDR(float dR) {
        FogHandler.dR = dR;
    }

    public static void setDG(float dG) {
        FogHandler.dG = dG;
    }

    public static void setDB(float dB) {
        FogHandler.dB = dB;
    }
}

