/*
 * Decompiled with CFR 0.152.
 */
package travelers.client.render.animal.azure;

import mod.azure.azurelib.common.render.entity.AzEntityRenderer;
import mod.azure.azurelib.common.render.entity.AzEntityRendererConfig;
import mod.azure.azurelib.common.render.entity.AzEntityRendererPipeline;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import travelers.client.render.animal.azure.TravelersAzureAnimalPipeline;
import travelers.client.render.animal.azure.TravelersAzureClientAnimal;
import travelers.client.render.animal.azure.obj.TravelersAzureClientAnimalRegistry;
import travelers.client.render.animation.azure.TravelersAzureAnimalAnimator;
import travelers.server.animal.TravelersAnimal;
import travelers.server.animal.entity.SmartAnimalBase;
import travelers.server.animal.obj.locator.ResourceLocator;

public class TravelersAzureAnimalRenderer
extends AzEntityRenderer<SmartAnimalBase> {
    public TravelersAzureAnimalRenderer(EntityRendererProvider.Context renderManager, TravelersAnimal<? extends SmartAnimalBase> animal) {
        super(TravelersAzureAnimalRenderer.getConfig(animal), renderManager);
    }

    private static AzEntityRendererConfig<SmartAnimalBase> getConfig(TravelersAnimal<? extends SmartAnimalBase> animal) {
        AzEntityRendererConfig.Builder config = AzEntityRendererConfig.builder(TravelersAzureAnimalRenderer::getModelResource, TravelersAzureAnimalRenderer::getTextureResource);
        config.setAnimatorProvider(() -> new TravelersAzureAnimalAnimator(animal));
        ResourceLocator<? extends SmartAnimalBase> locator = animal.getAnimalAttributes().getEntityBaseProperties().getLocator();
        if (animal.getAnimalAttributes().getEntityBaseProperties().isRequiresSpecialRenderer()) {
            config.setRenderType(t -> RenderType.entityTranslucent((ResourceLocation)locator.getTextureLocation((SmartAnimalBase)t)));
        } else {
            config.setRenderType(t -> RenderType.entityCutoutNoCull((ResourceLocation)locator.getTextureLocation((SmartAnimalBase)t)));
        }
        TravelersAzureClientAnimal<?> clientAnimal = TravelersAzureClientAnimalRegistry.TRAVELERS_ANIMALS.get(animal);
        if (clientAnimal != null) {
            clientAnimal.applyConfigProperties((AzEntityRendererConfig.Builder<SmartAnimalBase>)config);
        }
        return config.build();
    }

    private static <T extends SmartAnimalBase> ResourceLocation getModelResource(T entity) {
        ResourceLocator<?> locator = entity.getAnimal().getAnimalAttributes().getEntityBaseProperties().getLocator();
        return locator.getModelLocation(entity);
    }

    private static <T extends SmartAnimalBase> ResourceLocation getTextureResource(T entity) {
        ResourceLocator<?> locator = entity.getAnimal().getAnimalAttributes().getEntityBaseProperties().getLocator();
        return locator.getTextureLocation(entity);
    }

    public AzEntityRendererPipeline<SmartAnimalBase> createPipeline(AzEntityRendererConfig<SmartAnimalBase> config) {
        return new TravelersAzureAnimalPipeline(config, this);
    }
}

