/*
 * Decompiled with CFR 0.152.
 */
package travelers.client.render.animal.gecko;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoEntityRenderer;
import software.bernie.geckolib.util.RenderUtil;
import travelers.client.render.animal.gecko.TravelersGeckoModel;
import travelers.client.render.animation.entity.TravelersAnimationMap;
import travelers.client.render.animation.entity.obj.TravelersBoneState;
import travelers.client.render.animation.entity.obj.TravelersClientAnimator;
import travelers.server.animal.TravelersAnimal;
import travelers.server.animal.entity.GeckoSmartAnimalBase;
import travelers.server.animal.entity.SmartAnimalBase;

public class TravelersGeckoRenderer
extends GeoEntityRenderer<GeckoSmartAnimalBase> {
    private TravelersClientAnimator animalAnimator = null;
    private boolean checkForAnimator = true;
    private boolean hasAnimator = false;

    public TravelersGeckoRenderer(EntityRendererProvider.Context context, TravelersAnimal<? extends SmartAnimalBase> travelersAnimal) {
        super(context, (GeoModel)new TravelersGeckoModel(travelersAnimal));
    }

    public void preRender(PoseStack poseStack, GeckoSmartAnimalBase animatable, BakedGeoModel model, @Nullable MultiBufferSource bufferSource, @Nullable VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, int colour) {
        super.preRender(poseStack, (Entity)animatable, model, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, colour);
        if (this.checkForAnimator) {
            this.getAnimalAnimator(animatable);
        }
        if (this.hasAnimator && !isReRender) {
            TravelersClientAnimator animator = this.getAnimalAnimator(animatable);
            animator.update(animatable, partialTick);
        }
    }

    public void renderRecursively(PoseStack poseStack, GeckoSmartAnimalBase animatable, GeoBone bone, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, int colour) {
        poseStack.pushPose();
        TravelersBoneState boneState = null;
        if (this.hasAnimator) {
            boneState = this.animalAnimator.updateAnimationOnBone(animatable, bone.getName());
        }
        RenderUtil.translateMatrixToBone((PoseStack)poseStack, (GeoBone)bone);
        if (boneState != null) {
            poseStack.translate(boneState.offsetX / 16.0f, -boneState.offsetY / 16.0f, boneState.offsetZ / 16.0f);
        }
        RenderUtil.translateToPivotPoint((PoseStack)poseStack, (GeoBone)bone);
        this.rotateMatrixAroundBone(poseStack, boneState, bone);
        RenderUtil.scaleMatrixForBone((PoseStack)poseStack, (GeoBone)bone);
        if (bone.isTrackingMatrices()) {
            Matrix4f poseState = new Matrix4f((Matrix4fc)poseStack.last().pose());
            Matrix4f localMatrix = RenderUtil.invertAndMultiplyMatrices((Matrix4f)poseState, (Matrix4f)this.entityRenderTranslations);
            bone.setModelSpaceMatrix(RenderUtil.invertAndMultiplyMatrices((Matrix4f)poseState, (Matrix4f)this.modelRenderTranslations));
            bone.setLocalSpaceMatrix(RenderUtil.translateMatrix((Matrix4f)localMatrix, (Vector3f)this.getRenderOffset((Entity)((GeckoSmartAnimalBase)this.animatable), 1.0f).toVector3f()));
            bone.setWorldSpaceMatrix(RenderUtil.translateMatrix((Matrix4f)new Matrix4f((Matrix4fc)localMatrix), (Vector3f)((GeckoSmartAnimalBase)this.animatable).position().toVector3f()));
        }
        RenderUtil.translateAwayFromPivotPoint((PoseStack)poseStack, (GeoBone)bone);
        buffer = this.checkAndRefreshBuffer(isReRender, buffer, bufferSource, renderType);
        this.renderCubesOfBone(poseStack, bone, buffer, packedLight, packedOverlay, colour);
        if (!isReRender) {
            this.applyRenderLayersForBone(poseStack, (GeoAnimatable)animatable, bone, renderType, bufferSource, buffer, partialTick, packedLight, packedOverlay);
        }
        this.renderChildBones(poseStack, (GeoAnimatable)animatable, bone, renderType, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, colour);
        poseStack.popPose();
    }

    private void rotateMatrixAroundBone(PoseStack poseStack, TravelersBoneState boneState, GeoBone bone) {
        if (boneState == null) {
            poseStack.mulPose(Axis.ZP.rotation(bone.getRotZ()));
            poseStack.mulPose(Axis.YP.rotation(bone.getRotY()));
            poseStack.mulPose(Axis.XP.rotation(bone.getRotX()));
            return;
        }
        poseStack.mulPose(Axis.ZP.rotation(bone.getRotZ() + boneState.angleZ));
        poseStack.mulPose(Axis.YP.rotation(bone.getRotY() + boneState.angleY));
        poseStack.mulPose(Axis.XP.rotation(bone.getRotX() + boneState.angleX));
    }

    public TravelersClientAnimator getAnimalAnimator(SmartAnimalBase base) {
        if (this.animalAnimator == null && this.checkForAnimator) {
            this.animalAnimator = TravelersAnimationMap.get(base);
            this.hasAnimator = this.animalAnimator != null;
            this.checkForAnimator = false;
        }
        return this.animalAnimator;
    }
}

