/*
 * Decompiled with CFR 0.152.
 */
package travelers.server.animal.entity.pathingsystem;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import travelers.TravelersConstants;
import travelers.TravelersMain;
import travelers.server.animal.entity.pathingsystem.node.obj.TravelersNode;
import travelers.server.animal.entity.pathingsystem.node.obj.TravelersTarget;

public class TravelersPath {
    private final List<TravelersNode> nodes;
    private final BlockPos target;
    private final float distToTarget;
    private final boolean reached;
    @Nullable
    private DebugData debugData;
    private int nextNodeIndex;

    public TravelersPath(List<TravelersNode> nodes, BlockPos target, boolean reached) {
        this.nodes = nodes;
        this.target = target;
        this.distToTarget = nodes.isEmpty() ? Float.MAX_VALUE : this.nodes.getLast().distanceManhattan(this.target);
        this.reached = reached;
        this.setDebug(new TravelersNode[0], new TravelersNode[0], Set.of(new TravelersTarget(target.getX(), target.getY(), target.getZ())));
        this.nextNodeIndex = 0;
    }

    public static TravelersPath createFromStream(FriendlyByteBuf buf) {
        boolean reached = buf.readBoolean();
        int idx = buf.readInt();
        BlockPos target = buf.readBlockPos();
        List list = buf.readList(TravelersNode::createFromStream);
        DebugData debug = DebugData.read(buf);
        TravelersPath path = new TravelersPath(list, target, reached);
        path.debugData = debug;
        path.nextNodeIndex = idx;
        return path;
    }

    public static void writeNodeArray(FriendlyByteBuf buffer, TravelersNode[] array) {
        buffer.writeInt(array.length);
        for (TravelersNode node : array) {
            node.writeToStream(buffer);
        }
    }

    public static TravelersNode[] readNodeArray(FriendlyByteBuf buffer) {
        int length = buffer.readInt();
        TravelersNode[] array = new TravelersNode[length];
        for (int i = 0; i < length; ++i) {
            array[i] = TravelersNode.createFromStream(buffer);
        }
        return array;
    }

    public void advance() {
        if (this.nextNodeIndex < this.nodes.size()) {
            ++this.nextNodeIndex;
        }
    }

    public boolean notStarted() {
        return this.nextNodeIndex <= 0;
    }

    public boolean isDone() {
        return this.nextNodeIndex >= this.nodes.size();
    }

    @Nullable
    public TravelersNode getEndNode() {
        return this.nodes.isEmpty() ? null : this.nodes.getLast();
    }

    public TravelersNode getNode(int index) {
        return this.nodes.get(index);
    }

    public void replaceNode(int index, TravelersNode point) {
        this.nodes.set(index, point);
    }

    public int getNodeCount() {
        return this.nodes.size();
    }

    public Vec3 getEntityPosAtNode(Entity entity, int index) {
        if (index < 0 || index >= this.nodes.size()) {
            if (TravelersMain.isDebugging()) {
                TravelersConstants.LOGGER.warn("getEntityPosAtNode - Index out of bounds! Size:{} Index:{}", (Object)(this.nodes.size() - 1), (Object)index);
            }
            return Vec3.ZERO;
        }
        TravelersNode node = this.nodes.get(index);
        return node.asBlockPos().getBottomCenter();
    }

    public BlockPos getNodePos(int index) {
        if (index < 0 || index >= this.nodes.size()) {
            if (TravelersMain.isDebugging()) {
                TravelersConstants.LOGGER.warn("getNodePos - Index out of bounds! Size:{} Index:{}", (Object)(this.nodes.size() - 1), (Object)index);
            }
            return BlockPos.ZERO;
        }
        return this.nodes.get(index).asBlockPos();
    }

    public Vec3 getNextEntityPos(Entity entity) {
        if (this.isDone()) {
            return this.nodes.isEmpty() ? Vec3.ZERO : this.nodes.getLast().asBlockPos().getBottomCenter();
        }
        return this.getEntityPosAtNode(entity, this.nextNodeIndex);
    }

    public BlockPos getNextNodePos() {
        if (this.isDone()) {
            return this.nodes.isEmpty() ? BlockPos.ZERO : this.nodes.getLast().asBlockPos();
        }
        return this.nodes.get(this.nextNodeIndex).asBlockPos();
    }

    public TravelersNode getNextNode() {
        if (this.isDone()) {
            return this.nodes.isEmpty() ? null : this.nodes.getLast();
        }
        return this.nodes.get(this.nextNodeIndex);
    }

    @Nullable
    public TravelersNode getPreviousNode() {
        return this.nextNodeIndex > 0 ? this.nodes.get(this.nextNodeIndex - 1) : null;
    }

    public boolean sameAs(@Nullable TravelersPath other) {
        if (other == null || other.nodes.size() != this.nodes.size()) {
            return false;
        }
        int size = this.nodes.size();
        for (int i = 0; i < size; ++i) {
            TravelersNode a = this.nodes.get(i);
            TravelersNode b = other.nodes.get(i);
            if (a.x == b.x && a.y == b.y && a.z == b.z) continue;
            return false;
        }
        return true;
    }

    public boolean canReach() {
        return this.reached;
    }

    @VisibleForDebug
    void setDebug(TravelersNode[] openSet, TravelersNode[] closedSet, Set<TravelersTarget> targetNodes) {
        this.debugData = new DebugData(openSet, closedSet, targetNodes);
    }

    @Nullable
    public DebugData debugData() {
        return this.debugData;
    }

    public void writeToStream(FriendlyByteBuf buffer) {
        if (this.debugData == null || this.debugData.targetNodes.isEmpty()) {
            return;
        }
        buffer.writeBoolean(this.reached);
        buffer.writeInt(this.nextNodeIndex);
        buffer.writeBlockPos(this.target);
        buffer.writeCollection(this.nodes, (buf, node) -> node.writeToStream((FriendlyByteBuf)buf));
        this.debugData.write(buffer);
    }

    public String toString() {
        return "TravelersPath[length=" + this.nodes.size() + ", index=" + this.nextNodeIndex + "]";
    }

    public TravelersPath copy() {
        ArrayList<TravelersNode> copiedNodes = new ArrayList<TravelersNode>(this.nodes);
        TravelersPath path = new TravelersPath(copiedNodes, this.target, this.reached);
        path.debugData = this.debugData;
        path.nextNodeIndex = this.nextNodeIndex;
        return path;
    }

    public List<TravelersNode> getNodes() {
        return this.nodes;
    }

    public BlockPos getTarget() {
        return this.target;
    }

    public float getDistToTarget() {
        return this.distToTarget;
    }

    public boolean isReached() {
        return this.reached;
    }

    @Nullable
    public DebugData getDebugData() {
        return this.debugData;
    }

    public int getNextNodeIndex() {
        return this.nextNodeIndex;
    }

    public void setDebugData(@Nullable DebugData debugData) {
        this.debugData = debugData;
    }

    public void setNextNodeIndex(int nextNodeIndex) {
        this.nextNodeIndex = nextNodeIndex;
    }

    public record DebugData(TravelersNode[] openSet, TravelersNode[] closedSet, Set<TravelersTarget> targetNodes) {
        public static DebugData read(FriendlyByteBuf buffer) {
            HashSet targets = (HashSet)buffer.readCollection(HashSet::new, TravelersTarget::createFromStream);
            TravelersNode[] open = TravelersPath.readNodeArray(buffer);
            TravelersNode[] closed = TravelersPath.readNodeArray(buffer);
            return new DebugData(open, closed, targets);
        }

        public void write(FriendlyByteBuf buffer) {
            buffer.writeCollection(this.targetNodes, (buf, target) -> target.writeToStream((FriendlyByteBuf)buf));
            TravelersPath.writeNodeArray(buffer, this.openSet);
            TravelersPath.writeNodeArray(buffer, this.closedSet);
        }
    }
}

