/*
 * Decompiled with CFR 0.152.
 */
package travelers.server.animal.entity.pathingsystem.control;

import net.minecraft.util.Mth;
import travelers.server.animal.TravelersAnimal;
import travelers.server.animal.entity.SmartAnimalBase;
import travelers.server.animal.entity.pathingsystem.control.TravelersMoveControl;

public class TravelersFlyingMoveControl
extends TravelersMoveControl {
    private final float maxTurn;
    private final boolean hoversInPlace;

    public TravelersFlyingMoveControl(SmartAnimalBase mob, TravelersAnimal<?> animal, boolean hoversInPlace) {
        super(mob, animal);
        this.hoversInPlace = hoversInPlace;
        this.maxTurn = (float)animal.getAnimalAttributes().getEntityBaseProperties().getMaxTurnRate();
    }

    @Override
    public void tick() {
        if (!this.mob.canMove()) {
            return;
        }
        if (this.operation == TravelersMoveControl.Operation.MOVE_TO && this.mob.getNavigationController().isInProgress()) {
            double deltaZ;
            double deltaY;
            double deltaX = this.wantedX - this.mob.getX();
            double totalDeltaSqr = deltaX * deltaX + (deltaY = this.wantedY - this.mob.getY()) * deltaY + (deltaZ = this.wantedZ - this.mob.getZ()) * deltaZ;
            if (totalDeltaSqr < 2.5E-7) {
                this.mob.setZza(0.0f);
            } else {
                double horizDist = Math.sqrt(deltaX * deltaX + deltaZ * deltaZ);
                float moveSpeed = this.mob.getSpeed();
                if (Math.abs(deltaY) > horizDist * 1.5) {
                    this.mob.setSpeed(0.0f);
                    this.mob.setZza(0.0f);
                    this.mob.setXxa(0.0f);
                    this.mob.setYya(deltaY > 0.0 ? moveSpeed : -moveSpeed);
                    return;
                }
                if (Math.abs(deltaY) < horizDist * 1.5) {
                    float targetYaw = (float)(Mth.atan2((double)deltaZ, (double)deltaX) * 180.0 / Math.PI) - 90.0f;
                    float smoothedYaw = this.rotlerp(this.mob.getYRot(), targetYaw, this.maxTurn);
                    this.mob.setYRot(smoothedYaw);
                    this.mob.yBodyRot = smoothedYaw;
                    this.mob.yHeadRot = smoothedYaw;
                }
                if (Math.abs(deltaY) > (double)1.0E-5f || Math.abs(horizDist) > (double)1.0E-5f) {
                    float targetPitch = -((float)(Mth.atan2((double)deltaY, (double)horizDist) * 180.0 / Math.PI));
                    targetPitch = Mth.clamp((float)Mth.wrapDegrees((float)targetPitch), (float)(-this.maxTurn), (float)this.maxTurn);
                    float smoothedPitch = this.rotlerp(this.mob.getXRot(), targetPitch, this.maxTurn);
                    this.mob.setXRot(smoothedPitch);
                }
                this.mob.setSpeed(moveSpeed);
                this.mob.setYya(deltaY > 0.0 ? moveSpeed * 0.6f : -moveSpeed * 0.6f);
            }
        } else {
            this.mob.setSpeed(0.0f);
            if (this.hoversInPlace) {
                this.mob.setYya(0.0f);
                this.mob.setZza(0.0f);
                this.mob.setXxa(0.0f);
            } else {
                this.mob.setYya(Mth.lerp((float)0.1f, (float)this.mob.yya, (float)0.0f));
                this.mob.setZza(Mth.lerp((float)0.1f, (float)this.mob.zza, (float)0.0f));
                this.mob.setXxa(Mth.lerp((float)0.1f, (float)this.mob.xxa, (float)0.0f));
            }
        }
    }
}

