/*
 * Decompiled with CFR 0.152.
 */
package travelers.server.animal.entity.pathingsystem.control;

import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.control.Control;
import travelers.server.animal.TravelersAnimal;
import travelers.server.animal.entity.SmartAnimalBase;

public class TravelersMoveControl
implements Control {
    protected final float maxTurn;
    protected final float turnSmoothRate;
    protected final SmartAnimalBase mob;
    protected double wantedX;
    protected double wantedY;
    protected double wantedZ;
    protected double speedModifier;
    protected Operation operation = Operation.WAIT;

    public TravelersMoveControl(SmartAnimalBase pMob, TravelersAnimal<?> animal) {
        this.mob = pMob;
        this.maxTurn = (float)animal.getAnimalAttributes().getEntityBaseProperties().getMaxTurnRate();
        this.turnSmoothRate = (float)animal.getAnimalAttributes().getEntityBaseProperties().getTurnSmoothRate();
    }

    public void setWantedPosition(double x, double y, double z, double speed) {
        this.wantedX = x;
        this.wantedY = y;
        this.wantedZ = z;
        this.speedModifier = speed;
        if (this.operation != Operation.JUMPING) {
            this.operation = Operation.MOVE_TO;
        }
    }

    public void tick() {
        switch (this.operation.ordinal()) {
            case 1: {
                this.handleMoveTo();
                break;
            }
            case 2: {
                this.handleJumping();
                break;
            }
            default: {
                this.mob.setZza(0.0f);
            }
        }
    }

    protected void handleMoveTo() {
        double dz;
        double dy;
        double dx = this.wantedX - this.mob.getX();
        double distSq = dx * dx + (dy = this.wantedY - this.mob.getY()) * dy + (dz = this.wantedZ - this.mob.getZ()) * dz;
        if (distSq < 2.5E-7) {
            this.mob.setZza(0.0f);
            this.operation = Operation.WAIT;
            return;
        }
        float targetAngle = (float)(Mth.atan2((double)dz, (double)dx) * 180.0 / Math.PI) - 90.0f;
        this.mob.setYRot(this.rotlerp(this.mob.getYRot(), targetAngle, this.getTurnSpeed()));
        this.mob.setYBodyRot(this.mob.getYRot());
        this.mob.setSpeed((float)(this.speedModifier * (double)this.mob.getSpeed()));
        if (this.shouldJump(dy, dx, dz)) {
            this.mob.getJumpControl().jump();
            this.operation = Operation.JUMPING;
        }
    }

    protected void handleJumping() {
        this.mob.setSpeed((float)(this.speedModifier * (double)this.mob.getSpeed()));
        if (this.mob.onGround()) {
            this.operation = Operation.WAIT;
        }
    }

    protected boolean shouldJump(double dy, double dx, double dz) {
        double dist = this.mob.distanceToSqr(this.mob.getX() + dx, this.mob.getY(), this.mob.getZ() + dz);
        if (dist < (double)(this.mob.getBbWidth() * 1.1f)) {
            boolean collides;
            boolean bl = collides = !this.mob.level().noBlockCollision((Entity)this.mob, this.mob.getBoundingBox().expandTowards(0.0, dy, 0.0));
            if (collides) {
                return false;
            }
            return dy > (double)this.mob.maxUpStep() && dy <= this.mob.jumpHeight();
        }
        return false;
    }

    protected float rotlerp(float from, float to, float maxTurn) {
        float delta = Mth.wrapDegrees((float)(to - from));
        float limited = Mth.clamp((float)delta, (float)(-maxTurn), (float)maxTurn);
        return from + limited;
    }

    protected float getTurnSpeed() {
        float v = this.maxTurn;
        float mult = this.mob.getTurnMultiplier();
        if (mult > 0.0f && mult != 1.0f) {
            v *= mult;
        }
        return v;
    }

    public void setOperation(Operation operation) {
        this.operation = operation;
    }

    public static enum Operation {
        WAIT,
        MOVE_TO,
        JUMPING;

    }
}

