/*
 * Decompiled with CFR 0.152.
 */
package travelers.server.animal.entity.pathingsystem.navigation;

import com.google.common.collect.ImmutableSet;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.PathNavigationRegion;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import travelers.TravelersDebug;
import travelers.TravelersMain;
import travelers.server.animal.entity.SmartAnimalBase;
import travelers.server.animal.entity.pathingsystem.TravelersPath;
import travelers.server.animal.entity.pathingsystem.TravelersPathFinder;
import travelers.server.animal.entity.pathingsystem.control.TravelersMoveControl;
import travelers.server.animal.entity.pathingsystem.node.TravelersNodeEvaluator;
import travelers.server.animal.entity.pathingsystem.node.TravelersWalkNodeEvaluator;
import travelers.server.animal.entity.pathingsystem.node.obj.TravelersNode;
import travelers.server.packet.obj.TravelersPathFindingDebug;
import travelers.util.helper.TravelersPacketDistributor;

public abstract class TravelersPathNavigation {
    protected final SmartAnimalBase mob;
    protected final Level level;
    private final TravelersPathFinder pathFinder;
    @Nullable
    protected TravelersPath path;
    protected boolean isLookingForPath;
    protected boolean isFrozen;
    protected int tick;
    protected int lastStuckCheck;
    protected Vec3 lastStuckCheckPos = Vec3.ZERO;
    protected Vec3i timeoutCachedNode = Vec3i.ZERO;
    protected long timeoutTimer;
    protected long lastTimeoutCheck;
    protected double timeoutLimit;
    protected float maxDistanceToWaypoint = 1.0f;
    protected boolean hasDelayedRecomputation;
    protected long timeLastRecompute;
    protected TravelersNodeEvaluator nodeEvaluator;
    private final double reachRange;
    private float maxVisitedNodesMultiplier = 1.0f;
    private boolean isStuck;
    private long pathRequestId = 0L;
    private static final ExecutorService PATH_EXECUTOR = new ThreadPoolExecutor(2, Math.max(2, Runtime.getRuntime().availableProcessors() / 2), 30L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(128), new ThreadPoolExecutor.DiscardOldestPolicy());

    public TravelersPathNavigation(SmartAnimalBase mob, Level level) {
        this.mob = mob;
        this.level = level;
        this.reachRange = mob.getAnimal().getAnimalAttributes().getEntityAttributeProperties().getFollowRange();
        this.pathFinder = this.createPathFinder();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFrozen(boolean frozen) {
        TravelersPathNavigation travelersPathNavigation = this;
        synchronized (travelersPathNavigation) {
            this.isFrozen = frozen;
        }
    }

    protected abstract TravelersPathFinder createPathFinder();

    public void recomputePath() {
        this.recomputePath(false);
    }

    public void recomputePath(boolean force) {
        long now = this.level.getGameTime();
        if (now - this.timeLastRecompute <= 20L && !force) {
            this.hasDelayedRecomputation = true;
            return;
        }
        TravelersPath current = this.path;
        if (current == null || current.getTarget() == null) {
            return;
        }
        Vec3 mobPos = this.getTempMobPos();
        Vec3 targetPos = Vec3.atCenterOf((Vec3i)current.getTarget());
        if (!force && mobPos.distanceToSqr(targetPos) < 9.0) {
            return;
        }
        CompletableFuture<TravelersPath> newPath = this.createPath(current.getTarget(), this.reachRange);
        if (newPath != null) {
            newPath.thenAcceptAsync(p -> {
                if (p != null) {
                    this.moveTo((TravelersPath)p);
                }
            }, this::runOnMainThread);
            this.timeLastRecompute = now;
            this.hasDelayedRecomputation = false;
        } else {
            this.hasDelayedRecomputation = true;
        }
    }

    private void runOnMainThread(Runnable r) {
        if (this.level.isClientSide) {
            r.run();
        } else if (this.level.getServer() != null) {
            this.level.getServer().execute(r);
        }
    }

    @Nullable
    public CompletableFuture<TravelersPath> createPath(double x, double y, double z, int accuracy) {
        return this.createPath((Set<BlockPos>)ImmutableSet.of((Object)BlockPos.containing((double)x, (double)y, (double)z)), 8, false, (double)accuracy);
    }

    @Nullable
    public CompletableFuture<TravelersPath> createPath(Stream<BlockPos> targets, int accuracy) {
        return this.createPath(targets.collect(Collectors.toSet()), 8, false, (double)accuracy);
    }

    @Nullable
    public CompletableFuture<TravelersPath> createPath(Set<BlockPos> positions, int distance) {
        return this.createPath(positions, 8, false, (double)distance);
    }

    @Nullable
    public CompletableFuture<TravelersPath> createPath(BlockPos pos, double accuracy) {
        return this.createPath((Set<BlockPos>)ImmutableSet.of((Object)pos), 8, false, accuracy);
    }

    @Nullable
    public CompletableFuture<TravelersPath> createPath(BlockPos pos, int regionOffset, int accuracy) {
        return this.createPath((Set<BlockPos>)ImmutableSet.of((Object)pos), regionOffset, false, (double)accuracy);
    }

    @Nullable
    public CompletableFuture<TravelersPath> createPath(Entity entity, int accuracy) {
        return this.createPath((Set<BlockPos>)ImmutableSet.of((Object)entity.blockPosition()), 16, true, (double)accuracy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    protected CompletableFuture<TravelersPath> createPath(Set<BlockPos> targets, int regionOffset, boolean offsetUpward, double accuracy) {
        long requestId;
        TravelersPathNavigation travelersPathNavigation = this;
        synchronized (travelersPathNavigation) {
            if (this.isLookingForPath || this.isFrozen || targets.isEmpty() || this.mob.getY() < (double)this.level.getMinBuildHeight() || !this.canUpdatePath()) {
                return null;
            }
            this.isLookingForPath = true;
            requestId = ++this.pathRequestId;
        }
        float followRange = (float)this.reachRange;
        BlockPos blockpos = offsetUpward ? this.mob.blockPosition().above() : this.mob.blockPosition();
        int i = (int)(followRange + (float)regionOffset);
        PathNavigationRegion region = new PathNavigationRegion(this.level, blockpos.offset(-i, -i, -i), blockpos.offset(i, i, i));
        long id = requestId;
        return CompletableFuture.supplyAsync(() -> this.pathFinder.findPath(region, this.mob, targets, followRange, (int)accuracy, this.maxVisitedNodesMultiplier), PATH_EXECUTOR).thenApplyAsync(pathResult -> {
            TravelersPathNavigation travelersPathNavigation = this;
            synchronized (travelersPathNavigation) {
                this.isLookingForPath = false;
                if (id != this.pathRequestId) {
                    return null;
                }
            }
            return pathResult;
        }, this::runOnMainThread);
    }

    public CompletableFuture<TravelersPath> moveTo(double x, double y, double z) {
        CompletableFuture<TravelersPath> f = this.createPath(x, y, z, 1);
        if (f != null) {
            f.thenAcceptAsync(p -> {
                if (p != null) {
                    this.moveTo((TravelersPath)p);
                }
            }, this::runOnMainThread);
        }
        return f;
    }

    public CompletableFuture<TravelersPath> moveTo(double x, double y, double z, int accuracy) {
        CompletableFuture<TravelersPath> f = this.createPath(x, y, z, accuracy);
        if (f != null) {
            f.thenAcceptAsync(p -> {
                if (p != null) {
                    this.moveTo((TravelersPath)p);
                }
            }, this::runOnMainThread);
        }
        return f;
    }

    public CompletableFuture<TravelersPath> moveTo(Entity entity) {
        CompletableFuture<TravelersPath> f = this.createPath(entity, 1);
        if (f != null) {
            f.thenAcceptAsync(p -> {
                if (p != null) {
                    this.moveTo((TravelersPath)p);
                }
            }, this::runOnMainThread);
        }
        return f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveTo(@Nullable TravelersPath newPath) {
        TravelersPathNavigation travelersPathNavigation = this;
        synchronized (travelersPathNavigation) {
            if (newPath == null) {
                this.path = null;
                return;
            }
            if (!newPath.sameAs(this.path)) {
                this.path = newPath;
            }
            if (this.isInProgress() && this.path != null && this.path.getNodeCount() > 0) {
                Vec3 pos = this.getTempMobPos();
                this.lastStuckCheck = this.tick;
                this.lastStuckCheckPos = pos;
            }
        }
    }

    protected void trimPath() {
        if (this.path == null) {
            return;
        }
        for (int i = 0; i < this.path.getNodeCount(); ++i) {
            TravelersNode n = this.path.getNode(i);
            TravelersNode next = i + 1 < this.path.getNodeCount() ? this.path.getNode(i + 1) : null;
            BlockState state = this.level.getBlockState(new BlockPos(n.x, n.y, n.z));
            if (!state.is(BlockTags.CAULDRONS)) continue;
            this.path.replaceNode(i, n.cloneAndMove(n.x, n.y + 1, n.z));
            if (next == null || n.y < next.y) continue;
            this.path.replaceNode(i + 1, n.cloneAndMove(next.x, n.y + 1, next.z));
        }
    }

    @Nullable
    public TravelersPath getPath() {
        return this.path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tick() {
        TravelersPathNavigation travelersPathNavigation = this;
        synchronized (travelersPathNavigation) {
            ++this.tick;
            if (this.isLookingForPath) {
                return;
            }
            if (this.hasDelayedRecomputation && this.tick % 20 == 0) {
                this.recomputePath();
            }
            if (!this.isInProgress()) {
                return;
            }
            if (this.canUpdatePath()) {
                this.followThePath();
            } else if (this.path != null && !this.path.isDone()) {
                Vec3 mobPos = this.getTempMobPos();
                Vec3 next = this.path.getNextEntityPos((Entity)this.mob);
                if (next.distanceToSqr(mobPos) <= (double)this.maxDistanceToWaypoint) {
                    this.path.advance();
                }
            }
            if (this.isInProgress() && this.path != null) {
                Vec3 next = this.path.getNextEntityPos((Entity)this.mob);
                this.mob.getMoveController().setWantedPosition(next.x, this.getGroundY(next), next.z, 1.0);
            }
            if (this.tick % 40 == 0) {
                this.doStuckDetection(this.getTempMobPos());
            }
            if (TravelersMain.isDebugging()) {
                this.sendPathFinding(this.level, this.mob, this.path, this.maxDistanceToWaypoint);
            }
        }
    }

    void sendPathFinding(Level level, SmartAnimalBase mob, TravelersPath path, float maxDistanceToWaypoint) {
        if (!TravelersMain.isDebugging() || path == null || level.isClientSide) {
            return;
        }
        if (TravelersDebug.ENABLED_DEBUGS.contains(mob.getAnimal().getAnimalAttributes().getModId().toLowerCase(Locale.ROOT))) {
            TravelersPacketDistributor.sendToPlayersTrackingEntity(mob, new TravelersPathFindingDebug(mob.getId(), path, maxDistanceToWaypoint));
        }
    }

    protected double getGroundY(Vec3 vec) {
        BlockPos p = BlockPos.containing((Position)vec);
        return this.level.getBlockState(p.below()).isAir() ? vec.y : TravelersWalkNodeEvaluator.getFloorLevel((BlockGetter)this.level, p);
    }

    protected void followThePath() {
        throw new UnsupportedOperationException("Override required");
    }

    protected void doStuckDetection(Vec3 pos) {
        if (this.tick - this.lastStuckCheck > 100) {
            float s = this.mob.getSpeed();
            float f = s >= 1.0f ? s : s * s;
            float f1 = f * 25.0f;
            this.isStuck = pos.distanceToSqr(this.lastStuckCheckPos) < (double)(f1 * f1);
            this.lastStuckCheck = this.tick;
            this.lastStuckCheckPos = pos;
        }
        if (this.path == null || this.path.isDone()) {
            return;
        }
        BlockPos nodePos = this.path.getNextNodePos();
        long t = this.level.getGameTime();
        if (nodePos.equals((Object)this.timeoutCachedNode)) {
            this.timeoutTimer += t - this.lastTimeoutCheck;
        } else {
            this.timeoutCachedNode = nodePos;
            double d0 = pos.distanceTo(Vec3.atBottomCenterOf((Vec3i)nodePos));
            double d = this.timeoutLimit = this.mob.getSpeed() > 0.0f ? d0 / (double)this.mob.getSpeed() * 20.0 : 0.0;
        }
        if (this.timeoutLimit > 0.0 && (double)this.timeoutTimer > this.timeoutLimit * 3.0) {
            this.timeoutPath();
        }
        this.lastTimeoutCheck = t;
    }

    private void timeoutPath() {
        this.resetStuckTimeout();
        this.stop();
    }

    private void resetStuckTimeout() {
        this.timeoutCachedNode = Vec3i.ZERO;
        this.timeoutTimer = 0L;
        this.timeoutLimit = 0.0;
        this.isStuck = false;
    }

    public boolean isDone() {
        return (this.path == null || this.path.isDone()) && !this.isLookingForPath && !this.isFrozen;
    }

    public boolean isInProgress() {
        return !this.isDone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        TravelersPathNavigation travelersPathNavigation = this;
        synchronized (travelersPathNavigation) {
            this.nodeEvaluator.done();
            this.path = null;
            this.mob.getMoveController().setOperation(TravelersMoveControl.Operation.WAIT);
            this.isLookingForPath = false;
        }
    }

    protected abstract Vec3 getTempMobPos();

    protected abstract boolean canUpdatePath();

    public boolean isStableDestination(BlockPos pos) {
        BlockPos b = pos.below();
        return this.level.getBlockState(b).isSolidRender((BlockGetter)this.level, b);
    }

    public void setCanFloat(boolean v) {
        this.nodeEvaluator.setCanFloat(v);
    }

    public boolean canFloat() {
        return this.nodeEvaluator.isCanFloat();
    }

    public CompletableFuture<Boolean> shouldRecomputePathAsync(BlockPos pos) {
        return CompletableFuture.supplyAsync(() -> this.shouldRecomputePath(pos), PATH_EXECUTOR);
    }

    public boolean shouldRecomputePath(BlockPos pos) {
        if (this.hasDelayedRecomputation) {
            return false;
        }
        if (this.path != null && !this.path.isDone() && this.path.getNodeCount() > 0) {
            AABB box = new AABB(pos);
            for (int i = this.path.getNextNodeIndex(); i < this.path.getNodeCount(); ++i) {
                AABB moved;
                TravelersNode n = this.path.getNode(i);
                if (n == null || !(moved = this.mob.getBoundingBox().move((double)(n.x - Mth.floor((double)this.mob.getX())), (double)(n.y - Mth.floor((double)this.mob.getY())), (double)(n.z - Mth.floor((double)this.mob.getZ())))).intersects(box)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isLookingForPath() {
        return this.isLookingForPath;
    }

    public boolean isFrozen() {
        return this.isFrozen;
    }

    public TravelersNodeEvaluator getNodeEvaluator() {
        return this.nodeEvaluator;
    }

    public void setMaxVisitedNodesMultiplier(float maxVisitedNodesMultiplier) {
        this.maxVisitedNodesMultiplier = maxVisitedNodesMultiplier;
    }

    public boolean isStuck() {
        return this.isStuck;
    }
}

