/*
 * Decompiled with CFR 0.152.
 */
package travelers.server.animal.entity.pathingsystem.node.obj;

import it.unimi.dsi.fastutil.HashCommon;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import travelers.server.animal.entity.pathingsystem.node.obj.TravelersPathType;
import travelers.server.animal.entity.pathingsystem.node.obj.TravelersPathfindingContext;

public class TravelersPathTypeCache {
    private static final int SIZE = 1024;
    private final long[] positions = new long[1024];
    private final TravelersPathType[] pathTypes = new TravelersPathType[1024];

    private static int index(long pos) {
        return (int)HashCommon.mix((long)pos) & 0x3FF;
    }

    public TravelersPathType getOrCompute(BlockGetter level, BlockPos pos) {
        TravelersPathType cached;
        long packedPos = pos.asLong();
        int idx = TravelersPathTypeCache.index(packedPos);
        if (this.positions[idx] == packedPos && (cached = this.pathTypes[idx]) != null) {
            return cached;
        }
        TravelersPathType pt = TravelersPathfindingContext.getPathTypeFromState(level, pos);
        this.positions[idx] = packedPos;
        this.pathTypes[idx] = pt;
        return pt;
    }

    public void invalidate(BlockPos pos) {
        long packedPos = pos.asLong();
        int idx = TravelersPathTypeCache.index(packedPos);
        if (this.positions[idx] == packedPos) {
            this.pathTypes[idx] = null;
        }
    }
}

