/*
 * Decompiled with CFR 0.152.
 */
package travelers.client.render.animal.gecko;

import net.minecraft.class_1297;
import net.minecraft.class_1921;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5617;
import net.minecraft.class_7833;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoEntityRenderer;
import software.bernie.geckolib.util.RenderUtil;
import travelers.client.render.animal.gecko.TravelersGeckoModel;
import travelers.client.render.animation.entity.TravelersAnimationMap;
import travelers.client.render.animation.entity.obj.TravelersBoneState;
import travelers.client.render.animation.entity.obj.TravelersClientAnimator;
import travelers.server.animal.TravelersAnimal;
import travelers.server.animal.entity.GeckoSmartAnimalBase;
import travelers.server.animal.entity.SmartAnimalBase;

public class TravelersGeckoRenderer
extends GeoEntityRenderer<GeckoSmartAnimalBase> {
    private TravelersClientAnimator animalAnimator = null;
    private boolean checkForAnimator = true;
    private boolean hasAnimator = false;

    public TravelersGeckoRenderer(class_5617.class_5618 context, TravelersAnimal<? extends SmartAnimalBase> travelersAnimal) {
        super(context, (GeoModel)new TravelersGeckoModel(travelersAnimal));
    }

    public void preRender(class_4587 poseStack, GeckoSmartAnimalBase animatable, BakedGeoModel model, @Nullable class_4597 bufferSource, @Nullable class_4588 buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, int colour) {
        super.preRender(poseStack, (class_1297)animatable, model, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, colour);
        if (this.checkForAnimator) {
            this.getAnimalAnimator(animatable);
        }
        if (this.hasAnimator && !isReRender) {
            TravelersClientAnimator animator = this.getAnimalAnimator(animatable);
            animator.update(animatable, partialTick);
        }
    }

    public void renderRecursively(class_4587 poseStack, GeckoSmartAnimalBase animatable, GeoBone bone, class_1921 renderType, class_4597 bufferSource, class_4588 buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, int colour) {
        poseStack.method_22903();
        TravelersBoneState boneState = null;
        if (this.hasAnimator) {
            boneState = this.animalAnimator.updateAnimationOnBone(animatable, bone.getName());
        }
        RenderUtil.translateMatrixToBone((class_4587)poseStack, (GeoBone)bone);
        if (boneState != null) {
            poseStack.method_46416(boneState.offsetX / 16.0f, -boneState.offsetY / 16.0f, boneState.offsetZ / 16.0f);
        }
        RenderUtil.translateToPivotPoint((class_4587)poseStack, (GeoBone)bone);
        this.rotateMatrixAroundBone(poseStack, boneState, bone);
        RenderUtil.scaleMatrixForBone((class_4587)poseStack, (GeoBone)bone);
        if (bone.isTrackingMatrices()) {
            Matrix4f poseState = new Matrix4f((Matrix4fc)poseStack.method_23760().method_23761());
            Matrix4f localMatrix = RenderUtil.invertAndMultiplyMatrices((Matrix4f)poseState, (Matrix4f)this.entityRenderTranslations);
            bone.setModelSpaceMatrix(RenderUtil.invertAndMultiplyMatrices((Matrix4f)poseState, (Matrix4f)this.modelRenderTranslations));
            bone.setLocalSpaceMatrix(RenderUtil.translateMatrix((Matrix4f)localMatrix, (Vector3f)this.method_23169((class_1297)((GeckoSmartAnimalBase)this.animatable), 1.0f).method_46409()));
            bone.setWorldSpaceMatrix(RenderUtil.translateMatrix((Matrix4f)new Matrix4f((Matrix4fc)localMatrix), (Vector3f)((GeckoSmartAnimalBase)this.animatable).method_19538().method_46409()));
        }
        RenderUtil.translateAwayFromPivotPoint((class_4587)poseStack, (GeoBone)bone);
        buffer = this.checkAndRefreshBuffer(isReRender, buffer, bufferSource, renderType);
        this.renderCubesOfBone(poseStack, bone, buffer, packedLight, packedOverlay, colour);
        if (!isReRender) {
            this.applyRenderLayersForBone(poseStack, (GeoAnimatable)animatable, bone, renderType, bufferSource, buffer, partialTick, packedLight, packedOverlay);
        }
        this.renderChildBones(poseStack, (GeoAnimatable)animatable, bone, renderType, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, colour);
        poseStack.method_22909();
    }

    private void rotateMatrixAroundBone(class_4587 poseStack, TravelersBoneState boneState, GeoBone bone) {
        if (boneState == null) {
            poseStack.method_22907(class_7833.field_40718.rotation(bone.getRotZ()));
            poseStack.method_22907(class_7833.field_40716.rotation(bone.getRotY()));
            poseStack.method_22907(class_7833.field_40714.rotation(bone.getRotX()));
            return;
        }
        poseStack.method_22907(class_7833.field_40718.rotation(bone.getRotZ() + boneState.angleZ));
        poseStack.method_22907(class_7833.field_40716.rotation(bone.getRotY() + boneState.angleY));
        poseStack.method_22907(class_7833.field_40714.rotation(bone.getRotX() + boneState.angleX));
    }

    public TravelersClientAnimator getAnimalAnimator(SmartAnimalBase base) {
        if (this.animalAnimator == null && this.checkForAnimator) {
            this.animalAnimator = TravelersAnimationMap.get(base);
            this.hasAnimator = this.animalAnimator != null;
            this.checkForAnimator = false;
        }
        return this.animalAnimator;
    }
}

