/*
 * Decompiled with CFR 0.152.
 */
package travelers.server.animal.entity.pathingsystem.node;

import net.minecraft.class_1950;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import travelers.server.animal.entity.SmartAnimalBase;
import travelers.server.animal.entity.pathingsystem.node.TravelersNodeEvaluator;
import travelers.server.animal.entity.pathingsystem.node.TravelersWalkNodeEvaluator;
import travelers.server.animal.entity.pathingsystem.node.obj.TravelersNode;
import travelers.server.animal.entity.pathingsystem.node.obj.TravelersPathType;
import travelers.server.animal.entity.pathingsystem.node.obj.TravelersPathfindingContext;
import travelers.server.animal.entity.pathingsystem.node.obj.TravelersTarget;

public class TravelersAmphibiousNodeEvaluator
extends TravelersWalkNodeEvaluator {
    private final boolean prefersShallowSwimming;
    private float oldWalkableCost;
    private float oldWaterBorderCost;
    private final class_2338.class_2339 tmp = new class_2338.class_2339();
    private final class_2338.class_2339 tmp2 = new class_2338.class_2339();

    public TravelersAmphibiousNodeEvaluator(boolean prefersShallowSwimming) {
        this.prefersShallowSwimming = prefersShallowSwimming;
    }

    @Override
    public TravelersNodeEvaluator copy() {
        TravelersAmphibiousNodeEvaluator nodeEvaluator = new TravelersAmphibiousNodeEvaluator(this.prefersShallowSwimming);
        this.applyDefaultProperties(nodeEvaluator);
        nodeEvaluator.setCanClimb(this.isCanClimb());
        nodeEvaluator.setCanClimbAnyBlock(this.isCanClimbAnyBlock());
        return nodeEvaluator;
    }

    @Override
    public void prepare(@NotNull class_1950 level, @NotNull SmartAnimalBase mob) {
        super.prepare(level, mob);
        mob.setPathfindingMalus(TravelersPathType.WATER, 0.0f);
        this.oldWalkableCost = mob.getPathfindingMalus(TravelersPathType.WALKABLE);
        mob.setPathfindingMalus(TravelersPathType.WALKABLE, 6.0f);
        this.oldWaterBorderCost = mob.getPathfindingMalus(TravelersPathType.WATER_BORDER);
        mob.setPathfindingMalus(TravelersPathType.WATER_BORDER, 4.0f);
    }

    @Override
    public void done() {
        if (this.mob != null) {
            this.mob.setPathfindingMalus(TravelersPathType.WALKABLE, this.oldWalkableCost);
            this.mob.setPathfindingMalus(TravelersPathType.WATER_BORDER, this.oldWaterBorderCost);
        }
        super.done();
    }

    @Override
    @NotNull
    public TravelersNode getStart() {
        return !this.mob.method_5799() ? super.getStart() : this.getInnerStart();
    }

    @NotNull
    private TravelersNode getInnerStart() {
        class_238 box = this.mob.method_5829();
        double centerX = (box.field_1323 + box.field_1320) * 0.5;
        double centerY = (box.field_1322 + box.field_1325) * 0.5;
        double centerZ = (box.field_1321 + box.field_1324) * 0.5;
        int y = class_3532.method_15357((double)centerY);
        this.tmp.method_10102(centerX, (double)y, centerZ);
        class_2680 state = this.context.getBlockState((class_2338)this.tmp);
        if (!state.method_26227().method_39360((class_3611)class_3612.field_15910)) {
            boolean found = false;
            for (int dy = 1; dy <= 6; ++dy) {
                this.tmp.method_10102(centerX, (double)(y - dy), centerZ);
                if (this.context.getBlockState((class_2338)this.tmp).method_26227().method_39360((class_3611)class_3612.field_15910)) {
                    y -= dy;
                    found = true;
                    break;
                }
                this.tmp.method_10102(centerX, (double)(y + dy), centerZ);
                if (!this.context.getBlockState((class_2338)this.tmp).method_26227().method_39360((class_3611)class_3612.field_15910)) continue;
                y += dy;
                found = true;
                break;
            }
            if (!found) {
                y = class_3532.method_15357((double)this.mob.method_23318());
            }
        }
        this.tmp.method_33098(y);
        return this.getNode((class_2338)this.tmp);
    }

    @Override
    @NotNull
    public TravelersTarget getTarget(double x, double y, double z) {
        return this.getTargetNodeAt(x, y + 0.5, z);
    }

    @Override
    public int getNeighbors(TravelersNode @NotNull [] outputArray, TravelersNode p_node) {
        int i = super.getNeighbors(outputArray, p_node);
        TravelersPathType above = this.getPathType(p_node.x, p_node.y + 1, p_node.z);
        TravelersPathType at = this.getPathType(p_node.x, p_node.y, p_node.z);
        int stepAllowance = this.mob.getPathfindingMalus(above) >= 0.0f && at != TravelersPathType.STICKY_HONEY ? class_3532.method_15375((float)Math.max(1.0f, this.mob.method_49476())) : 0;
        this.tmp.method_10103(p_node.x, p_node.y, p_node.z);
        double floorY = this.getFloorLevel((class_2338)this.tmp);
        TravelersNode up = this.findAcceptedNode(p_node, p_node.x, p_node.y + 1, p_node.z, Math.max(0, stepAllowance - 1), floorY, class_2350.field_11036, at);
        TravelersNode down = this.findAcceptedNode(p_node, p_node.x, p_node.y - 1, p_node.z, stepAllowance, floorY, class_2350.field_11033, at);
        if (this.isVerticalNeighborValid(up, p_node)) {
            outputArray[i++] = up;
        }
        if (this.isVerticalNeighborValid(down, p_node) && at != TravelersPathType.TRAPDOOR) {
            outputArray[i++] = down;
        }
        if (this.prefersShallowSwimming) {
            int sea = this.mob.method_37908().method_8615();
            for (int k = 0; k < i; ++k) {
                TravelersNode n = outputArray[k];
                if (n == null || n.type != TravelersPathType.WATER || n.y >= sea - 10) continue;
                n.costMalus += 1.0f;
            }
        }
        return i;
    }

    private boolean isVerticalNeighborValid(@Nullable TravelersNode neighbor, TravelersNode node) {
        return neighbor != null && this.isNeighborValid(neighbor, node) && neighbor.type == TravelersPathType.WATER;
    }

    @Override
    protected boolean isAmphibious() {
        return this.isCanFloat();
    }

    @Override
    @NotNull
    public TravelersPathType getPathType(@NotNull TravelersPathfindingContext context, int x, int y, int z) {
        TravelersPathType at = context.getPathTypeFromState(x, y, z);
        if (at == TravelersPathType.WATER) {
            for (class_2350 dir : class_2350.values()) {
                this.tmp2.method_10103(x, y, z).method_10098(dir);
                TravelersPathType adj = context.getPathTypeFromState(this.tmp2.method_10263(), this.tmp2.method_10264(), this.tmp2.method_10260());
                if (adj != TravelersPathType.BLOCKED) continue;
                return TravelersPathType.WATER_BORDER;
            }
            return TravelersPathType.WATER;
        }
        return super.getPathType(context, x, y, z);
    }
}

